/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.core.impl.tasks.AbstractBundleTask;
import org.apache.sling.installer.core.impl.tasks.BundleUtil;
import org.apache.sling.installer.core.impl.tasks.TaskSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleStartTask
extends AbstractBundleTask {
    private static final String BUNDLE_START_ORDER = "70-";
    private final long bundleId;
    private final String sortKey;

    public BundleStartTask(TaskResourceGroup r, long bundleId, TaskSupport btc) {
        super(r, btc);
        this.bundleId = bundleId;
        this.sortKey = BUNDLE_START_ORDER + new DecimalFormat("00000").format(bundleId);
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": bundle " + this.bundleId;
    }

    @Override
    public void setFinishedState(ResourceState state, String alias, String error) {
        if (this.getResource() != null) {
            BundleUtil.clearBundleStart(this.getResource());
        }
        super.setFinishedState(state, alias, error);
    }

    @Override
    public void execute(InstallationContext ctx) {
        if (this.bundleId == 0L) {
            String message = "Bundle 0 is the framework bundle, ignoring request to start it";
            this.getLogger().debug(message);
            if (this.getResource() != null) {
                this.setFinishedState(ResourceState.INSTALLED, null, message);
            }
            return;
        }
        Bundle b = this.getBundleContext().getBundle(this.bundleId);
        if (b == null) {
            String message = MessageFormat.format("Cannot start bundle, id not found: {0}", this.bundleId);
            this.getLogger().debug(message);
            this.setFinishedState(ResourceState.IGNORED, null, message);
            return;
        }
        if (BundleUtil.isBundleActive(b)) {
            String message = MessageFormat.format("Bundle already started, no action taken: {0}", this.bundleId);
            this.getLogger().debug(message);
            this.setFinishedState(ResourceState.INSTALLED, null, message);
        } else {
            try {
                b.start();
                this.setFinishedState(ResourceState.INSTALLED);
                ctx.log("Started bundle {}", b);
            }
            catch (BundleException e) {
                this.getLogger().info("Could not start bundle {}. Reason: {}. Will retry.", new Object[]{b, e});
            }
        }
    }
}

