/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class UuidPredicate
implements Predicate<NodeState> {
    private final String[] uuids;

    public UuidPredicate(@NotNull String[] uuids) {
        this.uuids = Objects.requireNonNull(uuids);
    }

    @Override
    public boolean test(NodeState node) {
        if (this.uuids.length == 0) {
            return false;
        }
        PropertyState uuidProperty = node.getProperty("jcr:uuid");
        if (uuidProperty == null) {
            return false;
        }
        String parentUuid = uuidProperty.getValue(Type.STRING);
        for (String uuid : this.uuids) {
            if (!parentUuid.equals(uuid)) continue;
            return true;
        }
        return false;
    }
}

