/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.config.builders.TimeoutsBuilder;
import org.ehcache.clustered.client.internal.ClusterTierManagerClientEntity;
import org.ehcache.clustered.client.internal.ClusterTierManagerCreationException;
import org.ehcache.clustered.client.internal.ClusterTierManagerValidationException;
import org.ehcache.clustered.client.internal.lock.VoltronReadWriteLock;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.internal.store.ClusterTierUserData;
import org.ehcache.clustered.client.internal.store.InternalClusterTierClientEntity;
import org.ehcache.clustered.client.service.EntityBusyException;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ClusterTierManagerConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.exceptions.DestroyInProgressException;
import org.ehcache.clustered.common.internal.store.ClusterTierEntityConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.exception.PermanentEntityException;

public class ClusterTierManagerClientEntityFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierManagerClientEntityFactory.class);
    private final Connection connection;
    private final Map<String, VoltronReadWriteLock.Hold> maintenanceHolds = new ConcurrentHashMap<String, VoltronReadWriteLock.Hold>();
    private final Map<String, VoltronReadWriteLock.Hold> fetchHolds = new ConcurrentHashMap<String, VoltronReadWriteLock.Hold>();
    private final Timeouts entityTimeouts;

    public ClusterTierManagerClientEntityFactory(Connection connection) {
        this(connection, TimeoutsBuilder.timeouts().build());
    }

    public ClusterTierManagerClientEntityFactory(Connection connection, Timeouts entityTimeouts) {
        this.connection = connection;
        this.entityTimeouts = entityTimeouts;
    }

    public boolean acquireLeadership(String entityIdentifier) {
        VoltronReadWriteLock lock = this.createAccessLockFor(entityIdentifier);
        VoltronReadWriteLock.Hold hold = lock.tryWriteLock();
        if (hold == null) {
            return false;
        }
        this.maintenanceHolds.put(entityIdentifier, hold);
        return true;
    }

    public boolean abandonAllHolds(String entityIdentifier, boolean healthyConnection) {
        return this.abandonLeadership(entityIdentifier, healthyConnection) | this.abandonFetchHolds(entityIdentifier, healthyConnection);
    }

    public boolean abandonLeadership(String entityIdentifier, boolean healthyConnection) {
        VoltronReadWriteLock.Hold hold = this.maintenanceHolds.remove(entityIdentifier);
        return hold != null && healthyConnection && this.silentlyUnlock(hold, entityIdentifier);
    }

    private boolean abandonFetchHolds(String entityIdentifier, boolean healthyConnection) {
        VoltronReadWriteLock.Hold hold = this.fetchHolds.remove(entityIdentifier);
        return hold != null && healthyConnection && this.silentlyUnlock(hold, entityIdentifier);
    }

    public void create(String identifier, ServerSideConfiguration config) throws EntityAlreadyExistsException, ClusterTierManagerCreationException, EntityBusyException {
        VoltronReadWriteLock.Hold existingMaintenance = this.maintenanceHolds.get(identifier);
        try (VoltronReadWriteLock.Hold localMaintenance = existingMaintenance == null ? this.createAccessLockFor(identifier).tryWriteLock() : null;){
            if (localMaintenance == null && existingMaintenance == null) {
                throw new EntityBusyException("Unable to obtain maintenance lease for " + identifier);
            }
            EntityRef<ClusterTierManagerClientEntity, ClusterTierManagerConfiguration, ClusterTierUserData> ref = this.getEntityRef(identifier);
            try {
                ref.create((Object)new ClusterTierManagerConfiguration(identifier, config));
            }
            catch (EntityConfigurationException e) {
                throw new ClusterTierManagerCreationException("Unable to configure cluster tier manager for id " + identifier, e);
            }
            catch (EntityNotProvidedException | EntityVersionMismatchException e) {
                LOGGER.error("Unable to create cluster tier manager for id {}", (Object)identifier, (Object)e);
                throw new AssertionError((Object)e);
            }
        }
    }

    public ClusterTierManagerClientEntity retrieve(String identifier, ServerSideConfiguration config) throws DestroyInProgressException, EntityNotFoundException, ClusterTierManagerValidationException, TimeoutException {
        ClusterTierManagerClientEntity entity;
        VoltronReadWriteLock.Hold fetchHold = this.createAccessLockFor(identifier).readLock();
        try {
            entity = (ClusterTierManagerClientEntity)this.getEntityRef(identifier).fetchEntity(null);
        }
        catch (EntityVersionMismatchException e) {
            LOGGER.error("Unable to retrieve cluster tier manager for id {}", (Object)identifier, (Object)e);
            this.silentlyUnlock(fetchHold, identifier);
            throw new AssertionError((Object)e);
        }
        boolean validated = false;
        try {
            entity.validate(config);
            validated = true;
            ClusterTierManagerClientEntity clusterTierManagerClientEntity = entity;
            return clusterTierManagerClientEntity;
        }
        catch (DestroyInProgressException e) {
            throw e;
        }
        catch (ClusterException e) {
            throw new ClusterTierManagerValidationException("Unable to validate cluster tier manager for id " + identifier, e);
        }
        finally {
            if (!validated) {
                this.silentlyClose(entity, identifier);
                this.silentlyUnlock(fetchHold, identifier);
            } else {
                this.fetchHolds.put(identifier, fetchHold);
            }
        }
    }

    public void destroy(String identifier) throws EntityBusyException {
        VoltronReadWriteLock.Hold existingMaintenance = this.maintenanceHolds.get(identifier);
        try (VoltronReadWriteLock.Hold localMaintenance = existingMaintenance == null ? this.createAccessLockFor(identifier).tryWriteLock() : null;){
            if (localMaintenance == null && existingMaintenance == null) {
                throw new EntityBusyException("Unable to obtain maintenance lease for " + identifier);
            }
            EntityRef<ClusterTierManagerClientEntity, ClusterTierManagerConfiguration, ClusterTierUserData> ref = this.getEntityRef(identifier);
            this.destroyAllClusterTiers(ref, identifier);
            try {
                if (!ref.destroy()) {
                    throw new EntityBusyException("Destroy operation failed; " + identifier + " cluster tier in use by other clients");
                }
            }
            catch (EntityNotProvidedException e) {
                LOGGER.error("Unable to delete cluster tier manager for id {}", (Object)identifier, (Object)e);
                throw new AssertionError((Object)e);
            }
            catch (EntityNotFoundException e) {
            }
            catch (PermanentEntityException e) {
                LOGGER.error("Unable to destroy entity - server says it is permanent", (Throwable)e);
                throw new AssertionError((Object)e);
            }
        }
    }

    private void destroyAllClusterTiers(EntityRef<ClusterTierManagerClientEntity, ClusterTierManagerConfiguration, ClusterTierUserData> ref, String identifier) {
        ClusterTierManagerClientEntity entity;
        try {
            entity = (ClusterTierManagerClientEntity)ref.fetchEntity(null);
        }
        catch (EntityNotFoundException e) {
            return;
        }
        catch (EntityVersionMismatchException e) {
            throw new AssertionError((Object)e);
        }
        Set<String> storeIdentifiers = entity.prepareForDestroy();
        LOGGER.warn("Preparing to destroy stores {}", storeIdentifiers);
        for (String storeIdentifier : storeIdentifiers) {
            try {
                this.destroyClusteredStoreEntity(identifier, storeIdentifier);
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
            catch (CachePersistenceException e) {
                throw new AssertionError((Object)("Unable to destroy cluster tier - in use: " + e.getMessage()));
            }
        }
        entity.close();
    }

    private void silentlyClose(ClusterTierManagerClientEntity entity, String identifier) {
        try {
            entity.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close entity {}", (Object)identifier, (Object)e);
        }
    }

    private boolean silentlyUnlock(VoltronReadWriteLock.Hold localMaintenance, String identifier) {
        try {
            localMaintenance.unlock();
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to unlock for id {}", (Object)identifier, (Object)e);
            return false;
        }
    }

    private VoltronReadWriteLock createAccessLockFor(String entityIdentifier) {
        return new VoltronReadWriteLock(this.connection, "ClusterTierManagerClientEntityFactory-AccessLock-" + entityIdentifier);
    }

    private EntityRef<ClusterTierManagerClientEntity, ClusterTierManagerConfiguration, ClusterTierUserData> getEntityRef(String identifier) {
        try {
            return this.connection.getEntityRef(ClusterTierManagerClientEntity.class, 10L, identifier);
        }
        catch (EntityNotProvidedException e) {
            LOGGER.error("Unable to get cluster tier manager for id {}", (Object)identifier, (Object)e);
            throw new AssertionError((Object)e);
        }
    }

    public ClusterTierClientEntity fetchOrCreateClusteredStoreEntity(String clusterTierManagerIdentifier, String storeIdentifier, ServerStoreConfiguration clientStoreConfiguration, boolean autoCreate) throws EntityNotFoundException, CachePersistenceException {
        EntityRef entityRef;
        try {
            entityRef = this.connection.getEntityRef(InternalClusterTierClientEntity.class, 10L, ClusterTierManagerClientEntityFactory.entityName(clusterTierManagerIdentifier, storeIdentifier));
        }
        catch (EntityNotProvidedException e) {
            throw new AssertionError((Object)e);
        }
        if (autoCreate) {
            while (true) {
                try {
                    entityRef.create((Object)new ClusterTierEntityConfiguration(clusterTierManagerIdentifier, storeIdentifier, clientStoreConfiguration));
                }
                catch (EntityAlreadyExistsException e) {
                }
                catch (EntityConfigurationException e) {
                    throw new CachePersistenceException("Unable to create cluster tier", (Throwable)e);
                }
                catch (EntityException e) {
                    throw new AssertionError((Object)e);
                }
                try {
                    return (ClusterTierClientEntity)entityRef.fetchEntity((Object)new ClusterTierUserData(this.entityTimeouts, storeIdentifier));
                }
                catch (EntityNotFoundException e) {
                    continue;
                }
                catch (EntityException e) {
                    throw new AssertionError((Object)e);
                }
                break;
            }
        }
        return this.fetchClusterTierClientEntity(storeIdentifier, (EntityRef<InternalClusterTierClientEntity, ClusterTierEntityConfiguration, ClusterTierUserData>)entityRef);
    }

    public ClusterTierClientEntity getClusterTierClientEntity(String clusterTierManagerIdentifier, String storeIdentifier) throws EntityNotFoundException {
        EntityRef entityRef;
        try {
            entityRef = this.connection.getEntityRef(InternalClusterTierClientEntity.class, 10L, ClusterTierManagerClientEntityFactory.entityName(clusterTierManagerIdentifier, storeIdentifier));
        }
        catch (EntityNotProvidedException e) {
            throw new AssertionError((Object)e);
        }
        return this.fetchClusterTierClientEntity(storeIdentifier, (EntityRef<InternalClusterTierClientEntity, ClusterTierEntityConfiguration, ClusterTierUserData>)entityRef);
    }

    private ClusterTierClientEntity fetchClusterTierClientEntity(String storeIdentifier, EntityRef<InternalClusterTierClientEntity, ClusterTierEntityConfiguration, ClusterTierUserData> entityRef) throws EntityNotFoundException {
        try {
            return (ClusterTierClientEntity)entityRef.fetchEntity((Object)new ClusterTierUserData(this.entityTimeouts, storeIdentifier));
        }
        catch (EntityNotFoundException e) {
            throw e;
        }
        catch (EntityException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void destroyClusteredStoreEntity(String clusterTierManagerIdentifier, String storeIdentifier) throws EntityNotFoundException, CachePersistenceException {
        try {
            EntityRef entityRef = this.connection.getEntityRef(InternalClusterTierClientEntity.class, 10L, ClusterTierManagerClientEntityFactory.entityName(clusterTierManagerIdentifier, storeIdentifier));
            if (!entityRef.destroy()) {
                throw new CachePersistenceException("Cannot destroy cluster tier '" + storeIdentifier + "': in use by other client(s)");
            }
        }
        catch (EntityNotProvidedException | PermanentEntityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String entityName(String clusterTierManagerIdentifier, String storeIdentifier) {
        return clusterTierManagerIdentifier + "$" + storeIdentifier;
    }

    public Map<String, VoltronReadWriteLock.Hold> getMaintenanceHolds() {
        return this.maintenanceHolds;
    }
}

