/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.batch.api.BatchPart;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class GetBatchPartDocumentCmd
implements Command<String> {
    protected String batchPartId;

    public GetBatchPartDocumentCmd(String batchPartId) {
        this.batchPartId = batchPartId;
    }

    public String execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        BatchPart batchPart = processEngineConfiguration.getBatchServiceConfiguration().getBatchService().getBatchPart(this.batchPartId);
        if (batchPart == null) {
            throw new FlowableObjectNotFoundException("No batch part found for id " + this.batchPartId);
        }
        return batchPart.getResultDocumentJson(processEngineConfiguration.getEngineCfgKey());
    }
}

