/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull.stream;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Mapping;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPushExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PushResultHandlerDispatcher;
import org.apache.syncope.core.provisioning.java.pushpull.stream.StreamAnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.stream.StreamGroupPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.stream.StreamUserPushResultHandler;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class StreamPushJobDelegate
extends PushJobDelegate
implements SyncopeStreamPushExecutor {
    @Autowired
    private ImplementationDAO implementationDAO;

    @Override
    protected AnyObjectPushResultHandler buildAnyObjectHandler() {
        return (AnyObjectPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(StreamAnyObjectPushResultHandler.class, 1, false);
    }

    @Override
    protected UserPushResultHandler buildUserHandler() {
        return (UserPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(StreamUserPushResultHandler.class, 1, false);
    }

    @Override
    protected GroupPushResultHandler buildGroupHandler() {
        return (GroupPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(StreamGroupPushResultHandler.class, 1, false);
    }

    private ExternalResource externalResource(AnyType anyType, List<String> columns, List<String> propagationActions) throws JobExecutionException {
        Provision provision = new Provision();
        provision.setAnyType(anyType.getKey());
        provision.setObjectClass(anyType.getKey());
        Mapping mapping = new Mapping();
        provision.setMapping(mapping);
        Item connObjectKeyItem = new Item();
        connObjectKeyItem.setExtAttrName("key");
        connObjectKeyItem.setIntAttrName("key");
        connObjectKeyItem.setPurpose(MappingPurpose.NONE);
        mapping.setConnObjectKeyItem(connObjectKeyItem);
        columns.stream().map(column -> {
            Item item = new Item();
            item.setExtAttrName(column);
            item.setIntAttrName(column);
            item.setPurpose(MappingPurpose.PROPAGATION);
            mapping.add(item);
            return item;
        }).forEach(arg_0 -> ((Mapping)mapping).add(arg_0));
        ExternalResource resource = (ExternalResource)this.entityFactory.newEntity(ExternalResource.class);
        resource.setKey("StreamPush_" + SecureRandomUtils.generateRandomUUID().toString());
        resource.getProvisions().add(provision);
        propagationActions.forEach(key -> {
            Implementation impl = this.implementationDAO.find(key);
            if (impl == null || !"PROPAGATION_ACTIONS".equals(impl.getType())) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", key);
            } else {
                resource.add(impl);
            }
        });
        return resource;
    }

    public List<ProvisioningReport> push(AnyType anyType, List<? extends Any<?>> anys, List<String> columns, Connector connector, List<String> propagationActions, PushTaskTO pushTaskTO, String executor) throws JobExecutionException {
        LOG.debug("Executing stream push as {}", (Object)executor);
        this.taskType = TaskType.PUSH;
        try {
            ExternalResource resource = this.externalResource(anyType, columns, propagationActions);
            this.task = (SchedTask)this.entityFactory.newEntity(PushTask.class);
            ((PushTask)this.task).setResource(resource);
            ((PushTask)this.task).setMatchingRule(pushTaskTO.getMatchingRule());
            ((PushTask)this.task).setUnmatchingRule(pushTaskTO.getUnmatchingRule());
            ((PushTask)this.task).setPerformCreate(true);
            ((PushTask)this.task).setPerformUpdate(true);
            ((PushTask)this.task).setPerformDelete(true);
            ((PushTask)this.task).setSyncStatus(false);
            this.profile = new ProvisioningProfile(connector, (ProvisioningTask)((PushTask)this.task));
            this.profile.setExecutor(executor);
            this.profile.getActions().addAll(this.getPushActions(pushTaskTO.getActions().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList())));
            this.profile.setConflictResolutionAction(ConflictResolutionAction.FIRSTMATCH);
            PushResultHandlerDispatcher dispatcher = new PushResultHandlerDispatcher((ProvisioningProfile<PushTask, PushActions>)this.profile, this);
            for (PushActions action : this.profile.getActions()) {
                action.beforeAll(this.profile);
            }
            dispatcher.addHandlerSupplier(anyType.getKey(), () -> {
                UserPushResultHandler handler;
                switch (anyType.getKind()) {
                    case USER: {
                        handler = this.buildUserHandler();
                        break;
                    }
                    case GROUP: {
                        handler = this.buildGroupHandler();
                        break;
                    }
                    default: {
                        handler = this.buildAnyObjectHandler();
                    }
                }
                handler.setProfile(this.profile);
                return handler;
            });
            this.doHandle(anys, dispatcher, resource);
            for (PushActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            List list = this.profile.getResults();
            return list;
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While stream pushing", (Throwable)e);
        }
        finally {
            this.setStatus(null);
        }
    }
}

