/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.List;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;

public abstract class AbstractLiquibaseDynamicRule
extends AbstractLiquibaseRule {
    @Override
    public final boolean evaluate(Facts object) {
        ChangeSet changeSet = this.getChangeSetFromFacts((Facts)object);
        if (changeSet == null || !this.shouldBeEvaluated(changeSet)) {
            return this.setResultSuccessful(false, null);
        }
        if (!this.validateParameters((DynamicRule)(object = (DynamicRule)this.getAbstractConfigurableRuleFromFacts((Facts)object)))) {
            return this.setResultUnsuccessful("Validation failed on the parameters for this rule.", (DynamicRule)object);
        }
        return this.internalEvaluate(changeSet, (DynamicRule)object);
    }

    private boolean validateParameters(DynamicRule object) {
        List<DynamicRuleParameter> list = ((DynamicRule)object).getParameters();
        if (list == null || list.size() == 0) {
            object = String.format("Rule instance %s has no value parameters.  No check performed", ((DynamicRule)object).getName());
            Scope.getCurrentScope().getLog(this.getClass()).warning((String)object);
            return false;
        }
        if ((long)list.size() < this.getParameters().stream().filter(ruleParameter -> ruleParameter.getShouldPrompt() == null).count()) {
            object = String.format("Rule instance %s has some missing value parameters.  No check performed." + System.lineSeparator() + "Run checks customize to supply values for the missing parameters.", ((DynamicRule)object).getName());
            Scope.getCurrentScope().getLog(this.getClass()).warning((String)object);
            return false;
        }
        return true;
    }

    public abstract boolean internalEvaluate(ChangeSet var1, DynamicRule var2);
}

