/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.credential.BaseGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.util.crypto.CipherExecutor;

public class InMemoryGoogleAuthenticatorTokenCredentialRepository
extends BaseGoogleAuthenticatorTokenCredentialRepository {
    private final Map<String, List<OneTimeTokenAccount>> accounts = new ConcurrentHashMap<String, List<OneTimeTokenAccount>>();

    public InMemoryGoogleAuthenticatorTokenCredentialRepository(CipherExecutor<String, String> tokenCredentialCipher, CipherExecutor<Number, Number> scratchCodesCipher, IGoogleAuthenticator googleAuthenticator) {
        super(tokenCredentialCipher, scratchCodesCipher, googleAuthenticator);
    }

    public OneTimeTokenAccount get(String username, long id) {
        return this.get(username).stream().filter(ac -> ac.getId() == id).findFirst().orElse(null);
    }

    public OneTimeTokenAccount get(long id) {
        return this.accounts.values().stream().flatMap(Collection::stream).filter(ac -> ac.getId() == id).findFirst().orElse(null);
    }

    public Collection<? extends OneTimeTokenAccount> get(String userName) {
        if (this.contains(userName)) {
            List<OneTimeTokenAccount> account = this.accounts.get(userName.toLowerCase().trim());
            return this.decode(account);
        }
        return new ArrayList(0);
    }

    public OneTimeTokenAccount save(OneTimeTokenAccount account) {
        OneTimeTokenAccount encoded = this.encode(account);
        List records = this.accounts.getOrDefault(account.getUsername().trim().toLowerCase(), new ArrayList());
        records.add(encoded);
        this.accounts.put(account.getUsername(), records);
        return encoded;
    }

    public OneTimeTokenAccount update(OneTimeTokenAccount account) {
        OneTimeTokenAccount encoded = this.encode(account);
        if (this.accounts.containsKey(account.getUsername().toLowerCase().trim())) {
            List<OneTimeTokenAccount> records = this.accounts.get(account.getUsername().toLowerCase().trim());
            records.stream().filter(rec -> rec.getId() == account.getId()).findFirst().ifPresent(act -> {
                act.setSecretKey(account.getSecretKey());
                act.setScratchCodes(account.getScratchCodes());
                act.setValidationCode(account.getValidationCode());
            });
        }
        return encoded;
    }

    public void deleteAll() {
        this.accounts.clear();
    }

    public void delete(String username) {
        this.accounts.remove(username.toLowerCase().trim());
    }

    public void delete(long id) {
        this.accounts.forEach((key, value) -> value.removeIf(d -> d.getId() == id));
    }

    public long count() {
        return this.accounts.size();
    }

    public long count(String username) {
        return this.get(username.toLowerCase().trim()).size();
    }

    public Collection<? extends OneTimeTokenAccount> load() {
        return this.accounts.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean contains(String username) {
        return this.accounts.containsKey(username.toLowerCase().trim());
    }

    @Generated
    public Map<String, List<OneTimeTokenAccount>> getAccounts() {
        return this.accounts;
    }
}

