/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.context;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.pac4j.saml.transport.DefaultPac4jSAMLResponse;
import org.pac4j.saml.util.SAML2Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ContextProvider
implements SAMLContextProvider {
    private static final String SAML2_WEBSSO_PROFILE_URI = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
    protected static final Logger logger = LoggerFactory.getLogger(SAML2ContextProvider.class);
    protected final SAML2MetadataResolver idpEntityId;
    protected final SAML2MetadataResolver spEntityId;
    protected final SAMLMessageStoreFactory samlMessageStoreFactory;

    public SAML2ContextProvider(SAML2MetadataResolver idpEntityId, SAML2MetadataResolver spEntityId, @Nullable SAMLMessageStoreFactory samlMessageStoreFactory) {
        this.idpEntityId = idpEntityId;
        this.spEntityId = spEntityId;
        this.samlMessageStoreFactory = samlMessageStoreFactory;
    }

    @Override
    public final SAML2MessageContext buildServiceProviderContext(SAML2Client client, WebContext webContext, SessionStore sessionStore) {
        SAML2MessageContext context = new SAML2MessageContext();
        context.setSaml2Configuration(client.getConfiguration());
        this.addTransportContext(webContext, sessionStore, context);
        this.addSPContext(context);
        return context;
    }

    @Override
    public SAML2MessageContext buildContext(SAML2Client client, WebContext webContext, SessionStore sessionStore) {
        SAML2MessageContext context = this.buildServiceProviderContext(client, webContext, sessionStore);
        this.addIDPContext(context);
        context.setWebContext(webContext);
        context.setSessionStore(sessionStore);
        return context;
    }

    protected final void addTransportContext(WebContext webContext, SessionStore sessionStore, SAML2MessageContext context) {
        ProfileRequestContext profile = context.getProfileRequestContext();
        profile.setOutboundMessageContext(this.prepareOutboundMessageContext(webContext));
        context.getSAMLProtocolContext().setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        ProfileRequestContext request = context.getProfileRequestContext();
        request.setProfileId(SAML2_WEBSSO_PROFILE_URI);
        if (this.samlMessageStoreFactory != null) {
            logger.debug("Creating message store by {}", (Object)this.samlMessageStoreFactory.getClass().getName());
            context.setSAMLMessageStore(this.samlMessageStoreFactory.getMessageStore(webContext, sessionStore));
        }
    }

    protected MessageContext prepareOutboundMessageContext(WebContext webContext) {
        DefaultPac4jSAMLResponse outTransport = new DefaultPac4jSAMLResponse(webContext);
        MessageContext outCtx = new MessageContext();
        outCtx.setMessage((Object)outTransport);
        return outCtx;
    }

    protected final void addSPContext(SAML2MessageContext context) {
        SAMLSelfEntityContext selfContext = context.getSAMLSelfEntityContext();
        selfContext.setEntityId(this.spEntityId.getEntityId());
        selfContext.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.addContext(this.spEntityId, (BaseContext)selfContext, SPSSODescriptor.DEFAULT_ELEMENT_NAME);
    }

    protected final void addIDPContext(SAML2MessageContext context) {
        SAMLPeerEntityContext peerContext = context.getSAMLPeerEntityContext();
        peerContext.setEntityId(this.idpEntityId.getEntityId());
        peerContext.setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.addContext(this.idpEntityId, (BaseContext)peerContext, IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
    }

    protected final void addContext(SAML2MetadataResolver metadata, BaseContext parentContext, QName elementName) {
        RoleDescriptor roleDescriptor;
        EntityDescriptor entityDescriptor;
        try {
            CriteriaSet set = new CriteriaSet();
            String entityId = metadata.getEntityId();
            set.add((Object)new EntityIdCriterion(entityId));
            entityDescriptor = SAML2Utils.buildChainingMetadataResolver(this.idpEntityId, this.spEntityId).resolveSingle(set);
            if (entityDescriptor == null) {
                throw new SAMLException("Cannot find entity " + entityId + " in metadata provider");
            }
            List list = entityDescriptor.getRoleDescriptors(elementName, "urn:oasis:names:tc:SAML:2.0:protocol");
            RoleDescriptor roleDescriptor2 = roleDescriptor = CommonHelper.isNotEmpty((Collection)list) ? (RoleDescriptor)list.get(0) : null;
            if (roleDescriptor == null) {
                throw new SAMLException("Cannot find entity " + entityId + " or role " + elementName + " in metadata provider");
            }
        }
        catch (ResolverException e) {
            throw new SAMLException("An error occurred while getting IDP descriptors", e);
        }
        SAMLMetadataContext mdCtx = (SAMLMetadataContext)parentContext.getSubcontext(SAMLMetadataContext.class, true);
        mdCtx.setEntityDescriptor(entityDescriptor);
        mdCtx.setRoleDescriptor(roleDescriptor);
    }
}

