/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.ThreadPoolReportingAsynchronousRunner;
import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.SQLWarnings;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.c3p0.impl.AbstractC3P0PooledConnection;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.ConnectionTestPath;
import com.mchange.v2.c3p0.impl.ConnectionTesterConnectionTestPath;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.DefaultConnectionTester;
import com.mchange.v2.c3p0.impl.IsValidSimplifiedConnectionTestPath;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import com.mchange.v2.c3p0.stmt.DoubleMaxStatementCache;
import com.mchange.v2.c3p0.stmt.GlobalMaxOnlyStatementCache;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.stmt.PerConnectionMaxOnlyStatementCache;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPool {
    private static final boolean ASYNCHRONOUS_CONNECTION_EVENT_LISTENER = false;
    static final MLogger logger = MLog.getLogger(C3P0PooledConnectionPool.class);
    final ResourcePool rp;
    final ConnectionEventListener cl = new ConnectionEventListenerImpl();
    final ConnectionTester connectionTester;
    final GooGooStatementCache scache;
    final Resurrectables resurrectables;
    final boolean c3p0PooledConnections;
    final int checkoutTimeout;
    final int connectionIsValidTimeout;
    final boolean disableSessionBoundaries;
    final AsynchronousRunner sharedTaskRunner;
    final AsynchronousRunner deferredStatementDestroyer;
    final AbstractInternalUseLockManager internalUseLockManager;
    private RequestBoundaryMarker requestBoundaryMarker;
    private static RequestBoundaryMarker NO_OP_REQUEST_BOUNDARY_MARKER = new RequestBoundaryMarker(){

        @Override
        public void attemptNotifyBeginRequest(PooledConnection pooledConnection) {
        }

        @Override
        public void attemptNotifyEndRequest(PooledConnection pooledConnection) {
        }
    };
    private static RequestBoundaryMarker INTERFACE_REQUEST_BOUNDARY_MARKER = new RequestBoundaryMarker(){

        @Override
        public void attemptNotifyBeginRequest(PooledConnection pooledConnection) {
            block6: {
                if (pooledConnection instanceof AbstractC3P0PooledConnection) {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    try {
                        connection.beginRequest();
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.log(MLevel.FINEST, "beginRequest method called");
                        }
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, "AbstractMethodError invoking beginRequest method for Connction, even though Connections were tested for the presence of this method previously.", abstractMethodError);
                        }
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(MLevel.WARNING)) break block6;
                        logger.log(MLevel.WARNING, "Error invoking beginRequest method for connection", exception);
                    }
                }
            }
        }

        @Override
        public void attemptNotifyEndRequest(PooledConnection pooledConnection) {
            block6: {
                if (pooledConnection instanceof AbstractC3P0PooledConnection) {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    try {
                        connection.endRequest();
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.log(MLevel.FINEST, "endRequest method called");
                        }
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, "AbstractMethodError invoking endRequest method for Connction, even though Connections were tested for the presence of this method previously.", abstractMethodError);
                        }
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(MLevel.WARNING)) break block6;
                        logger.log(MLevel.WARNING, "Error invoking endRequest method for connection", exception);
                    }
                }
            }
        }
    };

    public int getStatementDestroyerNumConnectionsInUse() {
        return this.scache == null ? -1 : this.scache.getStatementDestroyerNumConnectionsInUse();
    }

    public int getStatementDestroyerNumConnectionsWithDeferredDestroyStatements() {
        return this.scache == null ? -1 : this.scache.getStatementDestroyerNumConnectionsWithDeferredDestroyStatements();
    }

    public int getStatementDestroyerNumDeferredDestroyStatements() {
        return this.scache == null ? -1 : this.scache.getStatementDestroyerNumDeferredDestroyStatements();
    }

    private synchronized RequestBoundaryMarker findRequestBoundaryMarker(PooledConnection pooledConnection) {
        block26: {
            if (this.requestBoundaryMarker != null) {
                return this.requestBoundaryMarker;
            }
            if (this.disableSessionBoundaries) {
                this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "Installed no-op request boundary marker due to markSessionBoundaries setting.");
                }
            } else {
                if (pooledConnection instanceof AbstractC3P0PooledConnection) {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    try {
                        boolean bl;
                        Method method = connection.getClass().getMethod("beginRequest", new Class[0]);
                        Method method2 = connection.getClass().getMethod("endRequest", new Class[0]);
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.log(MLevel.FINEST, "Request boundary methods found.");
                        }
                        try {
                            Method method3 = Connection.class.getMethod("beginRequest", new Class[0]);
                            Method method4 = Connection.class.getMethod("endRequest", new Class[0]);
                            if (logger.isLoggable(MLevel.FINEST)) {
                                logger.log(MLevel.FINEST, "Interface request boundary methods found.");
                            }
                            bl = true;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            bl = false;
                        }
                        if (bl) {
                            this.requestBoundaryMarker = INTERFACE_REQUEST_BOUNDARY_MARKER;
                            if (logger.isLoggable(MLevel.FINE)) {
                                logger.log(MLevel.FINE, "Installed interface-based request boundary marker.");
                            }
                        } else {
                            this.requestBoundaryMarker = new ReflectiveRequestBoundaryMarker(method, method2);
                            if (logger.isLoggable(MLevel.FINE)) {
                                logger.log(MLevel.FINE, "Installed reflective request boundary marker.");
                            }
                        }
                        break block26;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, "Request boundary methods not found.");
                        }
                        this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
                        if (logger.isLoggable(MLevel.FINE)) {
                            logger.log(MLevel.FINE, "Installed no-op request boundary marker, because request boundary methods not found.");
                        }
                        break block26;
                    }
                    catch (SecurityException securityException) {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, "Could not make boundary methods accessible.");
                        }
                        if (logger.isLoggable(MLevel.FINE)) {
                            logger.log(MLevel.FINE, "SecurityException:", securityException);
                        }
                        this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
                        if (logger.isLoggable(MLevel.FINE)) {
                            logger.log(MLevel.FINE, "Installed no-op request boundary marker, because request boundary methods could not be made accessible.");
                        }
                        break block26;
                    }
                    catch (Exception exception) {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, "An unexpected Exception occurred while querying request boundary methods.", exception);
                        }
                        this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
                        if (logger.isLoggable(MLevel.FINE)) {
                            logger.log(MLevel.FINE, "Installed no-op request boundary marker, because an unexpected exception occurred while querying request boundary methods.");
                        }
                        break block26;
                    }
                }
                this.requestBoundaryMarker = NO_OP_REQUEST_BOUNDARY_MARKER;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Could not mark request boundaries when pooling non-c3p0 PooledConnections.");
                }
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "Installed no-op request boundary marker, because we are working with non-c3p0 pooled connections, and do not support request boundary marking in this case.");
                }
            }
        }
        return this.requestBoundaryMarker;
    }

    private void markBeginRequest(PooledConnection pooledConnection) {
        this.findRequestBoundaryMarker(pooledConnection).attemptNotifyBeginRequest(pooledConnection);
    }

    private void markEndRequest(PooledConnection pooledConnection) {
        this.findRequestBoundaryMarker(pooledConnection).attemptNotifyEndRequest(pooledConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C3P0PooledConnectionPool(final ConnectionPoolDataSource connectionPoolDataSource, final DbAuth dbAuth, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, final int n8, int n9, int n10, int n11, int n12, int n13, int n14, boolean bl2, boolean bl3, final boolean bl4, final boolean bl5, boolean bl6, int n15, int n16, String string, final ConnectionTester connectionTester, final ConnectionCustomizer connectionCustomizer, final String string2, ResourcePoolFactory resourcePoolFactory, ThreadPoolReportingAsynchronousRunner threadPoolReportingAsynchronousRunner, ThreadPoolReportingAsynchronousRunner threadPoolReportingAsynchronousRunner2, final String string3) throws SQLException {
        try {
            this.c3p0PooledConnections = connectionPoolDataSource instanceof WrapperConnectionPoolDataSource;
            if (!this.c3p0PooledConnections) {
                if (logger.isLoggable(MLevel.WARNING) && (n15 > 0 || n16 > 0)) {
                    logger.log(MLevel.WARNING, "Statement caching is configured, but cannot be supported, because the provided ConnectionPoolDataSource is not a c3p0 implementation. Initializing with no statement cache.");
                }
                this.scache = null;
            } else {
                this.scache = n15 > 0 && n16 > 0 ? new DoubleMaxStatementCache(threadPoolReportingAsynchronousRunner, threadPoolReportingAsynchronousRunner2, n15, n16) : (n16 > 0 ? new PerConnectionMaxOnlyStatementCache(threadPoolReportingAsynchronousRunner, threadPoolReportingAsynchronousRunner2, n16) : (n15 > 0 ? new GlobalMaxOnlyStatementCache(threadPoolReportingAsynchronousRunner, threadPoolReportingAsynchronousRunner2, n15) : null));
            }
            this.resurrectables = bl6 ? new Resurrectables() : null;
            this.connectionTester = connectionTester;
            this.checkoutTimeout = n7;
            this.connectionIsValidTimeout = n8;
            this.sharedTaskRunner = threadPoolReportingAsynchronousRunner;
            this.deferredStatementDestroyer = threadPoolReportingAsynchronousRunner2;
            if ("always".equalsIgnoreCase(string)) {
                this.disableSessionBoundaries = false;
            } else if ("never".equalsIgnoreCase(string)) {
                this.disableSessionBoundaries = true;
            } else if ("if-no-statement-cache".equalsIgnoreCase(string)) {
                this.disableSessionBoundaries = this.scache != null;
            } else {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "markSessionBoundaries should be one of 'always','never', or 'if-no-statement-cache'. Found illegal value '" + string + "'. Defaulting to 'always'.");
                }
                this.disableSessionBoundaries = false;
            }
            this.internalUseLockManager = this.c3p0PooledConnections ? new C3P0PooledConnectionNestedLockInternalUseLockManager() : new WeakHashMapInternalUseLockManager();
            class PooledConnectionResourcePoolManager
            implements ResourcePool.Manager {
                ConnectionTestPath connectionTestPath;

                PooledConnectionResourcePoolManager() {
                }

                void initAfterResourcePoolConstructed() {
                    if (connectionTester == null) {
                        if (string2 != null) {
                            if (n8 == C3P0Defaults.connectionIsValidTimeout()) {
                                if (logger.isLoggable(MLevel.WARNING)) {
                                    logger.log(MLevel.WARNING, "Although no ConnectionTester is set, preferredTestQuery (or automaticTestTable) is also set, which can only be supported by a ConnectionTester. Reverting to use of ConnectionTester com.mchange.v2.c3p0.impl.DefaultConnectionTester.");
                                }
                                this.connectionTestPath = new ConnectionTesterConnectionTestPath(C3P0PooledConnectionPool.this.rp, C3P0Registry.getConnectionTester(DefaultConnectionTester.class.getName()), C3P0PooledConnectionPool.this.scache, string2, C3P0PooledConnectionPool.this.c3p0PooledConnections);
                            } else {
                                if (logger.isLoggable(MLevel.WARNING)) {
                                    logger.log(MLevel.WARNING, "Both a preferredTestQuery (or automaticTestTable) and a non-default value of connectionIsValidTimeout are set, but only one can be simultaneously supported. Will use Connection.isValid( connectionIsValidTimeout ), and ignore test query '" + string2 + "'.");
                                }
                                this.connectionTestPath = new IsValidSimplifiedConnectionTestPath(C3P0PooledConnectionPool.this.rp, n8);
                            }
                        } else {
                            this.connectionTestPath = new IsValidSimplifiedConnectionTestPath(C3P0PooledConnectionPool.this.rp, n8);
                        }
                    } else {
                        if (logger.isLoggable(MLevel.WARNING) && n8 != C3P0Defaults.connectionIsValidTimeout()) {
                            logger.log(MLevel.WARNING, "A ConnectionTester '" + connectionTester + "' is explicitly set, but also a nondefault connectionIsValidTimeout (" + n8 + "). Unfortunately connectionIsValidTimeout is not supported by ConnectionTesters, and will be ignored. If you are using com.mchange.v2.c3p0.impl.DefaultConnectionTester, you may set config or system property com.mchange.v2.c3p0.impl.DefaultConnectionTester.isValidTimeout instead. Alternatively, just switch to simple isValid(...) testing by setting connectionTesterClassName to null");
                        }
                        this.connectionTestPath = new ConnectionTesterConnectionTestPath(C3P0PooledConnectionPool.this.rp, connectionTester, C3P0PooledConnectionPool.this.scache, string2, C3P0PooledConnectionPool.this.c3p0PooledConnections);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object acquireResource() throws Exception {
                    Object object;
                    PooledConnection pooledConnection;
                    if (connectionCustomizer == null) {
                        pooledConnection = dbAuth.equals(C3P0ImplUtils.NULL_AUTH) ? connectionPoolDataSource.getPooledConnection() : connectionPoolDataSource.getPooledConnection(dbAuth.getUser(), dbAuth.getPassword());
                    } else {
                        try {
                            object = (WrapperConnectionPoolDataSourceBase)((Object)connectionPoolDataSource);
                            pooledConnection = dbAuth.equals(C3P0ImplUtils.NULL_AUTH) ? ((WrapperConnectionPoolDataSourceBase)object).getPooledConnection(connectionCustomizer, string3) : ((WrapperConnectionPoolDataSourceBase)object).getPooledConnection(dbAuth.getUser(), dbAuth.getPassword(), connectionCustomizer, string3);
                        }
                        catch (ClassCastException classCastException) {
                            String string = "Cannot use a ConnectionCustomizer with a non-c3p0 ConnectionPoolDataSource. ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName();
                            throw SqlUtils.toSQLException(string, classCastException);
                        }
                    }
                    try {
                        if (C3P0PooledConnectionPool.this.scache != null) {
                            if (C3P0PooledConnectionPool.this.c3p0PooledConnections) {
                                ((AbstractC3P0PooledConnection)pooledConnection).initStatementCache(C3P0PooledConnectionPool.this.scache);
                            } else {
                                logger.warning("StatementPooling not implemented for external (non-c3p0) ConnectionPoolDataSources.");
                            }
                        }
                        object = null;
                        try {
                            C3P0PooledConnectionPool.this.scacheWaitMarkPooledConnectionInUse(pooledConnection);
                            object = pooledConnection.getConnection();
                            SQLWarnings.logAndClearWarnings((Connection)object);
                        }
                        finally {
                            ConnectionUtils.attemptClose((Connection)object);
                            C3P0PooledConnectionPool.this.scacheUnmarkPooledConnectionInUse(pooledConnection);
                        }
                        PooledConnection pooledConnection2 = pooledConnection;
                        return pooledConnection2;
                    }
                    catch (Exception exception) {
                        block20: {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "A PooledConnection was acquired, but an Exception occurred while preparing it for use. Attempting to destroy.", exception);
                            }
                            try {
                                this.destroyResource(pooledConnection, false);
                            }
                            catch (Exception exception2) {
                                if (!logger.isLoggable(MLevel.WARNING)) break block20;
                                logger.log(MLevel.WARNING, "An Exception occurred while trying to close partially acquired PooledConnection.", exception2);
                            }
                        }
                        throw exception;
                    }
                    finally {
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.finest(this + ".acquireResource() returning. ");
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void refurbishResourceOnCheckout(Object object) throws Exception {
                    block17: {
                        C3P0PooledConnectionPool.this.internalUseLockManager.lockInternalUse(object);
                        try {
                            if (connectionCustomizer != null) {
                                Connection connection = null;
                                try {
                                    connection = ((AbstractC3P0PooledConnection)object).getPhysicalConnection();
                                    C3P0PooledConnectionPool.this.scacheWaitMarkPhysicalConnectionInUse(connection);
                                    if (bl4) {
                                        if (logger.isLoggable(MLevel.FINER)) {
                                            this.finerLoggingTestPooledConnection(object, "CHECKOUT");
                                        } else {
                                            this.testPooledConnection(object);
                                        }
                                    }
                                    connectionCustomizer.onCheckOut(connection, string3);
                                    break block17;
                                }
                                catch (ClassCastException classCastException) {
                                    throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + object + "; ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName(), classCastException);
                                }
                                finally {
                                    C3P0PooledConnectionPool.this.scacheUnmarkPhysicalConnectionInUse(connection);
                                }
                            }
                            if (!bl4) break block17;
                            PooledConnection pooledConnection = (PooledConnection)object;
                            try {
                                C3P0PooledConnectionPool.this.scacheWaitMarkPooledConnectionInUse(pooledConnection);
                                if (logger.isLoggable(MLevel.FINER)) {
                                    this.finerLoggingTestPooledConnection(pooledConnection, "CHECKOUT");
                                } else {
                                    this.testPooledConnection(pooledConnection);
                                }
                            }
                            finally {
                                C3P0PooledConnectionPool.this.scacheUnmarkPooledConnectionInUse(pooledConnection);
                            }
                        }
                        finally {
                            C3P0PooledConnectionPool.this.internalUseLockManager.unlockInternalUse(object);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void refurbishResourceOnCheckin(Object object) throws Exception {
                    Connection connection = null;
                    boolean bl = C3P0PooledConnectionPool.this.resurrectables != null && C3P0PooledConnectionPool.this.resurrectables.checkResurrectable(object);
                    try {
                        block21: {
                            C3P0PooledConnectionPool.this.internalUseLockManager.lockInternalUse(object);
                            try {
                                if (connectionCustomizer != null) {
                                    Connection connection2 = null;
                                    try {
                                        connection2 = ((AbstractC3P0PooledConnection)object).getPhysicalConnection();
                                        C3P0PooledConnectionPool.this.scacheWaitMarkPhysicalConnectionInUse(connection2);
                                        connectionCustomizer.onCheckIn(connection2, string3);
                                        SQLWarnings.logAndClearWarnings(connection2);
                                        if (bl5 || bl) {
                                            if (logger.isLoggable(MLevel.FINER)) {
                                                this.finerLoggingTestPooledConnection(object, "CHECKIN");
                                            } else {
                                                this.testPooledConnection(object);
                                            }
                                        }
                                        break block21;
                                    }
                                    catch (ClassCastException classCastException) {
                                        throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + object + "; ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName(), classCastException);
                                    }
                                    finally {
                                        C3P0PooledConnectionPool.this.scacheUnmarkPhysicalConnectionInUse(connection2);
                                    }
                                }
                                PooledConnection pooledConnection = (PooledConnection)object;
                                Connection connection3 = null;
                                try {
                                    C3P0PooledConnectionPool.this.scacheWaitMarkPooledConnectionInUse(pooledConnection);
                                    connection3 = pooledConnection.getConnection();
                                    SQLWarnings.logAndClearWarnings(connection3);
                                    if (bl5 || bl) {
                                        if (logger.isLoggable(MLevel.FINER)) {
                                            this.finerLoggingTestPooledConnection(object, connection3, "CHECKIN");
                                        } else {
                                            this.testPooledConnection(object, connection3);
                                        }
                                    }
                                }
                                finally {
                                    connection = connection3;
                                    C3P0PooledConnectionPool.this.scacheUnmarkPooledConnectionInUse(pooledConnection);
                                }
                            }
                            finally {
                                C3P0PooledConnectionPool.this.internalUseLockManager.unlockInternalUse(object);
                            }
                        }
                        if (logger.isLoggable(MLevel.FINE) && bl) {
                            logger.log(MLevel.FINE, "A resource that had previously experienced a Connection error has been successfully resurrected on checkin: " + object);
                        }
                    }
                    catch (Throwable throwable) {
                        ConnectionUtils.attemptClose(connection);
                        throw throwable;
                    }
                    ConnectionUtils.attemptClose(connection);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void refurbishIdleResource(Object object) throws Exception {
                    C3P0PooledConnectionPool.this.internalUseLockManager.lockInternalUse(object);
                    try {
                        PooledConnection pooledConnection = (PooledConnection)object;
                        try {
                            C3P0PooledConnectionPool.this.scacheWaitMarkPooledConnectionInUse(pooledConnection);
                            if (logger.isLoggable(MLevel.FINER)) {
                                this.finerLoggingTestPooledConnection(object, "IDLE CHECK");
                            } else {
                                this.testPooledConnection(object);
                            }
                        }
                        finally {
                            C3P0PooledConnectionPool.this.scacheUnmarkPooledConnectionInUse(pooledConnection);
                        }
                    }
                    finally {
                        C3P0PooledConnectionPool.this.internalUseLockManager.unlockInternalUse(object);
                    }
                }

                private void finerLoggingTestPooledConnection(Object object, String string) throws Exception {
                    this.finerLoggingTestPooledConnection(object, null, string);
                }

                private void finerLoggingTestPooledConnection(Object object, Connection connection, String string) throws Exception {
                    logger.finer("Testing PooledConnection [" + object + "] on " + string + ".");
                    try {
                        this.testPooledConnection(object, connection);
                        logger.finer("Test of PooledConnection [" + object + "] on " + string + " has SUCCEEDED.");
                    }
                    catch (Exception exception) {
                        logger.log(MLevel.FINER, "Test of PooledConnection [" + object + "] on " + string + " has FAILED.", exception);
                        exception.fillInStackTrace();
                        throw exception;
                    }
                }

                private void testPooledConnection(Object object) throws Exception {
                    this.testPooledConnection(object, null);
                }

                private void testPooledConnection(Object object, Connection connection) throws Exception {
                    PooledConnection pooledConnection = (PooledConnection)object;
                    assert (!Boolean.FALSE.equals(C3P0PooledConnectionPool.this.scachePooledConnectionInUse(pooledConnection)));
                    this.connectionTestPath.testPooledConnection(pooledConnection, connection);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void destroyResource(Object object, boolean bl) throws Exception {
                    try {
                        C3P0PooledConnectionPool.this.internalUseLockManager.lockInternalUse(object);
                        try {
                            block17: {
                                C3P0PooledConnectionPool.this.scacheWaitMarkPooledConnectionInUse((PooledConnection)object);
                                if (connectionCustomizer != null) {
                                    Connection connection = null;
                                    try {
                                        connection = ((AbstractC3P0PooledConnection)object).getPhysicalConnection();
                                        connectionCustomizer.onDestroy(connection, string3);
                                    }
                                    catch (ClassCastException classCastException) {
                                        throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + object + "; ConnectionPoolDataSource: " + connectionPoolDataSource.getClass().getName(), classCastException);
                                    }
                                    catch (Exception exception) {
                                        if (!logger.isLoggable(MLevel.WARNING)) break block17;
                                        logger.log(MLevel.WARNING, "An exception occurred while executing the onDestroy() method of " + connectionCustomizer + ". c3p0 will attempt to destroy the target Connection regardless, but this issue  should be investigated and fixed.", exception);
                                    }
                                }
                            }
                            if (logger.isLoggable(MLevel.FINER)) {
                                logger.log(MLevel.FINER, "Preparing to destroy PooledConnection: " + object);
                            }
                            if (C3P0PooledConnectionPool.this.c3p0PooledConnections) {
                                ((AbstractC3P0PooledConnection)object).closeMaybeCheckedOut(bl);
                            } else {
                                ((PooledConnection)object).close();
                            }
                            if (logger.isLoggable(MLevel.FINER)) {
                                logger.log(MLevel.FINER, "Successfully destroyed PooledConnection: " + object);
                            }
                        }
                        catch (Exception exception) {
                            if (logger.isLoggable(MLevel.FINER)) {
                                logger.log(MLevel.FINER, "Failed to destroy PooledConnection: " + object);
                            }
                            throw exception;
                        }
                        finally {
                            C3P0PooledConnectionPool.this.scacheUnmarkPooledConnectionInUse((PooledConnection)object);
                        }
                    }
                    finally {
                        C3P0PooledConnectionPool.this.internalUseLockManager.unlockInternalUse(object);
                    }
                }
            }
            PooledConnectionResourcePoolManager pooledConnectionResourcePoolManager = new PooledConnectionResourcePoolManager();
            ResourcePoolFactory resourcePoolFactory2 = resourcePoolFactory;
            synchronized (resourcePoolFactory2) {
                resourcePoolFactory.setMin(n);
                resourcePoolFactory.setMax(n2);
                resourcePoolFactory.setStart(n3);
                resourcePoolFactory.setIncrement(n4);
                resourcePoolFactory.setIdleResourceTestPeriod(n9 * 1000);
                resourcePoolFactory.setResourceMaxIdleTime(n10 * 1000);
                resourcePoolFactory.setExcessResourceMaxIdleTime(n11 * 1000);
                resourcePoolFactory.setResourceMaxAge(n12 * 1000);
                resourcePoolFactory.setExpirationEnforcementDelay(n13 * 1000);
                resourcePoolFactory.setDestroyOverdueResourceTime(n14 * 1000);
                resourcePoolFactory.setDebugStoreCheckoutStackTrace(bl2);
                resourcePoolFactory.setForceSynchronousCheckins(bl3);
                resourcePoolFactory.setAcquisitionRetryAttempts(n5);
                resourcePoolFactory.setAcquisitionRetryDelay(n6);
                resourcePoolFactory.setBreakOnAcquisitionFailure(bl);
                this.rp = resourcePoolFactory.createPool(pooledConnectionResourcePoolManager);
            }
            pooledConnectionResourcePoolManager.initAfterResourcePoolConstructed();
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public PooledConnection checkoutPooledConnection() throws SQLException {
        try {
            PooledConnection pooledConnection = (PooledConnection)this.checkoutAndScacheMarkConnectionInUse();
            pooledConnection.addConnectionEventListener(this.cl);
            this.markBeginRequest(pooledConnection);
            return pooledConnection;
        }
        catch (TimeoutException timeoutException) {
            throw SqlUtils.toSQLException("An attempt by a client to checkout a Connection has timed out.", timeoutException);
        }
        catch (CannotAcquireResourceException cannotAcquireResourceException) {
            throw SqlUtils.toSQLException("Connections could not be acquired from the underlying database!", "08001", cannotAcquireResourceException);
        }
        catch (Exception exception) {
            throw SqlUtils.toSQLException(exception);
        }
    }

    private void scacheWaitMarkPhysicalConnectionInUse(Connection connection) throws InterruptedException {
        if (this.scache != null) {
            this.scache.waitMarkConnectionInUse(connection);
        }
    }

    private boolean scacheTryMarkPhysicalConnectionInUse(Connection connection) {
        return this.scache != null ? this.scache.tryMarkConnectionInUse(connection) : true;
    }

    private void scacheUnmarkPhysicalConnectionInUse(Connection connection) {
        if (this.scache != null) {
            this.scache.unmarkConnectionInUse(connection);
        }
    }

    private void scacheWaitMarkPooledConnectionInUse(PooledConnection pooledConnection) throws InterruptedException {
        if (this.c3p0PooledConnections) {
            this.scacheWaitMarkPhysicalConnectionInUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
    }

    private boolean scacheTryMarkPooledConnectionInUse(PooledConnection pooledConnection) {
        if (this.c3p0PooledConnections) {
            return this.scacheTryMarkPhysicalConnectionInUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
        return true;
    }

    private void scacheUnmarkPooledConnectionInUse(PooledConnection pooledConnection) {
        if (this.c3p0PooledConnections) {
            this.scacheUnmarkPhysicalConnectionInUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
    }

    private Boolean scachePhysicalConnectionInUse(Connection connection) throws InterruptedException {
        if (connection != null && this.scache != null) {
            return this.scache.inUse(connection);
        }
        return null;
    }

    private Boolean scachePooledConnectionInUse(PooledConnection pooledConnection) throws InterruptedException {
        if (pooledConnection != null && this.scache != null) {
            return this.scache.inUse(((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkoutAndScacheMarkConnectionInUse() throws TimeoutException, CannotAcquireResourceException, ResourcePoolException, InterruptedException {
        Object object = null;
        boolean bl = false;
        while (!bl) {
            try {
                object = this.rp.checkoutResource(this.checkoutTimeout);
                if (object instanceof AbstractC3P0PooledConnection) {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)object;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    bl = this.scacheTryMarkPhysicalConnectionInUse(connection);
                    continue;
                }
                bl = true;
            }
            finally {
                try {
                    if (bl || object == null) continue;
                    this.rp.checkinResource(object);
                }
                catch (Exception exception) {
                    logger.log(MLevel.WARNING, "Failed to check in a Connection that was unusable due to pending Statement closes.", exception);
                }
            }
        }
        return object;
    }

    private void scacheUnmarkConnectionInUseAndCheckin(PooledConnection pooledConnection) throws ResourcePoolException {
        block3: {
            if (this.scache != null) {
                try {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    this.scacheUnmarkPhysicalConnectionInUse(connection);
                }
                catch (ClassCastException classCastException) {
                    if (!logger.isLoggable(MLevel.SEVERE)) break block3;
                    logger.log(MLevel.SEVERE, "You are checking a non-c3p0 PooledConnection implementation intoa c3p0 PooledConnectionPool instance that expects only c3p0-generated PooledConnections.This isn't good, and may indicate a c3p0 bug, or an unusual (and unspported) use of the c3p0 library.", classCastException);
                }
            }
        }
        this.rp.checkinResource(pooledConnection);
    }

    private void checkinPooledConnection(PooledConnection pooledConnection) throws SQLException {
        try {
            pooledConnection.removeConnectionEventListener(this.cl);
            this.scacheUnmarkConnectionInUseAndCheckin(pooledConnection);
            this.markEndRequest(pooledConnection);
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public float getEffectivePropertyCycle() throws SQLException {
        try {
            return (float)this.rp.getEffectiveExpirationEnforcementDelay() / 1000.0f;
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public int getNumThreadsAwaitingCheckout() throws SQLException {
        try {
            return this.rp.getNumCheckoutWaiters();
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public int getStatementCacheNumStatements() {
        return this.scache == null ? 0 : this.scache.getNumStatements();
    }

    public int getStatementCacheNumCheckedOut() {
        return this.scache == null ? 0 : this.scache.getNumStatementsCheckedOut();
    }

    public int getStatementCacheNumConnectionsWithCachedStatements() {
        return this.scache == null ? 0 : this.scache.getNumConnectionsWithCachedStatements();
    }

    public String dumpStatementCacheStatus() {
        return this.scache == null ? "Statement caching disabled." : this.scache.dumpStatementCacheStatus();
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public void close(boolean bl) throws SQLException {
        Exception exception = null;
        try {
            if (this.scache != null) {
                this.scache.close();
            }
        }
        catch (SQLException sQLException) {
            exception = sQLException;
        }
        try {
            this.rp.close(bl);
        }
        catch (ResourcePoolException resourcePoolException) {
            if (exception != null && logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while closing the StatementCache.", exception);
            }
            exception = resourcePoolException;
        }
        if (exception != null) {
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumConnections() throws SQLException {
        try {
            return this.rp.getPoolSize();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumIdleConnections() throws SQLException {
        try {
            return this.rp.getAvailableCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumBusyConnections() throws SQLException {
        try {
            return this.rp.getAwaitingCheckinNotExcludedCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        try {
            return this.rp.getExcludedCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getStartTime() throws SQLException {
        try {
            return this.rp.getStartTime();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getUpTime() throws SQLException {
        try {
            return this.rp.getUpTime();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getNumFailedCheckins() throws SQLException {
        try {
            return this.rp.getNumFailedCheckins();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getNumFailedCheckouts() throws SQLException {
        try {
            return this.rp.getNumFailedCheckouts();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getNumFailedIdleTests() throws SQLException {
        try {
            return this.rp.getNumFailedIdleTests();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastCheckinFailure() throws SQLException {
        try {
            return this.rp.getLastCheckinFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastCheckoutFailure() throws SQLException {
        try {
            return this.rp.getLastCheckoutFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastIdleTestFailure() throws SQLException {
        try {
            return this.rp.getLastIdleCheckFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastConnectionTestFailure() throws SQLException {
        try {
            return this.rp.getLastResourceTestFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastAcquisitionFailure() throws SQLException {
        try {
            return this.rp.getLastAcquisitionFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public void reset() throws SQLException {
        try {
            this.rp.resetPool();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    class ConnectionEventListenerImpl
    implements ConnectionEventListener {
        ConnectionEventListenerImpl() {
        }

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            this.doCheckinResource(connectionEvent);
        }

        private void doCheckinResource(ConnectionEvent connectionEvent) {
            try {
                C3P0PooledConnectionPool.this.checkinPooledConnection((PooledConnection)connectionEvent.getSource());
            }
            catch (Exception exception) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to check a PooledConection into a ResourcePool.", exception);
            }
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("CONNECTION ERROR OCCURRED!");
            }
            int n = (pooledConnection = (PooledConnection)connectionEvent.getSource()) instanceof NewPooledConnection ? ((NewPooledConnection)pooledConnection).getConnectionStatus() : -1;
            int n2 = n;
            this.doMarkPoolStatus(pooledConnection, n2);
        }

        private void doMarkPoolStatus(PooledConnection pooledConnection, int n) {
            try {
                switch (n) {
                    case 0: {
                        throw new RuntimeException("connectionErrorOcccurred() should only be called for errors fatal to the Connection.");
                    }
                    case -1: {
                        if (C3P0PooledConnectionPool.this.resurrectables == null) {
                            C3P0PooledConnectionPool.this.rp.markBroken(pooledConnection);
                            break;
                        }
                        C3P0PooledConnectionPool.this.resurrectables.markResurrectable(pooledConnection);
                        break;
                    }
                    case -8: {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.warning("A ConnectionTest has failed, reporting that all previously acquired Connections are likely invalid. The pool will be reset.");
                        }
                        C3P0PooledConnectionPool.this.rp.resetPool();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Bad Connection Tester (" + C3P0PooledConnectionPool.this.connectionTester + ") returned invalid status (" + n + ").");
                    }
                }
            }
            catch (ResourcePoolException resourcePoolException) {
                logger.log(MLevel.WARNING, "Uh oh... our resource pool is probably broken!", resourcePoolException);
            }
        }
    }

    private static class ReflectiveRequestBoundaryMarker
    implements RequestBoundaryMarker {
        Method beginRequest;
        Method endRequest;

        ReflectiveRequestBoundaryMarker(Method method, Method method2) {
            this.beginRequest = method;
            this.endRequest = method2;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (!method2.isAccessible()) {
                method2.setAccessible(true);
            }
        }

        @Override
        public void attemptNotifyBeginRequest(PooledConnection pooledConnection) {
            block4: {
                if (pooledConnection instanceof AbstractC3P0PooledConnection) {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    try {
                        this.beginRequest.invoke((Object)connection, new Object[0]);
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.log(MLevel.FINEST, "beginRequest method called");
                        }
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(MLevel.WARNING)) break block4;
                        logger.log(MLevel.WARNING, "Error invoking beginRequest method for connection", exception);
                    }
                }
            }
        }

        @Override
        public void attemptNotifyEndRequest(PooledConnection pooledConnection) {
            block4: {
                if (pooledConnection instanceof AbstractC3P0PooledConnection) {
                    AbstractC3P0PooledConnection abstractC3P0PooledConnection = (AbstractC3P0PooledConnection)pooledConnection;
                    Connection connection = abstractC3P0PooledConnection.getPhysicalConnection();
                    try {
                        this.endRequest.invoke((Object)connection, new Object[0]);
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.log(MLevel.FINEST, "endRequest method called");
                        }
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(MLevel.WARNING)) break block4;
                        logger.log(MLevel.WARNING, "Error invoking endRequest method for connection", exception);
                    }
                }
            }
        }
    }

    private static interface RequestBoundaryMarker {
        public void attemptNotifyBeginRequest(PooledConnection var1);

        public void attemptNotifyEndRequest(PooledConnection var1);
    }

    private static class C3P0PooledConnectionNestedLockInternalUseLockManager
    extends AbstractInternalUseLockManager {
        private C3P0PooledConnectionNestedLockInternalUseLockManager() {
        }

        @Override
        ReentrantLock getInternalUseLock(Object object) {
            return ((AbstractC3P0PooledConnection)object).inInternalUseLock;
        }
    }

    private static class WeakHashMapInternalUseLockManager
    extends AbstractInternalUseLockManager {
        WeakHashMap inUseLocks = new WeakHashMap();

        private WeakHashMapInternalUseLockManager() {
        }

        @Override
        synchronized ReentrantLock getInternalUseLock(Object object) {
            ReentrantLock reentrantLock = (ReentrantLock)this.inUseLocks.get(object);
            if (reentrantLock == null) {
                reentrantLock = new ReentrantLock();
                this.inUseLocks.put(object, reentrantLock);
            }
            return reentrantLock;
        }

        @Override
        public synchronized void lockInternalUse(Object object) {
            super.lockInternalUse(object);
        }

        @Override
        public synchronized void unlockInternalUse(Object object) {
            super.unlockInternalUse(object);
        }
    }

    private static abstract class AbstractInternalUseLockManager {
        private AbstractInternalUseLockManager() {
        }

        abstract ReentrantLock getInternalUseLock(Object var1);

        public void lockInternalUse(Object object) {
            this.getInternalUseLock(object).lock();
        }

        public void unlockInternalUse(Object object) {
            this.getInternalUseLock(object).unlock();
        }
    }

    private static class Resurrectables {
        WeakHashMap candidates = new WeakHashMap();

        private Resurrectables() {
        }

        public synchronized void markResurrectable(Object object) {
            this.candidates.put(object, this);
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "Marked broken resource resurrectable: " + object);
            }
        }

        public synchronized boolean checkResurrectable(Object object) {
            boolean bl;
            boolean bl2 = bl = this.candidates.remove(object) != null;
            if (logger.isLoggable(MLevel.FINER) && bl) {
                logger.log(MLevel.FINER, "Found and cleared resurrectable resource: " + object);
            }
            return bl;
        }
    }
}

