/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PackedColorModel;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.sis.internal.coverage.j2d.MultiBandsIndexColorModel;
import org.apache.sis.internal.coverage.j2d.ScaledColorSpace;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.Static;

public final class ImageUtilities
extends Static {
    public static final int DEFAULT_TILE_SIZE = 256;
    public static final int SUGGESTED_TILE_CACHE_SIZE = 160;
    private static final int BUFFER_SIZE = 65536;
    private static final String[] TYPE_NAMES = new String[6];
    private static final byte[] NUMBER_ENUMS;

    private ImageUtilities() {
    }

    public static Rectangle getBounds(RenderedImage renderedImage) {
        return new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
    }

    public static void clipBounds(RenderedImage renderedImage, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = renderedImage.getMinX();
        if (n < n2) {
            rectangle.x = n2;
        }
        rectangle.width = Numerics.clamp(Math.min((long)n2 + (long)renderedImage.getWidth(), (long)n + (long)rectangle.width) - (long)rectangle.x);
        n = rectangle.y;
        n2 = renderedImage.getMinY();
        if (n < n2) {
            rectangle.y = n2;
        }
        rectangle.height = Numerics.clamp(Math.min((long)n2 + (long)renderedImage.getHeight(), (long)n + (long)rectangle.height) - (long)rectangle.y);
    }

    public static int getNumBands(RenderedImage renderedImage) {
        SampleModel sampleModel;
        if (renderedImage != null && (sampleModel = renderedImage.getSampleModel()) != null) {
            return sampleModel.getNumBands();
        }
        return 0;
    }

    public static int getVisibleBand(RenderedImage renderedImage) {
        if (renderedImage != null) {
            Object object;
            ColorModel colorModel = renderedImage.getColorModel();
            if (colorModel != null) {
                if (colorModel instanceof MultiBandsIndexColorModel) {
                    return ((MultiBandsIndexColorModel)colorModel).visibleBand;
                }
                object = colorModel.getColorSpace();
                if (object instanceof ScaledColorSpace) {
                    return ((ScaledColorSpace)object).visibleBand;
                }
            }
            if ((object = renderedImage.getSampleModel()) != null && ((SampleModel)object).getNumBands() == 1) {
                return 0;
            }
        }
        return -1;
    }

    public static int getBandType(SampleModel sampleModel) {
        if (sampleModel == null) {
            return 32;
        }
        int n = sampleModel.getDataType();
        if (!ImageUtilities.isIntegerType(n)) {
            return n;
        }
        int n2 = Math.min(DataBuffer.getDataTypeSize(n), 17);
        int n3 = 0;
        int n4 = sampleModel.getNumBands();
        while (--n4 >= 0) {
            int n5 = sampleModel.getSampleSize(n4);
            if (n5 <= n3) continue;
            if (n5 >= n2) {
                return n;
            }
            n3 = n5;
        }
        int n6 = n4 = n <= 1 || sampleModel instanceof SinglePixelPackedSampleModel || sampleModel instanceof MultiPixelPackedSampleModel ? 1 : 0;
        return n4 != 0 ? (n3 <= 8 ? 0 : 1) : 2;
    }

    public static String getDataTypeName(SampleModel sampleModel) {
        int n;
        if (sampleModel != null && (n = sampleModel.getDataType()) >= 0 && n < TYPE_NAMES.length) {
            return TYPE_NAMES[n];
        }
        return null;
    }

    public static short getTransparencyDescription(ColorModel colorModel) {
        if (colorModel != null) {
            if (colorModel.hasAlpha()) {
                return 33;
            }
            switch (colorModel.getTransparency()) {
                case 2: 
                case 3: {
                    return 32;
                }
                case 1: {
                    return 34;
                }
            }
        }
        return 0;
    }

    public static short[] bandNames(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace colorSpace;
        int n = sampleModel.getNumBands();
        short[] sArray = new short[n];
        if (colorModel instanceof IndexColorModel) {
            int n2 = 0;
            if (colorModel instanceof MultiBandsIndexColorModel) {
                n2 = ((MultiBandsIndexColorModel)colorModel).visibleBand;
            }
            if (n2 < n) {
                sArray[n2] = 30;
            }
        } else if (colorModel != null && (colorSpace = colorModel.getColorSpace()) != null) {
            switch (colorSpace.getType()) {
                case 9: {
                    if (n >= 4) {
                        sArray[3] = 17;
                    }
                }
                case 11: {
                    switch (n) {
                        default: {
                            sArray[2] = 227;
                        }
                        case 2: {
                            sArray[1] = 124;
                        }
                        case 1: {
                            sArray[0] = 45;
                        }
                        case 0: 
                    }
                    break;
                }
                case 5: {
                    switch (n) {
                        default: {
                            sArray[2] = 18;
                        }
                        case 2: {
                            sArray[1] = 96;
                        }
                        case 1: {
                            sArray[0] = 167;
                        }
                        case 0: 
                    }
                    break;
                }
                case 6: {
                    if (n == 0) break;
                    sArray[0] = 95;
                }
            }
            int n3 = colorModel.getNumColorComponents();
            if (n3 < n && n3 < colorModel.getNumComponents()) {
                sArray[n3] = 201;
            }
            int[] nArray = null;
            int[] nArray2 = null;
            if (colorModel instanceof PackedColorModel) {
                nArray = ((PackedColorModel)colorModel).getMasks();
            }
            if (sampleModel instanceof SinglePixelPackedSampleModel) {
                nArray2 = ((SinglePixelPackedSampleModel)sampleModel).getBitMasks();
            }
            if (!Arrays.equals(nArray, nArray2)) {
                Logger.getLogger("org.apache.sis.raster").warning("Band names may be in wrong order.");
            }
        }
        return sArray;
    }

    public static byte toNumberEnum(int n) {
        return n >= 0 && n < NUMBER_ENUMS.length ? NUMBER_ENUMS[n] : (byte)0;
    }

    public static boolean isIntegerType(int n) {
        return n >= 0 && n <= 3;
    }

    public static boolean isIntegerType(SampleModel sampleModel) {
        return sampleModel != null && ImageUtilities.isIntegerType(sampleModel.getDataType());
    }

    public static boolean isUnsignedType(SampleModel sampleModel) {
        int n;
        if (sampleModel != null && (n = sampleModel.getDataType()) >= 0) {
            if (n <= 1) {
                return true;
            }
            if (n <= 3) {
                return sampleModel instanceof SinglePixelPackedSampleModel || sampleModel instanceof MultiPixelPackedSampleModel;
            }
        }
        return false;
    }

    public static boolean isLosslessConversion(SampleModel sampleModel, SampleModel sampleModel2) {
        if (sampleModel != sampleModel2) {
            int n = sampleModel.getNumBands();
            if (sampleModel2.getNumBands() < n) {
                return false;
            }
            boolean bl = ImageUtilities.isIntegerType(sampleModel.getDataType());
            boolean bl2 = ImageUtilities.isIntegerType(sampleModel2.getDataType());
            if (bl2 && !bl) {
                return false;
            }
            boolean bl3 = false;
            for (int i = 0; i < n; ++i) {
                int n2 = sampleModel2.getSampleSize(i) - sampleModel.getSampleSize(i);
                bl3 |= n2 == 0;
                if (n2 >= 0) continue;
                return false;
            }
            if (bl3 && (bl != bl2 || ImageUtilities.isUnsignedType(sampleModel) != ImageUtilities.isUnsignedType(sampleModel2))) {
                return false;
            }
        }
        return true;
    }

    public static int pixelToTileX(RenderedImage renderedImage, int n) {
        return Math.toIntExact(Math.floorDiv((long)n - (long)renderedImage.getTileGridXOffset(), (long)renderedImage.getTileWidth()));
    }

    public static int pixelToTileY(RenderedImage renderedImage, int n) {
        return Math.toIntExact(Math.floorDiv((long)n - (long)renderedImage.getTileGridYOffset(), (long)renderedImage.getTileHeight()));
    }

    public static int tileToPixelX(RenderedImage renderedImage, int n) {
        return Math.toIntExact(JDK9.multiplyFull(n, renderedImage.getTileWidth()) + (long)renderedImage.getTileGridXOffset());
    }

    public static int tileToPixelY(RenderedImage renderedImage, int n) {
        return Math.toIntExact(JDK9.multiplyFull(n, renderedImage.getTileHeight()) + (long)renderedImage.getTileGridYOffset());
    }

    public static Rectangle pixelsToTiles(RenderedImage renderedImage, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        if (!rectangle.isEmpty()) {
            int n = renderedImage.getTileWidth();
            long l = renderedImage.getTileGridXOffset();
            long l2 = (long)rectangle.x - l;
            rectangle2.x = Math.toIntExact(Math.floorDiv(l2, (long)n));
            rectangle2.width = Math.toIntExact(Math.floorDiv(l2 + (long)(rectangle.width - 1), (long)n) - (long)rectangle2.x + 1L);
            n = renderedImage.getTileHeight();
            l = renderedImage.getTileGridYOffset();
            l2 = (long)rectangle.y - l;
            rectangle2.y = Math.toIntExact(Math.floorDiv(l2, (long)n));
            rectangle2.height = Math.toIntExact(Math.floorDiv(l2 + (long)(rectangle.height - 1), (long)n) - (long)rectangle2.y + 1L);
        }
        return rectangle2;
    }

    public static Rectangle tilesToPixels(RenderedImage renderedImage, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        if (!rectangle.isEmpty()) {
            int n = renderedImage.getTileWidth();
            int n2 = renderedImage.getTileGridXOffset();
            rectangle2.x = Math.toIntExact(JDK9.multiplyFull(rectangle.x, n) + (long)n2);
            rectangle2.width = Math.toIntExact(((long)rectangle.x + (long)rectangle.width) * (long)n + (long)n2 - (long)rectangle2.x);
            n = renderedImage.getTileHeight();
            n2 = renderedImage.getTileGridYOffset();
            rectangle2.y = Math.toIntExact(JDK9.multiplyFull(rectangle.y, n) + (long)n2);
            rectangle2.height = Math.toIntExact(((long)rectangle.y + (long)rectangle.height) * (long)n + (long)n2 - (long)rectangle2.y);
        }
        return rectangle2;
    }

    public static int prepareTransferRegion(Rectangle rectangle, int n) {
        int n2;
        if (rectangle.isEmpty()) {
            throw new RasterFormatException(Resources.format((short)20));
        }
        int n3 = Math.addExact(rectangle.y, rectangle.height);
        try {
            n2 = DataBuffer.getDataTypeSize(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n2 = 16;
        }
        rectangle.height = Math.max(1, Math.min(65536 / (n2 * rectangle.width), rectangle.height));
        return n3;
    }

    public static boolean roundIfAlmostInteger(AffineTransform affineTransform) {
        double d;
        double d2 = affineTransform.getScaleX();
        double d3 = Math.rint(d2);
        if (Math.abs(d - d2) <= 1.0E-13) {
            double d4;
            d2 = affineTransform.getShearX();
            double d5 = Math.rint(d2);
            if (Math.abs(d4 - d2) <= 1.0E-13) {
                double d6;
                d2 = affineTransform.getScaleY();
                double d7 = Math.rint(d2);
                if (Math.abs(d6 - d2) <= 1.0E-13) {
                    double d8;
                    d2 = affineTransform.getShearY();
                    double d9 = Math.rint(d2);
                    if (!(!(Math.abs(d8 - d2) <= 1.0E-13) || d3 == 0.0 && d5 == 0.0 || d9 == 0.0 && d7 == 0.0)) {
                        double d10 = Math.rint(affineTransform.getTranslateX());
                        double d11 = Math.rint(affineTransform.getTranslateY());
                        affineTransform.setTransform(d3, d9, d5, d7, d10, d11);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static {
        ImageUtilities.TYPE_NAMES[0] = "byte";
        ImageUtilities.TYPE_NAMES[2] = "short";
        ImageUtilities.TYPE_NAMES[1] = "ushort";
        ImageUtilities.TYPE_NAMES[3] = "int";
        ImageUtilities.TYPE_NAMES[4] = "float";
        ImageUtilities.TYPE_NAMES[5] = "double";
        NUMBER_ENUMS = new byte[]{3, 4, 4, 5, 8, 9};
    }
}

