/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.io.Serializable;
import java.time.temporal.Temporal;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.metadata.iso.quality.AbstractDataEvaluation;
import org.apache.sis.metadata.iso.quality.DefaultAggregationDerivation;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.util.InternationalString;

@XmlType(name="DQ_EvaluationMethod_Type", propOrder={"evaluationMethodType", "evaluationMethodDescription", "evaluationProcedure", "referenceDocuments", "dates"})
@XmlRootElement(name="DQ_EvaluationMethod")
@XmlSeeAlso(value={AbstractDataEvaluation.class, DefaultAggregationDerivation.class})
@UML(identifier="DQ_EvaluationMethod", specification=Specification.UNSPECIFIED)
public class DefaultEvaluationMethod
extends ISOMetadata {
    private static final long serialVersionUID = 5196994626251088685L;
    private EvaluationMethodType evaluationMethodType;
    private InternationalString evaluationMethodDescription;
    private Citation evaluationProcedure;
    private Collection<Citation> referenceDocuments;
    private Dates dates;

    public DefaultEvaluationMethod() {
    }

    public DefaultEvaluationMethod(DefaultEvaluationMethod defaultEvaluationMethod) {
        super(defaultEvaluationMethod);
        if (defaultEvaluationMethod != null) {
            this.evaluationMethodType = defaultEvaluationMethod.getEvaluationMethodType();
            this.evaluationMethodDescription = defaultEvaluationMethod.getEvaluationMethodDescription();
            this.evaluationProcedure = defaultEvaluationMethod.getEvaluationProcedure();
            this.referenceDocuments = this.copyCollection(defaultEvaluationMethod.getReferenceDocuments(), Citation.class);
            this.writeDates(defaultEvaluationMethod.getDates());
        }
    }

    @XmlElement(name="evaluationMethodType")
    @UML(identifier="evaluationMethodType", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public EvaluationMethodType getEvaluationMethodType() {
        return this.evaluationMethodType;
    }

    public void setEvaluationMethodType(EvaluationMethodType evaluationMethodType) {
        this.checkWritePermission(this.evaluationMethodType);
        this.evaluationMethodType = evaluationMethodType;
    }

    @XmlElement(name="evaluationMethodDescription")
    @UML(identifier="evaluationMethodDescription", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public InternationalString getEvaluationMethodDescription() {
        return this.evaluationMethodDescription;
    }

    public void setEvaluationMethodDescription(InternationalString internationalString) {
        this.checkWritePermission(this.evaluationMethodDescription);
        this.evaluationMethodDescription = internationalString;
    }

    @XmlElement(name="evaluationProcedure")
    @UML(identifier="evaluationProcedure", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Citation getEvaluationProcedure() {
        return this.evaluationProcedure;
    }

    public void setEvaluationProcedure(Citation citation) {
        this.checkWritePermission(this.evaluationProcedure);
        this.evaluationProcedure = citation;
    }

    @XmlElement(name="referenceDoc")
    @UML(identifier="referenceDoc", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Collection<Citation> getReferenceDocuments() {
        this.referenceDocuments = this.nonNullCollection(this.referenceDocuments, Citation.class);
        return this.referenceDocuments;
    }

    public void setReferenceDocuments(Collection<? extends Citation> collection) {
        this.referenceDocuments = this.writeCollection(collection, this.referenceDocuments, Citation.class);
    }

    @XmlElement(name="dateTime")
    @UML(identifier="dateTime", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Collection<Temporal> getDates() {
        if (Semaphores.query(1)) {
            return Containers.isNullOrEmpty(this.dates) ? null : this.dates;
        }
        if (this.dates == null) {
            this.dates = new Dates();
        }
        return this.dates;
    }

    public void setDates(Collection<? extends Temporal> collection) {
        if (collection != this.dates) {
            this.checkWritePermission(ImplementationHelper.valueIfDefined(this.dates));
            this.writeDates(collection);
        }
    }

    private void writeDates(Collection<? extends Temporal> collection) {
        if (Containers.isNullOrEmpty(collection)) {
            this.dates = null;
        } else {
            if (this.dates == null) {
                this.dates = new Dates();
            }
            this.dates.clear();
            this.dates.addAll(collection);
        }
    }

    private static final class Dates
    extends AbstractList<Temporal>
    implements CheckedContainer<Temporal>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1210175223467194009L;
        private Temporal date1;
        private Temporal date2;

        Dates() {
            this.clear();
        }

        @Override
        public Class<Temporal> getElementType() {
            return Temporal.class;
        }

        @Override
        public void clear() {
            this.date1 = null;
            this.date2 = null;
        }

        @Override
        public int size() {
            if (this.date2 != null) {
                return 2;
            }
            if (this.date1 != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public Temporal get(int n) {
            Temporal temporal;
            switch (n) {
                case 0: {
                    temporal = this.date1;
                    break;
                }
                case 1: {
                    temporal = this.date2;
                    break;
                }
                default: {
                    temporal = null;
                }
            }
            if (temporal == null) {
                throw new IndexOutOfBoundsException(Errors.format((short)71, n));
            }
            return temporal;
        }

        @Override
        public Temporal set(int n, Temporal temporal) {
            ArgumentChecks.ensureNonNull("date", temporal);
            Temporal temporal2 = this.get(n);
            switch (n) {
                case 0: {
                    this.date1 = temporal;
                    break;
                }
                case 1: {
                    this.date2 = temporal;
                }
            }
            ++this.modCount;
            return temporal2;
        }

        @Override
        public Temporal remove(int n) {
            Temporal temporal = this.get(n);
            switch (n) {
                case 0: {
                    this.date1 = this.date2;
                }
                case 1: {
                    this.date2 = null;
                }
            }
            ++this.modCount;
            return temporal;
        }

        @Override
        public void add(int n, Temporal temporal) {
            if (this.date2 == null) {
                switch (n) {
                    case 0: {
                        this.date2 = this.date1;
                        this.date1 = temporal;
                        ++this.modCount;
                        return;
                    }
                    case 1: {
                        if (this.date1 == null) break;
                        this.date2 = temporal;
                        ++this.modCount;
                        return;
                    }
                }
            }
            throw new IndexOutOfBoundsException(Errors.format((short)71, n));
        }

        @Override
        public boolean addAll(Collection<? extends Temporal> collection) {
            int n = this.modCount++;
            if (collection != null) {
                Iterator<? extends Temporal> iterator = collection.iterator();
                switch (this.size()) {
                    case 0: {
                        if (!iterator.hasNext()) break;
                        this.date1 = iterator.next();
                    }
                    case 1: {
                        if (!iterator.hasNext()) break;
                        this.date2 = iterator.next();
                        ++this.modCount;
                    }
                    default: {
                        if (!iterator.hasNext()) break;
                        throw new IllegalArgumentException(Errors.format((short)35, "dates", 2, collection.size()));
                    }
                }
            }
            return this.modCount != n;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
        }
    }
}

