/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gmi.MI_Georeferenceable;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.spatial.GeolocationInformation;
import org.opengis.metadata.spatial.Georeferenceable;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

@XmlType(name="MD_Georeferenceable_Type", propOrder={"controlPointAvailable", "orientationParameterAvailable", "orientationParameterDescription", "georeferencedParameters", "parameterCitations", "geolocationInformation"})
@XmlRootElement(name="MD_Georeferenceable")
@XmlSeeAlso(value={MI_Georeferenceable.class})
public class DefaultGeoreferenceable
extends DefaultGridSpatialRepresentation
implements Georeferenceable {
    private static final long serialVersionUID = -334605303200205283L;
    private static final byte CONTROL_POINT_MASK = 2;
    private static final byte OPERATION_MASK = 4;
    private InternationalString orientationParameterDescription;
    private Record georeferencedParameters;
    private Collection<Citation> parameterCitations;
    private Collection<GeolocationInformation> geolocationInformation;

    public DefaultGeoreferenceable() {
    }

    public DefaultGeoreferenceable(Georeferenceable georeferenceable) {
        super(georeferenceable);
        if (georeferenceable != null) {
            if (georeferenceable.isControlPointAvailable()) {
                this.booleans = (byte)(this.booleans | 2);
            }
            if (georeferenceable.isOrientationParameterAvailable()) {
                this.booleans = (byte)(this.booleans | 4);
            }
            this.orientationParameterDescription = georeferenceable.getOrientationParameterDescription();
            this.parameterCitations = this.copyCollection(georeferenceable.getParameterCitations(), Citation.class);
            this.geolocationInformation = this.copyCollection(georeferenceable.getGeolocationInformation(), GeolocationInformation.class);
            this.georeferencedParameters = georeferenceable.getGeoreferencedParameters();
        }
    }

    public static DefaultGeoreferenceable castOrCopy(Georeferenceable georeferenceable) {
        if (georeferenceable == null || georeferenceable instanceof DefaultGeoreferenceable) {
            return (DefaultGeoreferenceable)georeferenceable;
        }
        return new DefaultGeoreferenceable(georeferenceable);
    }

    @Override
    @XmlElement(name="controlPointAvailability", required=true)
    public boolean isControlPointAvailable() {
        return (this.booleans & 2) != 0;
    }

    public void setControlPointAvailable(boolean bl) {
        this.checkWritePermission(this.isDefined((byte)2));
        this.booleans = bl ? (byte)(this.booleans | 2) : (byte)(this.booleans & 0xFFFFFFFD);
    }

    @Override
    @XmlElement(name="orientationParameterAvailability", required=true)
    public boolean isOrientationParameterAvailable() {
        return (this.booleans & 4) != 0;
    }

    public void setOrientationParameterAvailable(boolean bl) {
        this.checkWritePermission(this.isDefined((byte)4));
        this.booleans = bl ? (byte)(this.booleans | 4) : (byte)(this.booleans & 0xFFFFFFFB);
    }

    @Override
    @XmlElement(name="orientationParameterDescription")
    public InternationalString getOrientationParameterDescription() {
        return this.orientationParameterDescription;
    }

    public void setOrientationParameterDescription(InternationalString internationalString) {
        this.checkWritePermission(this.orientationParameterDescription);
        this.orientationParameterDescription = internationalString;
    }

    @Override
    @XmlElement(name="georeferencedParameters", required=true)
    public Record getGeoreferencedParameters() {
        return this.georeferencedParameters;
    }

    public void setGeoreferencedParameters(Record record) {
        this.checkWritePermission(this.georeferencedParameters);
        this.georeferencedParameters = record;
    }

    @XmlElement(name="parameterCitation")
    public Collection<Citation> getParameterCitations() {
        this.parameterCitations = this.nonNullCollection(this.parameterCitations, Citation.class);
        return this.parameterCitations;
    }

    public void setParameterCitations(Collection<? extends Citation> collection) {
        this.parameterCitations = this.writeCollection(collection, this.parameterCitations, Citation.class);
    }

    @XmlElement(name="geolocationInformation", required=true)
    public Collection<GeolocationInformation> getGeolocationInformation() {
        this.geolocationInformation = this.nonNullCollection(this.geolocationInformation, GeolocationInformation.class);
        return this.geolocationInformation;
    }

    public void setGeolocationInformation(Collection<? extends GeolocationInformation> collection) {
        this.geolocationInformation = this.writeCollection(collection, this.geolocationInformation, GeolocationInformation.class);
    }
}

