/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

@XmlTransient
final class TensorValues<E>
extends AbstractParameterDescriptor
implements ParameterDescriptorGroup,
ParameterValueGroup,
Cloneable {
    private static final long serialVersionUID = -7747712999115044943L;
    private final TensorParameters<E> descriptors;
    private final ParameterValue<Integer>[] dimensions;
    private Object[] values;

    TensorValues(Map<String, ?> map, TensorParameters<E> tensorParameters) {
        super(map, 1, 1);
        this.descriptors = tensorParameters;
        this.dimensions = new ParameterValue[tensorParameters.rank()];
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensions[i] = tensorParameters.getDimensionDescriptor(i).createValue();
        }
    }

    TensorValues(TensorValues<E> tensorValues, boolean bl) {
        super(tensorValues);
        this.descriptors = tensorValues.descriptors;
        this.dimensions = (ParameterValue[])tensorValues.dimensions.clone();
        for (int i = 0; i < this.dimensions.length; ++i) {
            ParameterValue<Integer> parameterValue = this.dimensions[i];
            this.dimensions[i] = bl ? parameterValue.clone() : parameterValue.getDescriptor().createValue();
        }
        if (bl) {
            this.values = TensorValues.clone(tensorValues.values);
        }
    }

    private static Object[] clone(Object[] objectArray) {
        if (objectArray != null) {
            objectArray = (Object[])objectArray.clone();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                object = object instanceof GeneralParameterValue ? ((GeneralParameterValue)object).clone() : TensorValues.clone(object);
                objectArray[i] = object;
            }
        }
        return objectArray;
    }

    @Override
    public ParameterValueGroup clone() {
        return new TensorValues<E>(this, true);
    }

    @Override
    public ParameterValueGroup createValue() {
        return new TensorValues<E>(this, false);
    }

    @Override
    public ParameterDescriptorGroup getDescriptor() {
        return this;
    }

    @Override
    public List<GeneralParameterDescriptor> descriptors() {
        return UnmodifiableArrayList.wrap(this.descriptors.getAllDescriptors(this.size()));
    }

    private int[] size() {
        int[] nArray = new int[this.dimensions.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.dimensions[i].intValue();
        }
        return nArray;
    }

    @Override
    public GeneralParameterDescriptor descriptor(String string) throws ParameterNotFoundException {
        string = CharSequences.trimWhitespaces(string);
        ArgumentChecks.ensureNonEmpty("name", string);
        return this.descriptors.descriptor(this, string, this.size());
    }

    @Override
    public ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        int[] nArray;
        string = CharSequences.trimWhitespaces(string);
        ArgumentChecks.ensureNonEmpty("name", string);
        IllegalArgumentException illegalArgumentException = null;
        int[] nArray2 = null;
        try {
            nArray2 = this.descriptors.nameToIndices(string);
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        if (nArray2 != null && TensorParameters.isInBounds(nArray2, nArray = this.size())) {
            return this.parameter(nArray2, nArray);
        }
        int n = this.descriptors.rank();
        for (int i = 0; i < n; ++i) {
            ParameterDescriptor<Integer> parameterDescriptor = this.descriptors.getDimensionDescriptor(i);
            if (!IdentifiedObjects.isHeuristicMatchForName(parameterDescriptor, string)) continue;
            return this.dimensions[i];
        }
        throw (ParameterNotFoundException)new ParameterNotFoundException(Resources.format((short)61, this.getName(), string), string).initCause(illegalArgumentException);
    }

    private ParameterValue<E> parameter(int[] nArray, int[] nArray2) {
        int n = this.dimensions.length;
        if (nArray.length != n) {
            throw new IllegalArgumentException(Errors.format((short)133, n, nArray.length));
        }
        Object object = null;
        Object object2 = this.values;
        for (int i = 0; i < n; ++i) {
            if (object2 == null) {
                Class<?> clazz = Classes.changeArrayDimension(ParameterValue.class, n - i - 1);
                object2 = Array.newInstance(clazz, nArray2[i]);
                if (object != null) {
                    object[nArray[i - 1]] = object2;
                } else {
                    this.values = object2;
                }
            } else if (((Object[])object2).length <= nArray[i]) {
                object[nArray[i - 1]] = object2 = Arrays.copyOf(object2, nArray2[i]);
            }
            object = object2;
            object2 = object[nArray[i]];
        }
        if (object2 == null) {
            object[nArray[n - 1]] = object2 = this.descriptors.getElementDescriptor(nArray).createValue();
        }
        return Parameters.cast((ParameterValue)object2, this.descriptors.getElementType());
    }

    @Override
    public List<GeneralParameterValue> values() {
        ArrayList<GeneralParameterValue> arrayList = new ArrayList<GeneralParameterValue>();
        for (ParameterValue<Integer> parameterValue : this.dimensions) {
            if (TensorValues.isOmitted(parameterValue)) continue;
            arrayList.add(parameterValue);
        }
        TensorValues.addValues(this.values, this.size(), 0, arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    private static void addValues(Object[] objectArray, int[] nArray, int n, List<GeneralParameterValue> list) {
        block4: {
            if (objectArray == null) break block4;
            int n2 = Math.min(objectArray.length, nArray[n]);
            if (++n != nArray.length) {
                for (int i = 0; i < n2; ++i) {
                    TensorValues.addValues((Object[])objectArray[i], nArray, n, list);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    ParameterValue parameterValue = (ParameterValue)objectArray[i];
                    if (parameterValue == null || TensorValues.isOmitted(parameterValue)) continue;
                    list.add(parameterValue);
                }
            }
        }
    }

    private static boolean isOmitted(ParameterValue<?> parameterValue) {
        Object obj = parameterValue.getValue();
        if (obj == null) {
            return true;
        }
        GeneralParameterDescriptor generalParameterDescriptor = parameterValue.getDescriptor();
        return generalParameterDescriptor.getMinimumOccurs() == 0 && obj.equals(generalParameterDescriptor.getDefaultValue());
    }

    @Override
    public List<ParameterValueGroup> groups(String string) throws ParameterNotFoundException {
        throw new ParameterNotFoundException(Resources.format((short)61, this.getName(), string), string);
    }

    @Override
    public ParameterValueGroup addGroup(String string) throws ParameterNotFoundException, IllegalStateException {
        throw new ParameterNotFoundException(Resources.format((short)61, this.getName(), string), string);
    }

    final Matrix toMatrix() {
        int n = this.dimensions[0].intValue();
        int n2 = this.dimensions[1].intValue();
        MatrixSIS matrixSIS = Matrices.createDiagonal(n, n2);
        if (this.values != null) {
            for (int i = 0; i < n; ++i) {
                ParameterValue[] parameterValueArray = (ParameterValue[])this.values[i];
                if (parameterValueArray == null) continue;
                for (int j = 0; j < n2; ++j) {
                    ParameterValue parameterValue = parameterValueArray[j];
                    if (parameterValue == null) continue;
                    matrixSIS.setElement(i, j, parameterValue.doubleValue());
                }
            }
        }
        return matrixSIS;
    }

    final void setMatrix(Matrix matrix) {
        int n = matrix.getNumRow();
        int n2 = matrix.getNumCol();
        this.dimensions[0].setValue(n);
        this.dimensions[1].setValue(n2);
        this.values = null;
        int[] nArray = new int[2];
        for (int i = 0; i < n; ++i) {
            nArray[0] = i;
            ParameterValue[] parameterValueArray = null;
            for (int j = 0; j < n2; ++j) {
                nArray[1] = j;
                ParameterDescriptor<E> parameterDescriptor = this.descriptors.getElementDescriptor(nArray);
                E e = parameterDescriptor.getDefaultValue();
                double d = matrix.getElement(i, j);
                if (e instanceof Number && Numerics.equalsIgnoreZeroSign(d, ((Number)e).doubleValue())) continue;
                GeneralParameterValue generalParameterValue = parameterDescriptor.createValue();
                generalParameterValue.setValue(d);
                if (parameterValueArray == null) {
                    parameterValueArray = new ParameterValue[n2];
                    if (this.values == null) {
                        this.values = new ParameterValue[n][];
                    }
                    this.values[i] = parameterValueArray;
                }
                parameterValueArray[j] = generalParameterValue;
            }
        }
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            TensorValues tensorValues = (TensorValues)object;
            return Utilities.deepEquals(this.descriptors, tensorValues.descriptors, comparisonMode) && Utilities.deepEquals(this.values(), tensorValues.values(), comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)this.descriptors.hashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendParamMT(this, formatter);
        return "ParameterGroup";
    }
}

