/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.aggregate.DimensionSelector;
import org.apache.sis.storage.aggregate.GroupByCRS;
import org.apache.sis.storage.aggregate.GroupByTransform;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

final class GridSlice {
    final GridCoverageResource resource;
    private final GridGeometry geometry;
    private final long[] offset;

    GridSlice(GridCoverageResource gridCoverageResource) throws DataStoreException {
        this.resource = gridCoverageResource;
        this.geometry = gridCoverageResource.getGridGeometry();
        this.offset = new long[this.geometry.getDimension()];
    }

    private void setOffset(MatrixSIS matrixSIS) {
        int n = matrixSIS.getNumCol() - 1;
        for (int i = 0; i < this.offset.length; ++i) {
            this.offset[i] = matrixSIS.getInteger(i, n);
        }
    }

    private static boolean isIntegerTranslation(Matrix matrix) {
        int n = matrix.getNumRow();
        int n2 = matrix.getNumCol();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = 1.0E-13;
                double d2 = matrix.getElement(i, j);
                if (j == i) {
                    d2 -= 1.0;
                } else if (j == n2 - 1) {
                    double d3 = Math.abs(d2);
                    if (d3 > 1.0) {
                        d = Math.min(d * d3, 0.125);
                    }
                    d2 -= Math.rint(d2);
                }
                if (Math.abs(d2) <= d) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final GroupByTransform getList(List<GroupByCRS<GroupByTransform>> list, MergeStrategy mergeStrategy) throws NoninvertibleTransformException {
        List list2;
        MathTransform mathTransform = this.geometry.getGridToCRS(PixelInCell.CELL_CORNER);
        MathTransform mathTransform2 = mathTransform.inverse();
        List list3 = list2 = GroupByCRS.getOrAdd(list, (GridGeometry)this.geometry).members;
        synchronized (list3) {
            for (GroupByTransform groupByTransform : list2) {
                Matrix matrix = groupByTransform.linearTransform(mathTransform2);
                if (matrix == null || !GridSlice.isIntegerTranslation(matrix)) continue;
                this.setOffset(MatrixSIS.castOrCopy(matrix));
                groupByTransform.strategy = mergeStrategy;
                return groupByTransform;
            }
            GroupByTransform groupByTransform = new GroupByTransform(this.geometry, mathTransform, mergeStrategy);
            list2.add(groupByTransform);
            return groupByTransform;
        }
    }

    final GridExtent getGridExtent() {
        return this.geometry.getExtent();
    }

    final void getGridExtent(int n, DimensionSelector[] dimensionSelectorArray) {
        GridExtent gridExtent = this.getGridExtent();
        int n2 = dimensionSelectorArray.length;
        while (--n2 >= 0) {
            dimensionSelectorArray[n2].setSliceExtent(n, Math.subtractExact(gridExtent.getMedian(n2), this.offset[n2]), gridExtent.getSize(n2));
        }
    }

    final long getGridLow(int n) {
        return Math.subtractExact(this.geometry.getExtent().getLow(n), this.offset[n]);
    }

    final long[] getOffset(Map<GridSlice, long[]> map) {
        long[] lArray = map.putIfAbsent(this, this.offset);
        return lArray != null ? lArray : this.offset;
    }

    public final boolean equals(Object object) {
        return object instanceof GridSlice && Arrays.equals(((GridSlice)object).offset, this.offset);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.offset);
    }

    public String toString() {
        String string = null;
        if (this.resource != null) {
            try {
                string = this.resource.getIdentifier().orElse(null);
            }
            catch (DataStoreException dataStoreException) {
                string = dataStoreException.toString();
            }
        }
        return Strings.toString(this.getClass(), null, string);
    }
}

