/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.sis.geometry.DirectPosition1D;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.Line;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Plane;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.builder.Linearizer;
import org.apache.sis.referencing.operation.builder.LocalizationGridException;
import org.apache.sis.referencing.operation.builder.ProjectedTransformTry;
import org.apache.sis.referencing.operation.builder.TransformBuilder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.util.DirectPositionView;
import org.apache.sis.referencing.util.ExtendedPrecisionMatrix;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.internal.AbstractMap;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class LinearTransformBuilder
extends TransformBuilder {
    private final int[] gridSize;
    private double[][] sources;
    private double[][] targets;
    final int gridLength;
    private int numPoints;
    private List<ProjectedTransformTry> linearizers;
    private transient ProjectedTransformTry appliedLinearizer;
    private transient LinearTransform transform;
    private transient double[] correlations;

    private LinearTransformBuilder(LinearTransformBuilder original) {
        this.gridSize = original.gridSize;
        this.sources = original.sources;
        this.gridLength = original.gridLength;
        this.numPoints = original.numPoints;
    }

    public LinearTransformBuilder() {
        this.gridSize = null;
        this.gridLength = 0;
    }

    public LinearTransformBuilder(int ... gridSize) {
        ArgumentChecks.ensureNonEmptyBounded("gridSize", false, 1, Integer.MAX_VALUE, gridSize);
        if (gridSize.length == 0) {
            this.gridSize = null;
            this.gridLength = 0;
        } else {
            gridSize = (int[])gridSize.clone();
            long length = 1L;
            for (int s : gridSize) {
                ArgumentChecks.ensureStrictlyPositive("gridSize", s);
                length = Math.multiplyExact(length, s);
            }
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(Errors.format((short)166, "\u220fgridSize", 1, Integer.MAX_VALUE, length));
            }
            this.gridSize = gridSize;
            this.gridLength = (int)length;
        }
    }

    public static LinearTransform approximate(MathTransform gridToCRS, Envelope domain) throws FactoryException {
        ArgumentChecks.ensureNonNull("gridToCRS", gridToCRS);
        ArgumentChecks.ensureNonNull("domain", domain);
        try {
            return (LinearTransform)Linearizer.approximate(gridToCRS, domain);
        }
        catch (TransformException e) {
            throw new LocalizationGridException(e);
        }
    }

    final int gridSize(int srcDim) {
        return this.gridSize[srcDim];
    }

    private void allocate(int tgtDim) {
        for (double[] r : this.targets = new double[tgtDim][this.gridLength]) {
            Arrays.fill(r, Double.NaN);
        }
    }

    private static void resize(double[][] data, int capacity) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = ArraysExt.resize(data[i], capacity);
        }
    }

    private int search(int[] source) {
        assert (this.gridSize == null);
        int j = this.numPoints;
        block0: while (--j >= 0) {
            for (int i = 0; i < source.length; ++i) {
                if ((double)source[i] != this.sources[i][j]) continue block0;
            }
            return j;
        }
        return -1;
    }

    private int flatIndex(int[] source) {
        assert (this.sources == null);
        int offset = 0;
        int i = this.gridSize.length;
        while (i != 0) {
            int size = this.gridSize[--i];
            int index = source[i];
            if (index < 0 || index >= size) {
                throw new IllegalArgumentException(Errors.format((short)166, "source", 0, size - 1, index));
            }
            offset = offset * size + index;
        }
        return offset;
    }

    private int flatIndex(DirectPosition source) {
        assert (this.sources == null);
        int offset = 0;
        int i = this.gridSize.length;
        while (i != 0) {
            int size = this.gridSize[--i];
            double coordinate = source.getOrdinate(i);
            int index = (int)coordinate;
            if ((double)index != coordinate) {
                throw new IllegalArgumentException(Errors.format((short)171, coordinate));
            }
            if (index < 0 || index >= size) {
                throw new IllegalArgumentException(Errors.format((short)166, "source", 0, size - 1, index));
            }
            offset = offset * size + index;
        }
        return offset;
    }

    final boolean isModifiable() {
        return this.transform == null;
    }

    private void ensureModifiable() throws IllegalStateException {
        if (this.transform != null) {
            throw new IllegalStateException(Errors.format((short)153, LinearTransformBuilder.class));
        }
    }

    private void verifySourceDimension(int actual) throws MismatchedDimensionException {
        int expected;
        if (this.gridSize != null) {
            expected = this.gridSize.length;
        } else if (this.sources != null) {
            expected = this.sources.length;
        } else {
            return;
        }
        if (actual != expected) {
            throw new MismatchedDimensionException(Errors.format((short)81, "source", expected, actual));
        }
    }

    private MismatchedDimensionException mismatchedDimension(String name, int expected, int actual) {
        return new MismatchedDimensionException(Errors.format((short)81, Strings.toIndexed(name, this.numPoints), expected, actual));
    }

    private static String noData() {
        return Resources.format((short)81);
    }

    final int getGridDimensions() {
        return this.gridSize != null ? this.gridSize.length : -1;
    }

    public int getSourceDimensions() {
        if (this.gridSize != null) {
            return this.gridSize.length;
        }
        if (this.sources != null) {
            return this.sources.length;
        }
        throw new IllegalStateException(LinearTransformBuilder.noData());
    }

    public int getTargetDimensions() {
        if (this.targets != null) {
            return this.targets.length;
        }
        throw new IllegalStateException(LinearTransformBuilder.noData());
    }

    public Envelope getSourceEnvelope() {
        if (this.gridSize != null) {
            int dim = this.gridSize.length;
            GeneralEnvelope envelope = new GeneralEnvelope(dim);
            for (int i = 0; i < dim; ++i) {
                envelope.setRange(i, 0.0, this.gridSize[i] - 1);
            }
            return envelope;
        }
        return LinearTransformBuilder.envelope(this.sources, this.numPoints);
    }

    public Envelope getTargetEnvelope() {
        return LinearTransformBuilder.envelope(this.targets, this.gridLength != 0 ? this.gridLength : this.numPoints);
    }

    private static Envelope envelope(double[][] points, int numPoints) {
        if (points == null) {
            throw new IllegalStateException(LinearTransformBuilder.noData());
        }
        int dim = points.length;
        GeneralEnvelope envelope = new GeneralEnvelope(dim);
        for (int i = 0; i < dim; ++i) {
            double[] values = points[i];
            double lower = Double.POSITIVE_INFINITY;
            double upper = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < numPoints; ++j) {
                double value = values[j];
                if (value < lower) {
                    lower = value;
                }
                if (!(value > upper)) continue;
                upper = value;
            }
            if (lower > upper) {
                upper = Double.NaN;
                lower = Double.NaN;
            }
            envelope.setRange(i, lower, upper);
        }
        return envelope;
    }

    private static DirectPosition position(Position p) {
        return p != null ? p.getDirectPosition() : null;
    }

    public void setControlPoints(MathTransform gridToCRS) throws TransformException {
        ArgumentChecks.ensureNonNull("gridToCRS", gridToCRS);
        if (this.gridSize == null) {
            throw new IllegalStateException(Resources.format((short)99));
        }
        int srcDim = gridToCRS.getSourceDimensions();
        if (srcDim != this.gridSize.length) {
            throw new MismatchedDimensionException(Errors.format((short)190, "gridToCRS", 0, this.gridSize.length, srcDim));
        }
        int tgtDim = gridToCRS.getTargetDimensions();
        this.allocate(tgtDim);
        int width = this.gridSize[0];
        int widthTarget = width * tgtDim;
        double[] buffer = new double[Math.max(srcDim, tgtDim) * width];
        double[] point = new double[srcDim];
        block0: for (int j = 0; j < this.gridLength; j += width) {
            int i;
            for (i = 0; i < width; ++i) {
                point[0] = i;
                System.arraycopy(point, 0, buffer, i * srcDim, srcDim);
            }
            gridToCRS.transform(buffer, 0, buffer, 0, width);
            for (int dim = 0; dim < tgtDim; ++dim) {
                double[] target = this.targets[dim];
                int i2 = j;
                for (int t = dim; t < widthTarget; t += tgtDim) {
                    target[i2++] = buffer[t];
                }
            }
            for (i = 1; i < this.gridSize.length; ++i) {
                int n = i;
                double d = point[n];
                point[n] = d + 1.0;
                if (d < (double)this.gridSize[i]) continue block0;
                point[i] = 0.0;
            }
        }
    }

    public void setControlPoints(Map<? extends Position, ? extends Position> sourceToTarget) throws MismatchedDimensionException {
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull("sourceToTarget", sourceToTarget);
        this.sources = null;
        this.targets = null;
        this.numPoints = 0;
        int srcDim = 0;
        int tgtDim = 0;
        for (Map.Entry<? extends Position, ? extends Position> entry : sourceToTarget.entrySet()) {
            int i;
            int index;
            int d;
            DirectPosition tgt;
            DirectPosition src = LinearTransformBuilder.position(entry.getKey());
            if (src == null || (tgt = LinearTransformBuilder.position(entry.getValue())) == null) continue;
            if (this.targets == null) {
                tgtDim = tgt.getDimension();
                if (tgtDim <= 0) {
                    throw this.mismatchedDimension("target", 2, tgtDim);
                }
                if (this.gridSize == null) {
                    srcDim = src.getDimension();
                    if (srcDim <= 0) {
                        throw this.mismatchedDimension("source", 2, srcDim);
                    }
                    int capacity = sourceToTarget.size();
                    this.sources = new double[srcDim][capacity];
                    this.targets = new double[tgtDim][capacity];
                } else {
                    srcDim = this.gridSize.length;
                    this.allocate(tgtDim);
                }
            }
            if ((d = src.getDimension()) != srcDim) {
                throw this.mismatchedDimension("source", srcDim, d);
            }
            d = tgt.getDimension();
            if (d != tgtDim) {
                throw this.mismatchedDimension("target", tgtDim, d);
            }
            boolean isValid = true;
            if (this.gridSize != null) {
                index = this.flatIndex(src);
            } else {
                index = this.numPoints;
                for (i = 0; i < srcDim; ++i) {
                    double d2 = src.getOrdinate(i);
                    this.sources[i][index] = d2;
                    isValid &= Double.isFinite(d2);
                }
            }
            for (i = 0; i < tgtDim; ++i) {
                double d3 = tgt.getOrdinate(i);
                this.targets[i][index] = d3;
                isValid &= Double.isFinite(d3);
            }
            if (isValid) {
                ++this.numPoints;
                continue;
            }
            this.targets[0][index] = Double.NaN;
            throw new IllegalArgumentException(Errors.format((short)185, src, tgt));
        }
    }

    public Map<DirectPosition, DirectPosition> getControlPoints() {
        return this.gridSize != null ? new ControlPoints() : new Ungridded();
    }

    public void setControlPoint(int[] source, double[] target) {
        int i;
        int index;
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull("source", source);
        ArgumentChecks.ensureNonNull("target", target);
        this.verifySourceDimension(source.length);
        int tgtDim = target.length;
        if (this.targets != null && tgtDim != this.targets.length) {
            throw new MismatchedDimensionException(Errors.format((short)81, "target", this.targets.length, tgtDim));
        }
        if (this.gridSize != null) {
            index = this.flatIndex(source);
            if (this.targets == null) {
                this.allocate(tgtDim);
            }
            if (Double.isNaN(this.targets[0][index])) {
                ++this.numPoints;
            }
        } else {
            int srcDim = source.length;
            if (this.targets == null) {
                this.targets = new double[tgtDim][20];
                this.sources = new double[srcDim][20];
            }
            if ((index = this.search(source)) < 0) {
                index = this.numPoints++;
                if (this.numPoints >= this.targets[0].length) {
                    int n = Math.multiplyExact(this.numPoints, 2);
                    LinearTransformBuilder.resize(this.sources, n);
                    LinearTransformBuilder.resize(this.targets, n);
                }
            }
            for (i = 0; i < srcDim; ++i) {
                this.sources[i][index] = source[i];
            }
        }
        boolean isValid = true;
        for (i = 0; i < tgtDim; ++i) {
            double d = target[i];
            this.targets[i][index] = d;
            isValid &= Double.isFinite(d);
        }
        if (!isValid) {
            --this.numPoints;
            for (i = 0; i < tgtDim; ++i) {
                this.targets[i][index] = Double.NaN;
            }
            throw new IllegalArgumentException(Errors.format((short)185, source, new DirectPositionView.Double(target)));
        }
    }

    public double[] getControlPoint(int[] source) {
        int index;
        ArgumentChecks.ensureNonNull("source", source);
        this.verifySourceDimension(source.length);
        if (this.targets == null) {
            return null;
        }
        if (this.gridSize != null) {
            index = this.flatIndex(source);
        } else {
            index = this.search(source);
            if (index < 0) {
                return null;
            }
        }
        double[] target = new double[this.targets.length];
        for (int i = 0; i < target.length; ++i) {
            target[i] = this.targets[i][index];
            if (!Double.isNaN(target[i])) continue;
            return null;
        }
        return target;
    }

    final void setControlPoints(Vector[] coordinates) {
        assert (this.gridSize != null);
        int tgtDim = coordinates.length;
        double[][] result = new double[tgtDim][];
        for (int i = 0; i < tgtDim; ++i) {
            Vector c = coordinates[i];
            ArgumentChecks.ensureNonNullElement("coordinates", i, c);
            int size = c.size();
            if (size == this.gridLength && (size = (result[i] = c.doubleValues()).length) == this.gridLength) continue;
            throw new IllegalArgumentException(Errors.format((short)133, this.gridLength, size));
        }
        this.targets = result;
        this.numPoints = this.gridLength;
    }

    final void getControlRow(int[] source, double[] target) {
        assert (this.gridSize != null);
        int start = this.flatIndex(source);
        int stop = start + this.gridSize[0];
        int tgtDim = this.targets.length;
        for (int j = 0; j < tgtDim; ++j) {
            int index = j;
            double[] row = this.targets[j];
            for (int i = start; i < stop; ++i) {
                target[index] = row[i];
                index += tgtDim;
            }
        }
    }

    final Vector getTransect(int dimension, int[] start, int direction) {
        int first = this.flatIndex(start);
        int step = 1;
        for (int i = 0; i < direction; ++i) {
            step *= this.gridSize[i];
        }
        return Vector.create(this.targets[dimension]).subSampling(first, step, this.gridSize[direction] - start[direction]);
    }

    final NumberRange<Double> resolveWraparoundAxis(int dimension, int direction, double period) {
        double[] coordinates = this.targets[dimension];
        int stride = 1;
        for (int i = 0; i < direction; ++i) {
            stride *= this.gridSize[i];
        }
        int page = stride * this.gridSize[direction];
        double threshold = period / 2.0;
        double minValue = Double.POSITIVE_INFINITY;
        double maxValue = Double.NEGATIVE_INFINITY;
        double minAfter = Double.POSITIVE_INFINITY;
        double maxAfter = Double.NEGATIVE_INFINITY;
        double previous = coordinates[0];
        for (int x = 0; x < stride; ++x) {
            for (int y = 0; y < this.gridLength; y += page) {
                int stop = y + page;
                for (int i = x + y; i < stop; i += stride) {
                    double delta;
                    double value = coordinates[i];
                    if (value < minValue) {
                        minValue = value;
                    }
                    if (value > maxValue) {
                        maxValue = value;
                    }
                    if (Math.abs(delta = value - previous) > threshold) {
                        delta = Math.rint(delta / period) * period;
                        coordinates[i] = value -= delta;
                    }
                    previous = value;
                    if (value < minAfter) {
                        minAfter = value;
                    }
                    if (!(value > maxAfter)) continue;
                    maxAfter = value;
                }
                previous = coordinates[x];
            }
        }
        double shift = 0.0;
        if (maxValue - minValue > period) {
            minValue = -period;
            maxValue = period;
        }
        double \u0394min = minValue - minAfter;
        double \u0394max = maxValue - maxAfter;
        if (\u0394min != 0.0 || \u0394max != 0.0) {
            double intersection = 0.0;
            double minCycles = Math.floor(Math.min(\u0394min, \u0394max) / period);
            double maxCycles = Math.ceil(Math.max(\u0394min, \u0394max) / period);
            for (double cycles = minCycles; cycles <= maxCycles; cycles += 1.0) {
                double s = cycles * period;
                double p = Math.min(maxValue, maxAfter + s) - Math.max(minValue, minAfter + s);
                if (!(p > intersection)) continue;
                intersection = p;
                shift = s;
            }
            if (shift != 0.0) {
                int i = 0;
                while (i < coordinates.length) {
                    int n = i++;
                    coordinates[n] = coordinates[n] + shift;
                }
            }
        }
        return NumberRange.create(minAfter + shift, true, maxAfter + shift, true);
    }

    final Vector[] sources() {
        if (this.sources != null) {
            Vector[] v = new Vector[this.sources.length];
            for (int i = 0; i < v.length; ++i) {
                v[i] = this.vector(this.sources[i]);
            }
            return v;
        }
        throw new IllegalStateException(LinearTransformBuilder.noData());
    }

    public void addLinearizers(Map<String, MathTransform> projections, int ... projToGrid) {
        ArgumentChecks.ensureNonNull("projections", projections);
        this.addLinearizers(projections, false, projToGrid);
    }

    final void addLinearizers(Map<String, MathTransform> projections, boolean compensate, int[] projToGrid) {
        this.ensureModifiable();
        int tgtDim = this.getTargetDimensions();
        if (projToGrid == null || projToGrid.length == 0) {
            projToGrid = ArraysExt.range(0, tgtDim);
        } else {
            long defined = 0L;
            for (int d : projToGrid = (int[])projToGrid.clone()) {
                ArgumentChecks.ensureValidIndex(tgtDim, d);
                if (defined != (defined |= Numerics.bitmask(d))) continue;
                throw new IllegalArgumentException(Errors.format((short)187, d));
            }
        }
        if (this.linearizers == null) {
            this.linearizers = new ArrayList<ProjectedTransformTry>(projections.size());
        }
        for (Map.Entry<String, MathTransform> entry : projections.entrySet()) {
            this.linearizers.add(new ProjectedTransformTry(entry.getKey(), entry.getValue(), projToGrid, tgtDim, compensate));
        }
    }

    final void setLinearizers(LinearTransformBuilder other) {
        if (other.linearizers != null) {
            this.linearizers = new ArrayList<ProjectedTransformTry>(other.linearizers);
            this.linearizers.replaceAll(ProjectedTransformTry::new);
        }
    }

    @Override
    public LinearTransform create(MathTransformFactory factory) throws FactoryException {
        if (this.transform == null) {
            MatrixSIS bestTransform;
            if (this.linearizers == null || this.linearizers.isEmpty()) {
                bestTransform = this.fit();
            } else {
                bestTransform = null;
                double bestCorrelation = 0.0;
                double[] bestCorrelations = null;
                double[][] transformedArrays = null;
                double sqrtCorrLength = Math.sqrt(this.targets.length);
                ProjectedTransformTry identity = null;
                for (ProjectedTransformTry alt : this.linearizers) {
                    if (!alt.projection.isIdentity()) continue;
                    bestTransform = this.fit();
                    bestCorrelations = this.correlations;
                    bestCorrelation = LinearTransformBuilder.rms(bestCorrelations, sqrtCorrLength);
                    transformedArrays = this.targets;
                    this.appliedLinearizer = alt;
                    identity = alt;
                    alt.correlation = (float)bestCorrelation;
                    break;
                }
                ArrayDeque<double[]> pool = new ArrayDeque<double[]>();
                LinearTransformBuilder tmp = new LinearTransformBuilder(this);
                int numPoints = this.gridLength != 0 ? this.gridLength : this.numPoints;
                boolean needTargetReplace = false;
                for (ProjectedTransformTry alt : this.linearizers) {
                    if (alt == identity || (tmp.targets = alt.transform(this.targets, numPoints, pool)) == null) continue;
                    if (bestTransform == null) {
                        transformedArrays = tmp.targets = alt.replaceTransformed(this.targets, tmp.targets);
                        bestTransform = tmp.fit();
                        bestCorrelations = tmp.correlations;
                        bestCorrelation = LinearTransformBuilder.rms(bestCorrelations, sqrtCorrLength);
                        alt.correlation = (float)bestCorrelation;
                        this.appliedLinearizer = alt;
                        continue;
                    }
                    MatrixSIS altTransform = tmp.fit();
                    double[] altCorrelations = alt.replaceTransformed(bestCorrelations, tmp.correlations);
                    double altCorrelation = LinearTransformBuilder.rms(altCorrelations, sqrtCorrLength);
                    alt.correlation = (float)altCorrelation;
                    if (altCorrelation > bestCorrelation) {
                        ProjectedTransformTry.recycle(transformedArrays, pool);
                        transformedArrays = tmp.targets;
                        bestCorrelation = altCorrelation;
                        bestCorrelations = altCorrelations;
                        bestTransform = alt.replaceTransformed(bestTransform, altTransform);
                        this.appliedLinearizer = alt;
                        needTargetReplace = true;
                        continue;
                    }
                    ProjectedTransformTry.recycle(tmp.targets, pool);
                }
                if (bestTransform == null) {
                    throw new LocalizationGridException(Resources.format((short)100), ProjectedTransformTry.getError(this.linearizers));
                }
                if (needTargetReplace) {
                    transformedArrays = this.appliedLinearizer.replaceTransformed(this.targets, transformedArrays);
                }
                this.targets = transformedArrays;
                this.correlations = bestCorrelations;
            }
            this.transform = (LinearTransform)LinearTransformBuilder.nonNull(factory).createAffineTransform(bestTransform);
        }
        return this.transform;
    }

    private MatrixSIS fit() throws FactoryException {
        double[][] sources = this.sources;
        double[][] targets = this.targets;
        if (targets == null) {
            throw new InvalidGeodeticParameterException(LinearTransformBuilder.noData());
        }
        int sourceDim = sources != null ? sources.length : this.gridSize.length;
        int targetDim = targets.length;
        this.correlations = new double[targetDim];
        final MatrixSIS matrix = Matrices.create(targetDim + 1, sourceDim + 1, ExtendedPrecisionMatrix.CREATE_ZERO);
        matrix.setElement(targetDim, sourceDim, 1.0);
        for (int j = 0; j < targetDim; ++j) {
            double c;
            switch (sourceDim) {
                case 1: {
                    final int row = j;
                    Line line = new Line(){

                        @Override
                        public void setEquation(Number slope, Number y0) {
                            super.setEquation(slope, y0);
                            matrix.setNumber(row, 0, slope);
                            matrix.setNumber(row, 1, y0);
                        }
                    };
                    if (sources != null) {
                        c = line.fit(this.vector(sources[0]), this.vector(targets[j]));
                        break;
                    }
                    c = line.fit(Vector.createSequence(0, 1, this.gridSize[0]), Vector.create(targets[j]));
                    break;
                }
                case 2: {
                    final int row = j;
                    Plane plan = new Plane(){

                        @Override
                        public void setEquation(Number sx, Number sy, Number z0) {
                            super.setEquation(sx, sy, z0);
                            matrix.setNumber(row, 0, sx);
                            matrix.setNumber(row, 1, sy);
                            matrix.setNumber(row, 2, z0);
                        }
                    };
                    if (sources != null) {
                        c = plan.fit(this.vector(sources[0]), this.vector(sources[1]), this.vector(targets[j]));
                        break;
                    }
                    try {
                        c = plan.fit(this.gridSize[0], this.gridSize[1], Vector.create(targets[j]));
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidGeodeticParameterException(LinearTransformBuilder.noData(), e);
                    }
                }
                default: {
                    throw new InvalidGeodeticParameterException(Errors.format((short)37, sourceDim));
                }
            }
            this.correlations[j] = c;
        }
        return matrix;
    }

    private Vector vector(double[] data) {
        assert (this.gridSize == null);
        return Vector.create(data).subList(0, this.numPoints);
    }

    private static double rms(double[] correlations, double sqrtCorrLength) {
        return MathFunctions.magnitude(correlations) / sqrtCorrLength;
    }

    public Optional<Map.Entry<String, MathTransform>> linearizer() {
        return Optional.ofNullable(this.appliedLinearizer);
    }

    final ProjectedTransformTry appliedLinearizer() {
        return this.appliedLinearizer;
    }

    public double[] correlation() {
        return this.correlations != null ? (double[])this.correlations.clone() : null;
    }

    final LinearTransform transform() {
        return this.transform;
    }

    public String toString() {
        String lineSeparator;
        StringBuilder buffer = new StringBuilder(400);
        try {
            lineSeparator = this.appendTo(buffer, this.getClass(), null, (short)174);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Strings.insertLineInLeftMargin(buffer, lineSeparator);
        return buffer.toString();
    }

    final String appendTo(StringBuilder buffer, Class<?> caller, Locale locale, short resultKey) throws IOException {
        String lineSeparator = System.lineSeparator();
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        buffer.append(Classes.getShortName(caller)).append('[').append(this.numPoints).append(" points");
        if (this.gridSize != null) {
            String separator = " on ";
            for (int size : this.gridSize) {
                buffer.append(separator).append(size);
                separator = " \u00d7 ";
            }
            buffer.append(" grid");
        }
        buffer.append(']').append(lineSeparator);
        if (this.linearizers != null) {
            Object[] alternatives = (ProjectedTransformTry[])this.linearizers.toArray(ProjectedTransformTry[]::new);
            Arrays.sort(alternatives);
            buffer.append("\u25b6\u00a0");
            vocabulary.appendLabel((short)161, buffer);
            buffer.append(lineSeparator);
            NumberFormat nf = null;
            TableAppender table = new TableAppender(buffer, " \u2502 ");
            table.appendHorizontalSeparator();
            table.append(vocabulary.getString((short)34)).nextColumn();
            table.append(vocabulary.getString((short)37)).nextLine();
            table.appendHorizontalSeparator();
            for (Object alt : alternatives) {
                nf = ((ProjectedTransformTry)alt).summarize(table, nf, locale);
            }
            table.appendHorizontalSeparator();
            table.flush();
        }
        if (this.transform != null) {
            buffer.append("\u25b6\u00a0");
            vocabulary.appendLabel(resultKey, buffer);
            buffer.append(lineSeparator);
            TableAppender table = new TableAppender(buffer, " ");
            table.setMultiLinesCells(true);
            table.append(Matrices.toString(this.transform.getMatrix())).nextColumn();
            table.append(lineSeparator).append("  ").append(vocabulary.getString((short)37)).append(" =").nextColumn();
            table.append(Matrices.create(this.correlations.length, 1, this.correlations).toString());
            table.flush();
        }
        return lineSeparator;
    }

    private class ControlPoints
    extends AbstractMap<DirectPosition, DirectPosition> {
        ControlPoints() {
        }

        final DirectPosition position(double[][] data, int offset) {
            switch (data.length) {
                case 1: {
                    return new DirectPosition1D(data[0][offset]);
                }
                case 2: {
                    return new DirectPosition2D(data[0][offset], data[1][offset]);
                }
            }
            GeneralDirectPosition pos = new GeneralDirectPosition(data.length);
            for (int i = 0; i < data.length; ++i) {
                pos.setOrdinate(i, data[i][offset]);
            }
            return pos;
        }

        int domain() {
            return LinearTransformBuilder.this.gridLength;
        }

        final int search(double[][] data, double[] coord) {
            if (data != null && coord.length == data.length) {
                int j = this.domain();
                block0: while (--j >= 0) {
                    for (int i = 0; i < coord.length; ++i) {
                        if (coord[i] != data[i][j]) continue block0;
                    }
                    return j;
                }
            }
            return -1;
        }

        @Override
        public final boolean containsValue(Object value) {
            return value instanceof Position && this.search(LinearTransformBuilder.this.targets, ((Position)value).getDirectPosition().getCoordinate()) >= 0;
        }

        @Override
        public final boolean containsKey(Object key) {
            return key instanceof Position && this.flatIndex(((Position)key).getDirectPosition()) >= 0;
        }

        @Override
        public final DirectPosition get(Object key) {
            int index;
            if (key instanceof Position && (index = this.flatIndex(((Position)key).getDirectPosition())) >= 0) {
                return this.position(LinearTransformBuilder.this.targets, index);
            }
            return null;
        }

        int flatIndex(DirectPosition source) {
            int[] gridSize;
            int i;
            double[][] targets = LinearTransformBuilder.this.targets;
            if (targets != null && (i = (gridSize = LinearTransformBuilder.this.gridSize).length) == source.getDimension()) {
                int offset = 0;
                while (i != 0) {
                    int size = gridSize[--i];
                    double coordinate = source.getOrdinate(i);
                    int index = (int)coordinate;
                    if (index < 0 || index >= size || (double)index != coordinate) {
                        return -1;
                    }
                    offset = offset * size + index;
                }
                if (!Double.isNaN(targets[0][offset])) {
                    return offset;
                }
            }
            return -1;
        }

        @Override
        protected AbstractMap.EntryIterator<DirectPosition, DirectPosition> entryIterator() {
            return new AbstractMap.EntryIterator<DirectPosition, DirectPosition>(){
                private int index = -1;

                @Override
                protected boolean next() {
                    double[][] targets = LinearTransformBuilder.this.targets;
                    if (targets != null) {
                        double[] x = targets[0];
                        int gridLength = LinearTransformBuilder.this.gridLength;
                        while (++this.index < gridLength) {
                            if (Double.isNaN(x[this.index])) continue;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                protected DirectPosition getKey() {
                    int[] gridSize = LinearTransformBuilder.this.gridSize;
                    int dim = gridSize.length;
                    GeneralDirectPosition pos = new GeneralDirectPosition(dim);
                    int offset = this.index;
                    for (int i = 0; i < dim; ++i) {
                        int size = gridSize[i];
                        pos.setOrdinate(i, offset % size);
                        offset /= size;
                    }
                    if (offset == 0) {
                        return pos;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                protected DirectPosition getValue() {
                    return ControlPoints.this.position(LinearTransformBuilder.this.targets, this.index);
                }
            };
        }
    }

    private final class Ungridded
    extends ControlPoints {
        private Ungridded() {
        }

        @Override
        public boolean isEmpty() {
            return LinearTransformBuilder.this.numPoints == 0;
        }

        @Override
        public int size() {
            return LinearTransformBuilder.this.numPoints;
        }

        @Override
        int domain() {
            return LinearTransformBuilder.this.numPoints;
        }

        @Override
        int flatIndex(DirectPosition source) {
            return this.search(LinearTransformBuilder.this.sources, source.getCoordinate());
        }

        @Override
        protected AbstractMap.EntryIterator<DirectPosition, DirectPosition> entryIterator() {
            return new AbstractMap.EntryIterator<DirectPosition, DirectPosition>(){
                private int index = -1;

                @Override
                protected boolean next() {
                    return ++this.index < LinearTransformBuilder.this.numPoints;
                }

                @Override
                protected DirectPosition getKey() {
                    return Ungridded.this.position(LinearTransformBuilder.this.sources, this.index);
                }

                @Override
                protected DirectPosition getValue() {
                    return Ungridded.this.position(LinearTransformBuilder.this.targets, this.index);
                }
            };
        }
    }
}

