/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf.updates;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.tika.parser.pdf.updates.StartXRefOffset;

public class StartXRefScanner {
    static final int MAX_LENGTH_LONG = Long.toString(Long.MAX_VALUE).length();
    private static final char[] STARTXREF = new char[]{'s', 't', 'a', 'r', 't', 'x', 'r', 'e', 'f'};
    private static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    private static final byte ASCII_LF = 10;
    private static final byte ASCII_CR = 13;
    private static final byte ASCII_SPACE = 32;
    private final RandomAccessRead source;

    public StartXRefScanner(RandomAccessRead source) {
        this.source = source;
    }

    public List<StartXRefOffset> scan() throws IOException {
        ArrayList<StartXRefOffset> offsets = new ArrayList<StartXRefOffset>();
        try {
            int b = this.source.read();
            while (b > -1) {
                if (b == STARTXREF[0]) {
                    this.tryStartXRef(offsets);
                }
                b = this.source.read();
            }
        }
        finally {
            if (this.source.getPosition() >= Integer.MAX_VALUE) {
                throw new IOException("read more than 2147483647 bytes");
            }
            this.source.rewind((int)this.source.getPosition());
        }
        return offsets;
    }

    private void tryStartXRef(List<StartXRefOffset> offsets) throws IOException {
        int match = 1;
        boolean read = false;
        int b = this.source.read();
        while (b > -1) {
            if (b == STARTXREF[match]) {
                if (++match == STARTXREF.length) {
                    try {
                        long startXREFOffset = this.source.getPosition() - (long)STARTXREF.length;
                        long startxref = this.readLong();
                        boolean hasEof = this.readEOF();
                        long endOfEOFOffset = this.source.getPosition();
                        offsets.add(new StartXRefOffset(startxref, startXREFOffset, endOfEOFOffset, hasEof));
                        return;
                    }
                    catch (IOException e) {
                        return;
                    }
                }
            } else {
                this.source.rewind(1);
                return;
            }
            b = this.source.read();
        }
    }

    private boolean readEOF() throws IOException {
        this.skipWhiteSpaces();
        int c = this.source.read();
        int i = 0;
        while (c > -1 && c == EOF_MARKER[i] && ++i < EOF_MARKER.length) {
            c = this.source.read();
        }
        if (i == EOF_MARKER.length) {
            c = this.source.read();
            if (c != -1 && !this.isEOL(c)) {
                this.source.rewind(1);
            }
            return true;
        }
        ++i;
        if (c == -1) {
            this.source.rewind(i - 1);
        } else {
            this.source.rewind(i);
        }
        return false;
    }

    protected void skipWhiteSpaces() throws IOException {
        int whitespace = this.source.read();
        while (whitespace > -1 && this.isWhitespace(whitespace)) {
            whitespace = this.source.read();
        }
        if (whitespace > -1) {
            this.source.rewind(1);
        }
    }

    protected boolean isWhitespace(int c) {
        return c == 0 || c == 9 || c == 12 || c == 10 || c == 13 || c == 32;
    }

    protected long readLong() throws IOException {
        this.skipSpaces();
        long retval = 0L;
        StringBuilder longBuffer = this.readStringNumber();
        try {
            retval = Long.parseLong(longBuffer.toString());
        }
        catch (NumberFormatException e) {
            this.source.rewind(longBuffer.toString().getBytes(StandardCharsets.ISO_8859_1).length);
            throw new IOException("Error: Expected a long type at offset " + this.source.getPosition() + ", instead got '" + String.valueOf(longBuffer) + "'", e);
        }
        return retval;
    }

    protected void skipSpaces() throws IOException {
        int c = this.source.read();
        while (this.isWhitespace(c) || c == 37) {
            if (c == 37) {
                c = this.source.read();
                while (!this.isEOL(c) && c != -1) {
                    c = this.source.read();
                }
                continue;
            }
            c = this.source.read();
        }
        if (c != -1) {
            this.source.rewind(1);
        }
    }

    protected final StringBuilder readStringNumber() throws IOException {
        int lastByte;
        StringBuilder buffer = new StringBuilder();
        while ((lastByte = this.source.read()) >= 48 && lastByte <= 57) {
            buffer.append((char)lastByte);
            if (buffer.length() <= MAX_LENGTH_LONG) continue;
            throw new IOException("Number '" + String.valueOf(buffer) + "' is getting too long, stop reading at offset " + this.source.getPosition());
        }
        if (lastByte == -1) {
            throw new IOException("number ended at EOF");
        }
        if (lastByte != -1) {
            this.source.rewind(1);
        }
        return buffer;
    }

    protected boolean isEOL(int c) {
        return this.isLF(c) || this.isCR(c);
    }

    private boolean isLF(int c) {
        return 10 == c;
    }

    private boolean isCR(int c) {
        return 13 == c;
    }
}

