/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.system.DataDirectory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.util.FactoryException;

abstract class DatumShiftGridLoader {
    static final double DEGREES_TO_SECONDS = 3600.0;
    static final double SECOND_PRECISION = 1.0E-4;
    final URI file;
    private final ReadableByteChannel channel;
    final ByteBuffer buffer;
    private static final AtomicBoolean datumDirectoryLogged = new AtomicBoolean();

    DatumShiftGridLoader(ReadableByteChannel channel, ByteBuffer buffer, URI file) throws IOException {
        this.file = file;
        this.buffer = buffer;
        this.channel = channel;
        channel.read(buffer);
        buffer.flip();
    }

    final void ensureBufferContains(int n) throws IOException {
        assert (n >= 0 && n <= this.buffer.capacity()) : n;
        if ((n -= this.buffer.remaining()) > 0) {
            int c;
            this.buffer.compact();
            do {
                if ((c = this.channel.read(this.buffer)) > 0) continue;
                if (c != 0) {
                    throw new EOFException(Errors.format((short)137, this.file));
                }
                throw new IOException(Errors.format((short)12, this.file));
            } while ((n -= c) > 0);
            this.buffer.flip();
        }
    }

    final void skip(int n) throws IOException {
        int p;
        while ((p = this.buffer.position() + n) > this.buffer.limit()) {
            this.buffer.clear();
            this.ensureBufferContains(Math.min(n -= this.buffer.remaining(), this.buffer.capacity()));
        }
        this.buffer.position(p);
    }

    static URI toAbsolutePath(URI path) throws NoSuchFileException {
        String message;
        if (path.isAbsolute()) {
            return path;
        }
        if (path.isOpaque()) {
            message = Errors.format((short)9, path);
        } else {
            Path dir = DataDirectory.DATUM_CHANGES.getDirectory();
            if (dir != null) {
                return dir.resolve(path.getPath()).toUri();
            }
            String env = DataDirectory.getenv();
            message = env == null ? Messages.format((short)16, "SIS_DATA") : Messages.format((short)15, "SIS_DATA", env);
        }
        throw new NoSuchFileException(path.toString(), null, message);
    }

    static ReadableByteChannel newByteChannel(URI path) throws IOException {
        try {
            return Files.newByteChannel(Path.of(path), new OpenOption[0]);
        }
        catch (FileSystemNotFoundException e) {
            Logging.ignorableException(AbstractProvider.LOGGER, DatumShiftGridLoader.class, "newByteChannel", e);
            return Channels.newChannel(path.toURL().openStream());
        }
    }

    static void startLoading(Class<?> caller, Object file) {
        DatumShiftGridLoader.log(caller, Resources.forLocale(null).getLogRecord(Level.FINE, (short)32, file));
    }

    static void log(Class<?> caller, LogRecord record) {
        Logging.completeAndLog(AbstractProvider.LOGGER, caller, "createMathTransform", record);
    }

    static FactoryException canNotLoad(String format, URI file, Exception cause) {
        Path directory;
        if (!datumDirectoryLogged.get() && (directory = DataDirectory.DATUM_CHANGES.getDirectory()) != null && !datumDirectoryLogged.getAndSet(true)) {
            LogRecord record = Resources.forLocale(null).getLogRecord(Level.INFO, (short)92, directory);
            Logging.completeAndLog(AbstractProvider.LOGGER, DatumShiftGridLoader.class, "readGrid", record);
        }
        boolean notFound = cause instanceof NoSuchFileException || cause instanceof FileNotFoundException;
        String message = Resources.format(notFound ? (short)90 : 91, format, file);
        if (notFound) {
            return new MissingFactoryResourceException(message, cause);
        }
        return new FactoryDataException(message, cause);
    }
}

