/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.torque.om.BaseTorqueDynamicUserDelegatesPeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegates;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.MappingStrategy;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.UniqueColumnList;

public class BaseTorqueDynamicUserDelegatesRecordMapper
implements RecordMapper<TorqueDynamicUserDelegates> {
    private static final long serialVersionUID = 1735909173257L;
    private static Log log = LogFactory.getLog(BaseTorqueDynamicUserDelegatesRecordMapper.class);
    private static final String DELEGATOR_USER_ID_EXPRESSION = BaseTorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID.getSqlExpression();
    private static final String DELEGATEE_USER_ID_EXPRESSION = BaseTorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID.getSqlExpression();
    private boolean useMappingStrategy = true;
    private MappingStrategy<TorqueDynamicUserDelegates> strategy;

    public void initStrategy() {
        this.strategy = new MappingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorqueDynamicUserDelegates processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        TorqueDynamicUserDelegates torqueDynamicUserDelegates = new TorqueDynamicUserDelegates();
        try {
            torqueDynamicUserDelegates.setLoading(true);
            if (criteria == null) {
                torqueDynamicUserDelegates.setDelegatorUserId(this.getDelegatorUserId(resultSet, offset + 1));
                torqueDynamicUserDelegates.setDelegateeUserId(this.getDelegateeUserId(resultSet, offset + 2));
            } else {
                if (this.useMappingStrategy) {
                    this.initStrategy();
                }
                int totalOffset = offset + 1;
                UniqueColumnList selectColumns = criteria.getSelectColumns();
                List columnsWithoutOffset = selectColumns.subList(offset, selectColumns.size());
                HashSet<String> columnsMapped = new HashSet<String>();
                for (Column column : columnsWithoutOffset) {
                    int nextOffset = totalOffset;
                    if (!columnsMapped.contains(DELEGATOR_USER_ID_EXPRESSION) && DELEGATOR_USER_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setDelegatorUserId(this.getDelegatorUserId((ResultSet)res, nextOffset)));
                        } else {
                            torqueDynamicUserDelegates.setDelegatorUserId(this.getDelegatorUserId(resultSet, totalOffset));
                        }
                        columnsMapped.add(DELEGATOR_USER_ID_EXPRESSION);
                    } else if (!columnsMapped.contains(DELEGATEE_USER_ID_EXPRESSION) && DELEGATEE_USER_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setDelegateeUserId(this.getDelegateeUserId((ResultSet)res, nextOffset)));
                        } else {
                            torqueDynamicUserDelegates.setDelegateeUserId(this.getDelegateeUserId(resultSet, totalOffset));
                        }
                        columnsMapped.add(DELEGATEE_USER_ID_EXPRESSION);
                    }
                    ++totalOffset;
                }
                if (columnsMapped.isEmpty()) {
                    log.debug((Object)"no columns to map found in criteria, returning null");
                    Iterator iterator = null;
                    return iterator;
                }
                if (this.useMappingStrategy) {
                    this.strategy.finish(2, true);
                    this.strategy.execute(resultSet, (Object)torqueDynamicUserDelegates);
                }
            }
            torqueDynamicUserDelegates.setNew(false);
            torqueDynamicUserDelegates.setModified(false);
        }
        finally {
            torqueDynamicUserDelegates.setLoading(false);
        }
        return torqueDynamicUserDelegates;
    }

    protected Integer getDelegatorUserId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected Integer getDelegateeUserId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

