/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.query.ui;

import java.io.File;
import java.util.HashMap;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.core.RutaLanguageToolkit;
import org.apache.uima.ruta.query.ui.QueryResult;
import org.apache.uima.ruta.query.ui.QueryResultContentProvider;
import org.apache.uima.ruta.query.ui.QueryResultLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class QueryComposite
extends Composite
implements ISelectionChangedListener {
    protected ScriptSourceViewer viewer;
    private HashMap<String, Image> images;
    private Button dirButton;
    private Text inputDirectoryText;
    private Label label1;
    private Label labelTypeSystem;
    private Text typeSystemFileText;
    private Button fileChooseButton;
    private Button recursiveButton;
    private TableViewer resultViewer;
    private Label resultLabel;

    public QueryComposite(Composite parent, int style) {
        super(parent, style);
        this.initGUI();
        ScrolledComposite sComp = new ScrolledComposite(parent, 2816);
        this.setParent((Composite)sComp);
        sComp.setMinSize(this.getSize());
        sComp.setContent((Control)this);
        sComp.setExpandHorizontal(true);
        sComp.setExpandVertical(true);
    }

    private void initGUI() {
        try {
            this.setLayout((Layout)new FormLayout());
            this.setSize(600, 380);
            this.label1 = new Label((Composite)this, 0);
            FormData label1LData = new FormData();
            label1LData.left = new FormAttachment(0, 1000, 12);
            label1LData.top = new FormAttachment(0, 1000, 10);
            label1LData.width = 70;
            this.label1.setLayoutData((Object)label1LData);
            this.label1.setText("Query Data:");
            this.inputDirectoryText = new Text((Composite)this, 2052);
            FormData inputDirectoryTexLData = new FormData();
            inputDirectoryTexLData.width = 150;
            inputDirectoryTexLData.left = new FormAttachment(0, 1000, 90);
            inputDirectoryTexLData.top = new FormAttachment(0, 1000, 10);
            inputDirectoryTexLData.right = new FormAttachment(1000, 1000, -65);
            this.inputDirectoryText.setLayoutData((Object)inputDirectoryTexLData);
            this.inputDirectoryText.setText("");
            this.inputDirectoryText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text t = (Text)e.widget;
                    t.getText();
                }
            });
            this.dirButton = new Button((Composite)this, 0x1000008);
            FormData dirButtoLData = new FormData();
            dirButtoLData.width = 25;
            dirButtoLData.height = 25;
            dirButtoLData.top = new FormAttachment(0, 1000, 8);
            dirButtoLData.right = new FormAttachment(1000, 1000, -35);
            this.dirButton.setLayoutData((Object)dirButtoLData);
            Image folderIcon = this.getImage("folder");
            this.dirButton.setImage(folderIcon);
            this.dirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DirectoryDialog dlg = new DirectoryDialog(QueryComposite.this.getShell());
                    dlg.setFilterPath(QueryComposite.this.inputDirectoryText.getText());
                    dlg.setText("Input Directory");
                    dlg.setMessage("Select a directory with input XMI files.");
                    String dir = dlg.open();
                    if (dir != null) {
                        QueryComposite.this.inputDirectoryText.setText(dir);
                    }
                }
            });
            this.recursiveButton = new Button((Composite)this, 16416);
            FormData recuriveButtonLData = new FormData();
            recuriveButtonLData.width = 20;
            recuriveButtonLData.height = 18;
            recuriveButtonLData.top = new FormAttachment(0, 1000, 10);
            recuriveButtonLData.right = new FormAttachment(1000, 1000, -10);
            this.recursiveButton.setLayoutData((Object)recuriveButtonLData);
            this.recursiveButton.setSelection(true);
            this.labelTypeSystem = new Label((Composite)this, 0);
            FormData label3LData = new FormData();
            label3LData.width = 70;
            label3LData.left = new FormAttachment(0, 1000, 12);
            label3LData.top = new FormAttachment(0, 1000, 34);
            this.labelTypeSystem.setLayoutData((Object)label3LData);
            this.labelTypeSystem.setText("Type System:");
            this.typeSystemFileText = new Text((Composite)this, 2052);
            FormData preFileTexLData = new FormData();
            preFileTexLData.width = 150;
            preFileTexLData.left = new FormAttachment(0, 1000, 90);
            preFileTexLData.top = new FormAttachment(0, 1000, 34);
            preFileTexLData.right = new FormAttachment(1000, 1000, -65);
            this.typeSystemFileText.setLayoutData((Object)preFileTexLData);
            this.typeSystemFileText.setText("");
            this.typeSystemFileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text t = (Text)e.widget;
                    t.getText();
                }
            });
            this.fileChooseButton = new Button((Composite)this, 0x1000008);
            FormData fileChooseButtoLData = new FormData();
            fileChooseButtoLData.width = 25;
            fileChooseButtoLData.height = 25;
            fileChooseButtoLData.top = new FormAttachment(0, 1000, 32);
            fileChooseButtoLData.right = new FormAttachment(1000, 1000, -35);
            this.fileChooseButton.setLayoutData((Object)fileChooseButtoLData);
            Image icon = this.getImage("prepFolder");
            this.fileChooseButton.setImage(icon);
            this.fileChooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fd = new FileDialog(QueryComposite.this.getShell(), 4096);
                    fd.setText("Choose Type System Descriptor or Ruta Script");
                    String[] filterExt = new String[]{"*.ruta", "*.*"};
                    fd.setFilterExtensions(filterExt);
                    String file = fd.open();
                    if (file != null) {
                        QueryComposite.this.typeSystemFileText.setText(file);
                    }
                }
            });
            Composite composite1 = new Composite((Composite)this, 0x1000000);
            FormData compData = new FormData();
            compData.height = 100;
            compData.left = new FormAttachment(0, 1000, 10);
            compData.top = new FormAttachment(0, 1000, 75);
            compData.right = new FormAttachment(1000, 1000, -10);
            composite1.setLayoutData((Object)compData);
            composite1.setLayout((Layout)new FillLayout());
            IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((String)RutaLanguageToolkit.getDefault().getNatureId());
            ScriptTextTools textTools = toolkit.getTextTools();
            IPreferenceStore store = toolkit.getCombinedPreferenceStore();
            this.viewer = new ScriptSourceViewer(composite1, null, null, false, 2816, store);
            ScriptSourceViewerConfiguration configuration = textTools.createSourceViewerConfiguraton(store, (ITextEditor)null);
            this.viewer.configure((SourceViewerConfiguration)configuration);
            this.setInformation("");
            composite1.layout();
            this.resultLabel = new Label((Composite)this, 0);
            FormData resultLabelData = new FormData();
            resultLabelData.left = new FormAttachment(0, 1000, 12);
            resultLabelData.top = new FormAttachment(0, 1000, 180);
            resultLabelData.width = 300;
            this.resultLabel.setLayoutData((Object)resultLabelData);
            this.resultLabel.setText("Result:");
            Composite composite2 = new Composite((Composite)this, 0x1000000);
            FormData comp2Data = new FormData();
            comp2Data.left = new FormAttachment(0, 1000, 10);
            comp2Data.top = new FormAttachment(0, 1000, 195);
            comp2Data.right = new FormAttachment(1000, 1000, -10);
            comp2Data.bottom = new FormAttachment(1000, 1000, -10);
            composite2.setLayoutData((Object)comp2Data);
            composite2.setLayout((Layout)new FillLayout());
            this.resultViewer = new TableViewer(composite2, 2816);
            this.resultViewer.setLabelProvider((IBaseLabelProvider)new QueryResultLabelProvider());
            this.resultViewer.setContentProvider((IContentProvider)new QueryResultContentProvider());
            this.resultViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.resultViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection obj = event.getSelection();
                    if (obj instanceof IStructuredSelection) {
                        StructuredSelection selection = (StructuredSelection)obj;
                        for (Object element : selection) {
                            QueryResult data;
                            if (!(element instanceof QueryResult) || (data = (QueryResult)element).getFile() == null) continue;
                            QueryComposite.this.openInCasEditor(data.getFile(), data.getBegin(), data.getEnd());
                        }
                    }
                }
            });
            composite2.layout();
            this.layout();
        }
        catch (Exception e) {
            RutaAddonsPlugin.error(e);
        }
        DropTarget dt = new DropTarget((Control)this.inputDirectoryText, 18);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList.length > 0) {
                    QueryComposite.this.inputDirectoryText.setText(fileList[0]);
                }
            }
        });
        DropTarget dt2 = new DropTarget((Control)this.typeSystemFileText, 18);
        dt2.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt2.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList.length > 0) {
                    QueryComposite.this.typeSystemFileText.setText(fileList[0]);
                }
            }
        });
    }

    public void setResultInfo(int found, int files) {
        this.resultLabel.setText("Result: found " + found + " matches in " + files + " documents");
    }

    public void saveState(IMemento memento) {
        memento.createChild("inputDirectory", this.inputDirectoryText.getText());
        memento.createChild("typeSystemLocation", this.typeSystemFileText.getText());
        memento.createChild("query", this.viewer.getDocument().get());
        memento.createChild("recursive", Boolean.toString(this.recursiveButton.getSelection()));
    }

    public void restoreState(IMemento memento) {
        IMemento recursive;
        IMemento query;
        IMemento dir;
        if (memento == null) {
            return;
        }
        IMemento tsName = memento.getChild("typeSystemLocation");
        if (tsName != null) {
            this.typeSystemFileText.setText(tsName.getID());
        }
        if ((dir = memento.getChild("inputDirectory")) != null) {
            this.inputDirectoryText.setText(dir.getID());
        }
        if ((query = memento.getChild("query")) != null) {
            this.setInformation(query.getID());
        }
        if ((recursive = memento.getChild("recursive")) != null) {
            boolean isRecursive = recursive.getID().equals("true");
            this.recursiveButton.setSelection(isRecursive);
        }
    }

    protected void openInCasEditor(File file, int begin, int end) {
        if (file == null) {
            return;
        }
        String absolutePath = file.getAbsolutePath();
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IFile ifile = QueryComposite.getIFile(absolutePath);
            AnnotationEditor editor = (AnnotationEditor)page.openEditor((IEditorInput)new FileEditorInput(ifile), "org.apache.uima.caseditor.editor");
            editor.selectAndReveal(begin, end - begin);
        }
        catch (PartInitException e) {
            RutaAddonsPlugin.error(e);
        }
    }

    public static IFile getIFile(String location) {
        IPath s = Path.fromOSString((String)location);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile ifile = workspace.getRoot().getFileForLocation(s);
        return ifile;
    }

    public void setInformation(String content) {
        if (content == null) {
            this.viewer.setInput(null);
            return;
        }
        Document doc = new Document(content);
        IDLTKUILanguageToolkit uiToolkit = DLTKUILanguageManager.getLanguageToolkit((String)RutaLanguageToolkit.getDefault().getNatureId());
        ScriptTextTools textTools = uiToolkit.getTextTools();
        if (textTools != null) {
            textTools.setupDocumentPartitioner((IDocument)doc, uiToolkit.getPartitioningId());
        }
        this.viewer.setInput((Object)doc);
    }

    private void initImages() {
        this.images = new HashMap();
        ImageDescriptor desc = RutaAddonsPlugin.getImageDescriptor("/icons/folder_edit.png");
        Image image = desc.createImage();
        String name = "prepFolder";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/folder.png");
        image = desc.createImage();
        name = "folder";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/start.png");
        image = desc.createImage();
        name = "start";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/stop.gif");
        image = desc.createImage();
        name = "stop";
        this.images.put(name, image);
    }

    public Image getImage(String name) {
        if (this.images == null) {
            this.initImages();
        }
        return this.images.get(name);
    }

    public void dispose() {
        super.dispose();
        if (this.images != null) {
            for (Image each : this.images.values()) {
                each.dispose();
            }
        }
    }

    public String getDataDirectory() {
        return this.inputDirectoryText.getText().trim();
    }

    public String getTypeSystem() {
        return this.typeSystemFileText.getText().trim();
    }

    public String getScript() {
        return this.viewer.getDocument().get();
    }

    public boolean isRecursive() {
        return this.recursiveButton.getSelection();
    }

    public void setResult(Object object) {
        this.resultViewer.setInput(object);
        this.resultViewer.refresh();
    }

    public TableViewer getResultViewer() {
        return this.resultViewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider().equals(this.resultViewer)) {
            AnnotationEditor ae;
            IEditorInput editorInput;
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            QueryResult data = (QueryResult)selection.getFirstElement();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart activeEditor = page.getActiveEditor();
            if (activeEditor instanceof AnnotationEditor && (editorInput = (ae = (AnnotationEditor)activeEditor).getEditorInput()) instanceof FileEditorInput) {
                FileEditorInput fei = (FileEditorInput)editorInput;
                IFile file = fei.getFile();
                if (data != null && file.getLocationURI().equals(data.getFile().toURI())) {
                    int begin = data.getBegin();
                    int end = data.getEnd();
                    ae.selectAndReveal(begin, end - begin);
                }
            }
        }
    }

    public void setInputDirectory(String absolutePath) {
        this.inputDirectoryText.setText(absolutePath);
    }

    public void setTypeSystem(String typeSystemLocation) {
        this.typeSystemFileText.setText(typeSystemLocation);
    }
}

