/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.wien;

import java.util.ArrayList;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerMultiSlotRule;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.learner.wien.WienWordConstraint;

public class WienRuleItem
implements TextRulerRuleItem {
    WienWordConstraint wordConstraint;
    ArrayList<String> conditions = new ArrayList();
    ArrayList<String> actions = new ArrayList();

    public WienRuleItem(WienRuleItem copyFrom) {
        if (copyFrom.wordConstraint != null) {
            this.wordConstraint = copyFrom.wordConstraint.copy();
        }
    }

    public WienRuleItem(TextRulerAnnotation tokenAnnotation, boolean generalizeLinkMarkUp) {
        if (tokenAnnotation != null) {
            this.setWordConstraint(tokenAnnotation, generalizeLinkMarkUp);
        }
    }

    public WienRuleItem(TextRulerAnnotation tokenAnnotation) {
        if (tokenAnnotation != null) {
            this.setWordConstraint(tokenAnnotation);
        }
    }

    public WienRuleItem copy() {
        return new WienRuleItem(this);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(TextRulerRuleItem o) {
        return this.toString().equals(((WienRuleItem)o).toString());
    }

    public String toString() {
        return this.getStringForRuleString(null, null, 0, 0, 0, 0, 0);
    }

    public void addAction(String s) {
        this.actions.add(s);
    }

    public void addCondition(String s) {
        this.conditions.add(s);
    }

    public String getStringForRuleString(TextRulerRule rule, TextRulerRuleItem.MLRuleItemType type, int numberInPattern, int patternSize, int numberInRule, int ruleSize, int slotIndex) {
        ArrayList<String> theConditions = new ArrayList<String>();
        String anchor = null;
        if (this.wordConstraint != null) {
            if (this.wordConstraint.isRegExpConstraint()) {
                anchor = this.wordConstraint.typeShortName();
                theConditions.add("REGEXP(\"" + this.wordConstraint + "\")");
            } else {
                anchor = this.wordConstraint.toString();
            }
        } else {
            anchor = "ALL*?";
        }
        theConditions.addAll(this.conditions);
        String cStr = "";
        if (theConditions.size() > 0) {
            for (String c : theConditions) {
                if (cStr.length() > 0) {
                    cStr = cStr + ", ";
                }
                cStr = cStr + c;
            }
            cStr = "{" + cStr;
        }
        ArrayList<String> theActions = new ArrayList<String>();
        if (type == TextRulerRuleItem.MLRuleItemType.FILLER) {
            theActions.add("MARKONCE(" + ((TextRulerMultiSlotRule)rule).getMarkName(slotIndex) + ")");
        }
        theActions.addAll(this.actions);
        String aStr = "";
        if (theActions.size() > 0) {
            for (String a : theActions) {
                if (aStr.length() > 0) {
                    aStr = aStr + ", ";
                }
                aStr = aStr + a;
            }
            aStr = theConditions.size() == 0 ? "{->" + aStr + "}" : "->" + aStr + "}";
        } else if (theConditions.size() != 0) {
            aStr = "}";
        }
        return anchor + cStr + aStr;
    }

    public void setWordConstraint(TextRulerAnnotation tokenAnnotation, boolean generalizeLinkMarkUp) {
        WienWordConstraint c = new WienWordConstraint(tokenAnnotation);
        c.setGeneralizeLinkMarkUp(generalizeLinkMarkUp);
        this.setWordConstraint(c);
    }

    public void setWordConstraint(TextRulerAnnotation tokenAnnotation) {
        this.setWordConstraint(new WienWordConstraint(tokenAnnotation));
    }

    public void setWordConstraint(WienWordConstraint c) {
        this.wordConstraint = c;
    }

    public WienWordConstraint getWordConstraint() {
        return this.wordConstraint;
    }
}

