/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.IMatcher;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;

public class RefFilterHelper {
    private static final String ANY = "**";
    private static final String REF_SEPARATOR = ":";
    private static final String MACRO_CURRENT_BRANCH = "${git_branch}";
    private static final String DEFAULT_SELECTED_REFS = "HEAD";
    private static final String DEFAULT_SELECTED_REFS_ALL_BRANCHES = "HEAD:refs/heads/**:refs/remotes/**:refs/tags/**";
    private final IPreferenceStore store;
    @NonNull
    private final Repository repository;
    private List<RefFilter> preconfiguredFilters;
    private List<RefFilter> filtersForHEAD;
    private List<RefFilter> filtersForCurrentBranch;
    private List<RefFilter> filtersForAllBranchesAndTags;
    private Map<String, Function<Repository, String>> macros;

    @NonNull
    private static IPreferenceStore checkNull(IPreferenceStore store) {
        if (store == null) {
            throw new NullPointerException("Preference store is null.");
        }
        return store;
    }

    public RefFilterHelper(@NonNull Repository repository) {
        this(repository, RefFilterHelper.checkNull(Activator.getDefault().getPreferenceStore()));
    }

    public RefFilterHelper(@NonNull Repository repository, @NonNull IPreferenceStore store) {
        this.repository = repository;
        this.store = store;
        this.setupPreconfiguredFilters();
        this.setupMacros();
        this.initDefaultsForRepo();
    }

    private RefFilter newPreConfFilter(String filter) {
        return new RefFilter(filter, true);
    }

    private RefFilter newPreConfPrefixFilter(String prefix) {
        return this.newPreConfFilter(String.valueOf(prefix) + ANY);
    }

    private void setupPreconfiguredFilters() {
        this.preconfiguredFilters = new ArrayList<RefFilter>();
        this.filtersForHEAD = new ArrayList<RefFilter>();
        this.filtersForCurrentBranch = new ArrayList<RefFilter>();
        this.filtersForAllBranchesAndTags = new ArrayList<RefFilter>();
        RefFilter head = this.newPreConfFilter(DEFAULT_SELECTED_REFS);
        this.preconfiguredFilters.add(head);
        this.filtersForHEAD.add(head);
        this.filtersForAllBranchesAndTags.add(head);
        RefFilter currentBranch = this.newPreConfFilter("refs/**/${git_branch}");
        this.preconfiguredFilters.add(currentBranch);
        this.filtersForCurrentBranch.add(currentBranch);
        RefFilter branches = this.newPreConfPrefixFilter("refs/heads/");
        this.preconfiguredFilters.add(branches);
        this.filtersForAllBranchesAndTags.add(branches);
        RefFilter remoteBranches = this.newPreConfPrefixFilter("refs/remotes/");
        this.preconfiguredFilters.add(remoteBranches);
        this.filtersForAllBranchesAndTags.add(remoteBranches);
        RefFilter tags = this.newPreConfPrefixFilter("refs/tags/");
        this.preconfiguredFilters.add(tags);
        this.filtersForAllBranchesAndTags.add(tags);
    }

    private void setupMacros() {
        this.macros = new LinkedHashMap<String, Function<Repository, String>>();
        this.macros.put(MACRO_CURRENT_BRANCH, repo -> {
            try {
                return repo.getBranch();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, false);
                return "";
            }
        });
    }

    private void setDefaultSelectionBasedOnShowAllBranches() {
        String currentDefault = this.store.getDefaultString("resourcehistory_selected_ref_filters");
        if (!DEFAULT_SELECTED_REFS.equals(currentDefault) && !DEFAULT_SELECTED_REFS_ALL_BRANCHES.equals(currentDefault)) {
            return;
        }
        boolean showAll = this.store.getBoolean("resourcehistory_show_all_branches");
        if (showAll) {
            this.store.setDefault("resourcehistory_selected_ref_filters", DEFAULT_SELECTED_REFS_ALL_BRANCHES);
        } else {
            this.store.setDefault("resourcehistory_selected_ref_filters", DEFAULT_SELECTED_REFS);
        }
    }

    private void initDefaultForRepo(String preferenceName) {
        String repoSpecificPrefName = RepositoryUtil.getInstance().getRepositorySpecificPreferenceKey(this.repository, preferenceName);
        this.store.setDefault(repoSpecificPrefName, this.store.getDefaultString(preferenceName));
    }

    private void initDefaultsForRepo() {
        this.setDefaultSelectionBasedOnShowAllBranches();
        this.initDefaultForRepo("resourcehistory_ref_filters");
        this.initDefaultForRepo("resourcehistory_selected_ref_filters");
        this.initDefaultForRepo("resourcehistory_last_selected_ref_filters");
    }

    protected String getPreferenceString(String preferenceName) {
        String repoSpecificPrefName = RepositoryUtil.getInstance().getRepositorySpecificPreferenceKey(this.repository, preferenceName);
        return this.store.getString(repoSpecificPrefName);
    }

    private List<String> getFiltersFromPref(String preferenceName) {
        String refFiltersString = this.getPreferenceString(preferenceName);
        String[] filters = refFiltersString.split(REF_SEPARATOR);
        return Arrays.asList(filters);
    }

    private void savePreferencStoreIfNeeded() {
        if (this.store.needsSaving() && this.store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.store).save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, false);
            }
        }
    }

    private void setFiltersInPref(String preferenceName, List<String> filters, boolean save) {
        String repoSpecificPrefName = RepositoryUtil.getInstance().getRepositorySpecificPreferenceKey(this.repository, preferenceName);
        String refFiltersString = String.join((CharSequence)REF_SEPARATOR, filters);
        this.store.setValue(repoSpecificPrefName, refFiltersString);
        if (save) {
            this.savePreferencStoreIfNeeded();
        }
    }

    public List<String> getConfiguredFilters() {
        return this.getFiltersFromPref("resourcehistory_ref_filters");
    }

    public void setConfiguredFilters(List<String> filters, boolean save) {
        this.setFiltersInPref("resourcehistory_ref_filters", filters, save);
    }

    public List<String> getSelectedFilters() {
        return this.getFiltersFromPref("resourcehistory_selected_ref_filters");
    }

    public void setSelectedFilters(List<String> filters, boolean save) {
        this.setFiltersInPref("resourcehistory_selected_ref_filters", filters, save);
    }

    public List<String> getLastSelectedFilters() {
        return this.getFiltersFromPref("resourcehistory_last_selected_ref_filters");
    }

    public void setLastSelectedFilters(List<String> filters, boolean save) {
        this.setFiltersInPref("resourcehistory_last_selected_ref_filters", filters, save);
    }

    private void addPreconfiguredFilters(Map<String, RefFilter> filters) {
        for (RefFilter filter : this.preconfiguredFilters) {
            filters.put(filter.getFilterString(), new RefFilter(filter));
        }
    }

    public Set<RefFilter> getRefFilters() {
        LinkedHashMap<String, RefFilter> filters = new LinkedHashMap<String, RefFilter>();
        this.addPreconfiguredFilters(filters);
        for (String filter : this.getConfiguredFilters()) {
            if (filter == null || filter.isEmpty()) continue;
            filters.put(filter, new RefFilter(filter, false));
        }
        for (String filter : this.getSelectedFilters()) {
            if (filter == null || filter.isEmpty()) continue;
            filters.putIfAbsent(filter, new RefFilter(filter, false));
            ((RefFilter)filters.get(filter)).setSelected(true);
        }
        return new LinkedHashSet<RefFilter>(filters.values());
    }

    public void restoreLastSelectionState(Set<RefFilter> filters) {
        for (RefFilter filter : filters) {
            filter.setSelected(this.getLastSelectedFilters().contains(filter.getFilterString()));
        }
    }

    public void setRefFilters(Set<RefFilter> filters) {
        List<String> selected = filters.stream().filter(RefFilter::isSelected).map(RefFilter::getFilterString).collect(Collectors.toList());
        this.setSelectedFilters(selected, false);
        List<String> configured = filters.stream().filter(f -> !f.isPreconfigured()).map(RefFilter::getFilterString).collect(Collectors.toList());
        this.setConfiguredFilters(configured, false);
        this.savePreferencStoreIfNeeded();
    }

    public void saveSelectionStateAsLastSelectionState(Set<RefFilter> filters) {
        ArrayList<String> selected = new ArrayList<String>();
        for (RefFilter filter : filters) {
            if (!filter.isSelected()) continue;
            selected.add(filter.getFilterString());
        }
        this.setLastSelectedFilters(selected, true);
    }

    public void resetLastSelectionStateToDefault() {
        String repoSpecificPrefName = RepositoryUtil.getInstance().getRepositorySpecificPreferenceKey(this.repository, "resourcehistory_last_selected_ref_filters");
        this.store.setToDefault(repoSpecificPrefName);
        this.savePreferencStoreIfNeeded();
    }

    public Set<Ref> getMatchingRefsForSelectedRefFilters() throws IOException {
        RefDatabase db = this.repository.getRefDatabase();
        LinkedHashSet<Ref> result = new LinkedHashSet<Ref>();
        Set selectedFilters = this.getRefFilters().stream().filter(RefFilter::isSelected).collect(Collectors.toCollection(LinkedHashSet::new));
        block0: for (Ref ref : db.getRefs()) {
            String refPath = ref.getName();
            for (RefFilter filter : selectedFilters) {
                if (!filter.matches(refPath)) continue;
                result.add(ref);
                continue block0;
            }
        }
        return result;
    }

    public void selectOnlyHEAD(Set<RefFilter> filters) {
        for (RefFilter filter : filters) {
            filter.setSelected(this.filtersForHEAD.contains(filter));
        }
    }

    public boolean isOnlyHEADSelected(Set<RefFilter> filters) {
        for (RefFilter filter : filters) {
            if (!(filter.isSelected() ? !this.filtersForHEAD.contains(filter) : this.filtersForHEAD.contains(filter))) continue;
            return false;
        }
        return true;
    }

    public void selectOnlyCurrentBranch(Set<RefFilter> filters) {
        for (RefFilter filter : filters) {
            filter.setSelected(this.filtersForCurrentBranch.contains(filter));
        }
    }

    public boolean isOnlyCurrentBranchSelected(Set<RefFilter> filters) {
        for (RefFilter filter : filters) {
            if (!(filter.isSelected() ? !this.filtersForCurrentBranch.contains(filter) : this.filtersForCurrentBranch.contains(filter))) continue;
            return false;
        }
        return true;
    }

    public void selectExactlyAllBranchesAndTags(Set<RefFilter> filters) {
        for (RefFilter filter : filters) {
            filter.setSelected(this.filtersForAllBranchesAndTags.contains(filter));
        }
    }

    public boolean isExactlyAllBranchesAndTagsSelected(Set<RefFilter> filters) {
        for (RefFilter filter : filters) {
            if (!(filter.isSelected() ? !this.filtersForAllBranchesAndTags.contains(filter) : this.filtersForAllBranchesAndTags.contains(filter))) continue;
            return false;
        }
        return true;
    }

    public Set<RefFilter> getDefaults() {
        this.setDefaultSelectionBasedOnShowAllBranches();
        RefFilterHelper defaultsHelper = new RefFilterHelper(this.repository){

            @Override
            protected String getPreferenceString(String preferenceName) {
                return RefFilterHelper.this.store.getDefaultString(preferenceName);
            }
        };
        return defaultsHelper.getRefFilters();
    }

    public class RefFilter {
        private final boolean preconfigured;
        @NonNull
        private String filterString;
        private IMatcher filterPattern;
        private IMatcher expandedFilterPattern;
        private boolean selected;

        public RefFilter(RefFilter original) {
            this(original.getFilterString(), original.isPreconfigured());
            this.selected = original.isSelected();
        }

        public RefFilter(String filterString) {
            this(filterString, false);
        }

        private RefFilter(String filterString, boolean isPreconfigured) {
            if (filterString == null || filterString.isEmpty()) {
                throw new IllegalArgumentException("Filter string is null or empty.");
            }
            this.filterString = filterString;
            this.filterPattern = this.createPattern(filterString);
            this.preconfigured = isPreconfigured;
        }

        public boolean isPreconfigured() {
            return this.preconfigured;
        }

        private IMatcher patternWithExpandedMacros() {
            if (this.expandedFilterPattern == null) {
                IMatcher expanded = this.expandMacros();
                this.expandedFilterPattern = expanded != null ? expanded : this.filterPattern;
            }
            return this.expandedFilterPattern;
        }

        @Nullable
        private IMatcher expandMacros() {
            String currentPattern = this.filterString;
            for (Map.Entry macro : RefFilterHelper.this.macros.entrySet()) {
                String newString;
                String macroString = (String)macro.getKey();
                if (!currentPattern.contains(macroString)) continue;
                String replacingString = (String)((Function)macro.getValue()).apply(RefFilterHelper.this.repository);
                currentPattern = newString = currentPattern.replace(macroString, replacingString);
            }
            return this.createPattern(currentPattern);
        }

        @Nullable
        private IMatcher createPattern(@Nullable String pattern) {
            if (pattern == null) {
                return null;
            }
            try {
                return IMatcher.createPathMatcher((String)pattern, (boolean)false);
            }
            catch (InvalidPatternException e) {
                return null;
            }
        }

        public boolean matches(String refPath) {
            IMatcher matcher = this.patternWithExpandedMacros();
            if (matcher == null) {
                return false;
            }
            return matcher.matches(refPath, false, true);
        }

        public String getFilterString() {
            return this.filterString;
        }

        public void setFilterString(String filterString) {
            if (filterString == null || filterString.isEmpty()) {
                throw new IllegalArgumentException("Filter string is null or empty.");
            }
            if (this.preconfigured) {
                throw new IllegalStateException("Cannot change a preconfigured filter.");
            }
            this.filterString = filterString;
            this.filterPattern = this.createPattern(filterString);
            this.expandedFilterPattern = null;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public int hashCode() {
            return this.filterString.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RefFilter)) {
                return false;
            }
            return this.filterString.equals(((RefFilter)obj).filterString);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RefFilter [");
            if (this.filterPattern != null) {
                builder.append("pattern=");
                builder.append(this.filterPattern);
                builder.append(", ");
                if (this.expandedFilterPattern != null && !this.expandedFilterPattern.equals(this.filterPattern)) {
                    builder.append("expandedPattern=");
                    builder.append(this.expandedFilterPattern);
                    builder.append(", ");
                }
            }
            builder.append("preconfigured=");
            builder.append(this.preconfigured);
            builder.append(", selected=");
            builder.append(this.selected);
            builder.append("]");
            return builder.toString();
        }
    }
}

