/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.insert;

import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.gef.commands.Command;

public class InsertAlgorithmCommand
extends Command {
    private final BasicFBType fbType;
    private STAlgorithm newAlgorithm;
    private Algorithm oldAlgorithm;
    private int index;

    public InsertAlgorithmCommand(BasicFBType fbType, Algorithm oldAlgorithm, int index) {
        this.fbType = fbType;
        this.oldAlgorithm = oldAlgorithm;
        this.index = index;
    }

    public void execute() {
        this.newAlgorithm = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
        this.newAlgorithm.setName(this.oldAlgorithm.getName());
        this.newAlgorithm.setComment(this.oldAlgorithm.getComment());
        this.newAlgorithm.setText(((STAlgorithm)this.oldAlgorithm).getText());
        this.redo();
        this.newAlgorithm.setName(NameRepository.createUniqueName((INamedElement)this.newAlgorithm, (String)this.oldAlgorithm.getName()));
    }

    public void undo() {
        this.fbType.getAlgorithm().remove((Object)this.newAlgorithm);
    }

    public void redo() {
        this.fbType.getAlgorithm().add(this.index, (Object)this.newAlgorithm);
    }
}

