/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.structuredtext.structuredText;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BinaryOperator implements Enumerator
{
    OR(0, "OR", "OR"),
    XOR(1, "XOR", "XOR"),
    AND(2, "AND", "AND"),
    AMPERSAND(3, "AMPERSAND", "&"),
    EQ(4, "EQ", "="),
    NE(5, "NE", "<>"),
    LT(6, "LT", "<"),
    LE(7, "LE", "<="),
    GT(8, "GT", ">"),
    GE(9, "GE", ">="),
    ADD(10, "ADD", "+"),
    SUB(11, "SUB", "-"),
    MUL(12, "MUL", "*"),
    DIV(13, "DIV", "/"),
    MOD(14, "MOD", "MOD"),
    POWER(15, "POWER", "**");

    public static final int OR_VALUE = 0;
    public static final int XOR_VALUE = 1;
    public static final int AND_VALUE = 2;
    public static final int AMPERSAND_VALUE = 3;
    public static final int EQ_VALUE = 4;
    public static final int NE_VALUE = 5;
    public static final int LT_VALUE = 6;
    public static final int LE_VALUE = 7;
    public static final int GT_VALUE = 8;
    public static final int GE_VALUE = 9;
    public static final int ADD_VALUE = 10;
    public static final int SUB_VALUE = 11;
    public static final int MUL_VALUE = 12;
    public static final int DIV_VALUE = 13;
    public static final int MOD_VALUE = 14;
    public static final int POWER_VALUE = 15;
    private static final BinaryOperator[] VALUES_ARRAY;
    public static final List<BinaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BinaryOperator[]{OR, XOR, AND, AMPERSAND, EQ, NE, LT, LE, GT, GE, ADD, SUB, MUL, DIV, MOD, POWER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BinaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator get(int value) {
        switch (value) {
            case 0: {
                return OR;
            }
            case 1: {
                return XOR;
            }
            case 2: {
                return AND;
            }
            case 3: {
                return AMPERSAND;
            }
            case 4: {
                return EQ;
            }
            case 5: {
                return NE;
            }
            case 6: {
                return LT;
            }
            case 7: {
                return LE;
            }
            case 8: {
                return GT;
            }
            case 9: {
                return GE;
            }
            case 10: {
                return ADD;
            }
            case 11: {
                return SUB;
            }
            case 12: {
                return MUL;
            }
            case 13: {
                return DIV;
            }
            case 14: {
                return MOD;
            }
            case 15: {
                return POWER;
            }
        }
        return null;
    }

    private BinaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

