/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.structuredtext.validation;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class DatetimeLiteral {
    private String data;
    private Type type = Type.INVALID;
    private boolean isNegative = false;
    private Long year = null;
    private Long month = null;
    private Long day = null;
    private Long hour = null;
    private Long minute = null;
    private Long second = null;
    private Long millisecond = null;
    private Long microsecond = null;
    private Long nanosecond = null;
    static final long KILO = 1000L;
    static final long NS_PER_US = 1000L;
    static final long US_PER_MS = 1000L;
    static final long MS_PER_S = 1000L;
    static final long S_PER_M = 60L;
    static final long M_PER_H = 60L;
    static final long H_PER_D = 24L;
    static final long MAX_KILO = 999L;
    static final long MAX_S = 59L;
    static final long MAX_M = 59L;
    static final long MAX_H = 23L;
    static final String UNDERSCORE = "_";
    static final String EMPTY = "";
    static final long BASE_TEN = 10L;
    static final long MAX_COUNT_DIGITS_NS = 9L;
    static final long MAX_COUNT_DIGITS = 19L;
    static final long MAX_INPUT_LENGTH = 200L;
    static final String LITERAL_SEPERATOR = "#";
    static final String MINUS = "-";
    static final String UNIT_D = "d";
    static final String UNIT_H = "h";
    static final String UNIT_M = "m";
    static final String UNIT_S = "s";
    static final String UNIT_MS = "ms";
    static final String UNIT_US = "us";
    static final String UNIT_NS = "ns";
    static final String DATE_SEPERATOR = "-";
    static final String TIMEOFDAY_SEPERATOR = ":";
    static final String TIMEOFDAY_SEPERATOR_DECIMALS = ".";
    static final String TWO_DIGIT_NUMBER = "%02d";
    static final String DIGIT_SEPERATOR = "(_)?";
    static final String UNSIGNED_INT_REGEX = "[0-9]((_)?[0-9])*";
    static final String DECIMAL_REGEX = "\\.[0-9]((_)?[0-9])*";
    static final String FIXPOINT_REGEX = "[0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?";
    static final String UNIT_REGEX = "(ns|us|ms|s|m|h|d)";
    static final String FIXPOINT_WITH_UNIT_REGEX = "[0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?(ns|us|ms|s|m|h|d)";
    static final String NANOSECONDS_REGEX = "([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)";
    static final String MICROSECONDS_REGEX = "(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))";
    static final String MILLISECONDS_REGEX = "(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))";
    static final String SECONDS_REGEX = "(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))";
    static final String MINUTES_REGEX = "(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))))";
    static final String HOURS_REGEX = "(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?h)|([0-9]((_)?[0-9])*h(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))))";
    static final String DAYS_REGEX = "(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?d)|([0-9]((_)?[0-9])*d(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?h)|([0-9]((_)?[0-9])*h(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))))))";
    static final String INTERVAL_REGEX = "(((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?d)|([0-9]((_)?[0-9])*d(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?h)|([0-9]((_)?[0-9])*h(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?h)|([0-9]((_)?[0-9])*h(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))|(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))";
    static final String DURATION_VALUE_REGEX = "([\\+-])?(((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?d)|([0-9]((_)?[0-9])*d(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?h)|([0-9]((_)?[0-9])*h(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?h)|([0-9]((_)?[0-9])*h(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))|(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))";
    static final String DATE_VALUE_REGEX = "[0-9]((_)?[0-9])*-[0-9]((_)?[0-9])*-[0-9]((_)?[0-9])*";
    static final String TIMEOFDAY_VALUE_REGEX = "[0-9]((_)?[0-9])*:[0-9]((_)?[0-9])*:[0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?";
    static final String DATETIME_VALUE_REGEX = "[0-9]((_)?[0-9])*-[0-9]((_)?[0-9])*-[0-9]((_)?[0-9])*-[0-9]((_)?[0-9])*:[0-9]((_)?[0-9])*:[0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?";
    static final String BEGINNING_OF_STRING = "^";
    static final String END_OF_STRING = "$";
    static final Pattern durationValuePattern = Pattern.compile("^([\\+-])?(((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?d)|([0-9]((_)?[0-9])*d(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?h)|([0-9]((_)?[0-9])*h(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?h)|([0-9]((_)?[0-9])*h(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?m)|([0-9]((_)?[0-9])*m(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?s)|([0-9]((_)?[0-9])*s(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ms)|([0-9]((_)?[0-9])*ms(_)?)?(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns))))|((([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?us)|([0-9]((_)?[0-9])*us(_)?)?([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))|(([0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?ns)))$");
    static final Pattern dateValuePattern = Pattern.compile("^[0-9]((_)?[0-9])*-[0-9]((_)?[0-9])*-[0-9]((_)?[0-9])*$");
    static final Pattern timeofdayValuePattern = Pattern.compile("^[0-9]((_)?[0-9])*:[0-9]((_)?[0-9])*:[0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?$");
    static final Pattern datetimeValuePattern = Pattern.compile("^[0-9]((_)?[0-9])*-[0-9]((_)?[0-9])*-[0-9]((_)?[0-9])*-[0-9]((_)?[0-9])*:[0-9]((_)?[0-9])*:[0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?$");
    static final Pattern fixpointWithUnitPattern = Pattern.compile("[0-9]((_)?[0-9])*(\\.[0-9]((_)?[0-9])*)?(ns|us|ms|s|m|h|d)");
    static final Pattern unsignedIntPattern = Pattern.compile("[0-9]((_)?[0-9])*");
    static final Pattern decimalPattern = Pattern.compile("\\.[0-9]((_)?[0-9])*");
    static final Pattern unitPattern = Pattern.compile("(ns|us|ms|s|m|h|d)");

    public DatetimeLiteral(String string) {
        String literal = string;
        if ((long)string.length() > 200L) {
            this.type = Type.INVALID;
            return;
        }
        this.determineType(literal);
        String[] dataSplit = literal.toLowerCase().split(LITERAL_SEPERATOR);
        if (dataSplit.length != 2) {
            this.type = Type.INVALID;
            return;
        }
        this.data = dataSplit[1];
        switch (this.type) {
            case TOD: 
            case LTOD: {
                this.parseTOD();
                break;
            }
            case DT: 
            case LDT: {
                this.parseDT();
                break;
            }
            case T: 
            case LT: {
                this.parseT();
                break;
            }
            case D: 
            case LD: {
                this.parseD();
                break;
            }
        }
    }

    private void determineType(String literal) {
        String uppercase = literal.toUpperCase();
        if (DatetimeLiteral.detectType(uppercase, "TOD", "TIME_OF_DAY")) {
            this.type = Type.TOD;
        } else if (DatetimeLiteral.detectType(uppercase, "LTOD", "LTIME_OF_DAY")) {
            this.type = Type.LTOD;
        } else if (DatetimeLiteral.detectType(uppercase, "DT", "DATE_AND_TIME")) {
            this.type = Type.DT;
        } else if (DatetimeLiteral.detectType(uppercase, "LDT", "LDATE_AND_TIME")) {
            this.type = Type.LDT;
        } else if (DatetimeLiteral.detectType(uppercase, "T", "TIME")) {
            this.type = Type.T;
        } else if (DatetimeLiteral.detectType(uppercase, "LT", "LTIME")) {
            this.type = Type.LT;
        } else if (DatetimeLiteral.detectType(uppercase, "D", "DATE")) {
            this.type = Type.D;
        } else if (DatetimeLiteral.detectType(uppercase, "LD", "LDATE")) {
            this.type = Type.LD;
        }
    }

    private static boolean detectType(String input, String shortName, String longName) {
        return input.startsWith(String.valueOf(shortName) + LITERAL_SEPERATOR) || input.startsWith(String.valueOf(longName) + LITERAL_SEPERATOR);
    }

    public boolean isValid() {
        return this.type != Type.INVALID;
    }

    private void parseTOD() {
        if (!timeofdayValuePattern.matcher(this.data).matches()) {
            this.type = Type.INVALID;
            return;
        }
        String[] matches = (String[])unsignedIntPattern.matcher(this.data).results().map(MatchResult::group).toArray(String[]::new);
        if (matches.length != 3 && matches.length != 4) {
            this.type = Type.INVALID;
            return;
        }
        this.hour = Long.valueOf(matches[0].replace(UNDERSCORE, EMPTY));
        this.minute = Long.valueOf(matches[1].replace(UNDERSCORE, EMPTY));
        this.second = Long.valueOf(matches[2].replace(UNDERSCORE, EMPTY));
        if (matches.length == 4) {
            String decimals = matches[3].replace(UNDERSCORE, EMPTY);
            int places = decimals.length();
            if ((long)places > 9L) {
                this.type = Type.INVALID;
                return;
            }
            int divider = (int)Math.pow(10.0, places);
            this.nanosecond = Long.parseLong(decimals) * 1000L * 1000L * 1000L / (long)divider;
        }
        this.validateTOD();
    }

    private void validateTOD() {
        if (this.hour < 0L || this.hour > 23L) {
            this.type = Type.INVALID;
            return;
        }
        if (this.minute < 0L || this.minute > 59L) {
            this.type = Type.INVALID;
            return;
        }
        if (this.second < 0L || this.second > 59L) {
            this.type = Type.INVALID;
        }
    }

    private void parseDT() {
        if (!datetimeValuePattern.matcher(this.data).matches()) {
            this.type = Type.INVALID;
            return;
        }
        String[] matches = (String[])unsignedIntPattern.matcher(this.data).results().map(MatchResult::group).toArray(String[]::new);
        if (matches.length != 6 && matches.length != 7) {
            this.type = Type.INVALID;
            return;
        }
        this.year = Long.valueOf(matches[0].replace(UNDERSCORE, EMPTY));
        this.month = Long.valueOf(matches[1].replace(UNDERSCORE, EMPTY));
        this.day = Long.valueOf(matches[2].replace(UNDERSCORE, EMPTY));
        this.validateD();
        if (this.type == Type.INVALID) {
            return;
        }
        this.hour = Long.valueOf(matches[3].replace(UNDERSCORE, EMPTY));
        this.minute = Long.valueOf(matches[4].replace(UNDERSCORE, EMPTY));
        this.second = Long.valueOf(matches[5].replace(UNDERSCORE, EMPTY));
        if (matches.length == 7) {
            String decimals = matches[6].replace(UNDERSCORE, EMPTY);
            int places = decimals.length();
            if ((long)places > 9L) {
                this.type = Type.INVALID;
                return;
            }
            int divider = (int)Math.pow(10.0, places);
            this.nanosecond = Long.parseLong(decimals) * 1000L * 1000L * 1000L / (long)divider;
        }
        this.validateTOD();
    }

    private void parseT() {
        String[] matches;
        if (!durationValuePattern.matcher(this.data).matches()) {
            this.type = Type.INVALID;
            return;
        }
        if (this.data.startsWith("-")) {
            this.isNegative = true;
        }
        String[] stringArray = matches = (String[])fixpointWithUnitPattern.matcher(this.data).results().map(MatchResult::group).toArray(String[]::new);
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            String match = stringArray[n2];
            String[] value = (String[])unsignedIntPattern.matcher(match).results().map(MatchResult::group).toArray(String[]::new);
            String[] decimal = (String[])decimalPattern.matcher(match).results().map(MatchResult::group).toArray(String[]::new);
            String[] unit = (String[])unitPattern.matcher(match).results().map(MatchResult::group).toArray(String[]::new);
            if (decimal.length > 1) {
                this.type = Type.INVALID;
                return;
            }
            long intValue = Long.parseLong(value[0].replace(UNDERSCORE, EMPTY));
            String decimals = decimal.length == 1 ? decimal[0].substring(1).replace(UNDERSCORE, EMPTY) : "0";
            long intDecimal = Long.parseLong(decimals);
            int places = decimals.length();
            if ((long)places > 19L) {
                this.type = Type.INVALID;
                return;
            }
            long divider = (int)Math.pow(10.0, places);
            switch (unit[0]) {
                case "d": {
                    this.day = intValue;
                    this.fillFromNs(intDecimal * 24L * 60L * 60L * 1000L * 1000L * 1000L / divider);
                    break;
                }
                case "h": {
                    if (this.hour != null) {
                        this.type = Type.INVALID;
                        return;
                    }
                    this.hour = intValue;
                    this.fillFromNs(intDecimal * 60L * 60L * 1000L * 1000L * 1000L / divider);
                    break;
                }
                case "m": {
                    if (this.minute != null) {
                        this.type = Type.INVALID;
                        return;
                    }
                    this.minute = intValue;
                    this.fillFromNs(intDecimal * 60L * 1000L * 1000L * 1000L / divider);
                    break;
                }
                case "s": {
                    if (this.second != null) {
                        this.type = Type.INVALID;
                        return;
                    }
                    this.second = intValue;
                    this.fillFromNs(intDecimal * 1000L * 1000L * 1000L / divider);
                    break;
                }
                case "ms": {
                    if (this.millisecond != null) {
                        this.type = Type.INVALID;
                        return;
                    }
                    this.millisecond = intValue;
                    this.fillFromNs(intDecimal * 1000L * 1000L / divider);
                    break;
                }
                case "us": {
                    if (this.microsecond != null) {
                        this.type = Type.INVALID;
                        return;
                    }
                    this.microsecond = intValue;
                    this.fillFromNs(intDecimal * 1000L / divider);
                    break;
                }
                case "ns": {
                    this.nanosecond = intValue;
                    if (intDecimal == 0L) break;
                    this.type = Type.INVALID;
                    return;
                }
                default: {
                    this.type = Type.INVALID;
                }
            }
            ++n2;
        }
        if (DatetimeLiteral.verifyValueLimit(this.nanosecond, 999L, this.microsecond, this.millisecond, this.second, this.minute, this.hour, this.day) || DatetimeLiteral.verifyValueLimit(this.microsecond, 999L, this.millisecond, this.second, this.minute, this.hour, this.day) || DatetimeLiteral.verifyValueLimit(this.millisecond, 999L, this.second, this.minute, this.hour, this.day) || DatetimeLiteral.verifyValueLimit(this.second, 59L, this.minute, this.hour, this.day) || DatetimeLiteral.verifyValueLimit(this.minute, 59L, this.hour, this.day) || DatetimeLiteral.verifyValueLimit(this.hour, 23L, this.day)) {
            this.type = Type.INVALID;
        }
    }

    private static boolean verifyValueLimit(Long element, long limit, Long ... biggerElements) {
        return element != null && Arrays.stream(biggerElements).anyMatch(Objects::nonNull) && element > limit;
    }

    private void fillFromNs(long nanoseconds) {
        long nanosecondTemp = nanoseconds;
        long temp = nanosecondTemp / 3600000000000L;
        if (temp != 0L) {
            if (this.hour != null) {
                this.type = Type.INVALID;
                return;
            }
            this.hour = temp;
        }
        if ((temp = (nanosecondTemp %= 3600000000000L) / 60000000000L) != 0L) {
            if (this.minute != null) {
                this.type = Type.INVALID;
                return;
            }
            this.minute = temp;
        }
        if ((temp = (nanosecondTemp %= 60000000000L) / 1000000000L) != 0L) {
            if (this.second != null) {
                this.type = Type.INVALID;
                return;
            }
            this.second = temp;
        }
        if ((temp = (nanosecondTemp %= 1000000000L) / 1000000L) != 0L) {
            if (this.millisecond != null) {
                this.type = Type.INVALID;
                return;
            }
            this.millisecond = temp;
        }
        if ((temp = (nanosecondTemp %= 1000000L) / 1000L) != 0L) {
            if (this.microsecond != null) {
                this.type = Type.INVALID;
                return;
            }
            this.microsecond = temp;
        }
        if ((temp = nanosecondTemp % 1000L) != 0L) {
            if (this.nanosecond != null) {
                this.type = Type.INVALID;
                return;
            }
            this.nanosecond = temp;
        }
    }

    private String toInterval() {
        StringBuilder s = new StringBuilder();
        if (this.isNegative) {
            s.append("-");
        }
        if (DatetimeLiteral.hasValueFor(this.day)) {
            s.append(this.day);
            s.append(UNIT_D);
        }
        if (DatetimeLiteral.hasValueFor(this.hour)) {
            s.append(this.hour);
            s.append(UNIT_H);
        }
        if (DatetimeLiteral.hasValueFor(this.minute)) {
            s.append(this.minute);
            s.append(UNIT_M);
        }
        if (DatetimeLiteral.hasValueFor(this.second)) {
            s.append(this.second);
            s.append(UNIT_S);
        }
        if (DatetimeLiteral.hasValueFor(this.millisecond)) {
            s.append(this.millisecond);
            s.append(UNIT_MS);
        }
        if (DatetimeLiteral.hasValueFor(this.microsecond)) {
            s.append(this.microsecond);
            s.append(UNIT_US);
        }
        if (DatetimeLiteral.hasValueFor(this.nanosecond)) {
            s.append(this.nanosecond);
            s.append(UNIT_NS);
        }
        return s.toString();
    }

    private static boolean hasValueFor(Long element) {
        return element != null && element != 0L;
    }

    private void parseD() {
        if (!dateValuePattern.matcher(this.data).matches()) {
            this.type = Type.INVALID;
            return;
        }
        String[] matches = (String[])unsignedIntPattern.matcher(this.data).results().map(MatchResult::group).toArray(String[]::new);
        if (matches.length != 3) {
            this.type = Type.INVALID;
            return;
        }
        this.year = Long.valueOf(matches[0].replace(UNDERSCORE, EMPTY));
        this.month = Long.valueOf(matches[1].replace(UNDERSCORE, EMPTY));
        this.day = Long.valueOf(matches[2].replace(UNDERSCORE, EMPTY));
        this.validateD();
    }

    private void validateD() {
        if (this.day < 1L) {
            this.type = Type.INVALID;
            return;
        }
        switch (this.month.intValue()) {
            case 2: {
                boolean isLeapYear = this.year % 4L == 0L && this.year % 100L != 0L || this.year % 400L == 0L;
                if (this.day <= (isLeapYear ? 29L : 28L)) break;
                this.type = Type.INVALID;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (this.day <= 31L) break;
                this.type = Type.INVALID;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (this.day <= 30L) break;
                this.type = Type.INVALID;
                break;
            }
            default: {
                this.type = Type.INVALID;
            }
        }
    }

    private String toDate() {
        StringBuilder s = new StringBuilder();
        s.append(this.year);
        s.append("-");
        s.append(String.format(TWO_DIGIT_NUMBER, this.month));
        s.append("-");
        s.append(String.format(TWO_DIGIT_NUMBER, this.day));
        return s.toString();
    }

    private String toTimeOfDay() {
        StringBuilder s = new StringBuilder();
        s.append(String.format(TWO_DIGIT_NUMBER, this.hour));
        s.append(TIMEOFDAY_SEPERATOR);
        s.append(String.format(TWO_DIGIT_NUMBER, this.minute));
        s.append(TIMEOFDAY_SEPERATOR);
        s.append(String.format(TWO_DIGIT_NUMBER, this.second));
        if (this.nanosecond != null && this.nanosecond != 0L) {
            s.append(TIMEOFDAY_SEPERATOR_DECIMALS);
            s.append(this.nanosecond);
        }
        return s.toString();
    }

    public String toString() {
        switch (this.type) {
            case T: {
                return MessageFormat.format("CIEC_TIME(\"T#{0}\")", this.toInterval());
            }
            case LT: {
                return MessageFormat.format("CIEC_TIME(\"LT#{0}\")", this.toInterval());
            }
            case D: {
                return MessageFormat.format("CIEC_DATE(\"D#{0}\")", this.toDate());
            }
            case LD: {
                return MessageFormat.format("CIEC_DATE(\"LD#{0}\")", this.toDate());
            }
            case TOD: {
                return MessageFormat.format("CIEC_TIME_OF_DAY(\"TOD#{0}\")", this.toTimeOfDay());
            }
            case LTOD: {
                return MessageFormat.format("CIEC_TIME_OF_DAY(\"LTOD#{0}\")", this.toTimeOfDay());
            }
            case DT: {
                return MessageFormat.format("CIEC_DATE_AND_TIME(\"DT#{0}-{1}\")", this.toDate(), this.toTimeOfDay());
            }
            case LDT: {
                return MessageFormat.format("CIEC_DATE_AND_TIME(\"LDT#{0}-{1}\")", this.toDate(), this.toTimeOfDay());
            }
        }
        return "INVALID()";
    }

    public static enum Type {
        INVALID,
        T,
        LT,
        D,
        LD,
        TOD,
        LTOD,
        DT,
        LDT;

    }
}

