/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.test.fb.interpreter.infra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.BasicFBTypeRuntime;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.EventManager;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.EventOccurrence;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.FBRuntimeAbstract;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.OperationalSemanticsFactory;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.Transaction;
import org.eclipse.fordiac.ide.fb.interpreter.mm.utils.EventManagerUtils;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.test.fb.interpreter.ModelDeserializer;
import org.eclipse.fordiac.ide.test.fb.interpreter.ModelSerializer;
import org.eclipse.fordiac.ide.test.fb.interpreter.infra.FBTransaction;

public class AbstractInterpreterTest {
    private static final String EXTERNAL_INTERFACE = "external";
    private static final String INTERNAL_INTERFACE = "internal";
    public static final String START_STATE = "START";
    static final ModelDeserializer deserializer = new ModelDeserializer();
    static final ModelSerializer serializer = new ModelSerializer();

    protected static BasicFBType loadFBType(String name) {
        return AbstractInterpreterTest.loadFBType(name, true);
    }

    protected static BasicFBType loadFBType(String name, boolean emptyService) {
        BasicFBType fbt = (BasicFBType)deserializer.loadModel("inputmodels/" + name + ".xmi");
        if (emptyService) {
            fbt.setService(AbstractInterpreterTest.createEmptyServiceModel());
        }
        return fbt;
    }

    public static Service createEmptyServiceModel() {
        Service s = LibraryElementFactory.eINSTANCE.createService();
        ServiceInterface left = LibraryElementFactory.eINSTANCE.createServiceInterface();
        left.setName(EXTERNAL_INTERFACE);
        ServiceInterface right = LibraryElementFactory.eINSTANCE.createServiceInterface();
        right.setName(INTERNAL_INTERFACE);
        s.setLeftInterface(left);
        s.setRightInterface(right);
        AbstractInterpreterTest.addServiceSequence(s);
        return s;
    }

    protected static ServiceSequence addServiceSequence(Service s) {
        ServiceSequence seq = LibraryElementFactory.eINSTANCE.createServiceSequence();
        seq.setName("Test" + s.getServiceSequence().size());
        s.getServiceSequence().add((Object)seq);
        return seq;
    }

    protected static ServiceTransaction addTransaction(ServiceSequence seq, FBTransaction fbtrans) {
        ServiceTransaction transaction = LibraryElementFactory.eINSTANCE.createServiceTransaction();
        seq.getServiceTransaction().add((Object)transaction);
        if (fbtrans.getInputEvent() != null) {
            InputPrimitive inputPrimitive = LibraryElementFactory.eINSTANCE.createInputPrimitive();
            inputPrimitive.setEvent(fbtrans.getInputEvent());
            transaction.setInputPrimitive(inputPrimitive);
        }
        if (!fbtrans.getOutputEvent().isEmpty()) {
            for (String event : fbtrans.getOutputEvent()) {
                OutputPrimitive outputPrimitive = LibraryElementFactory.eINSTANCE.createOutputPrimitive();
                outputPrimitive.setEvent(event);
                outputPrimitive.setInterface(((Service)seq.eContainer()).getLeftInterface());
                outputPrimitive.setParameters("");
                for (String parameter : fbtrans.getOutputParameter()) {
                    outputPrimitive.setParameters(String.valueOf(outputPrimitive.getParameters()) + parameter + ";");
                }
                transaction.getOutputPrimitive().add((Object)outputPrimitive);
            }
        }
        return transaction;
    }

    public static void setVariable(FBType fb, String name, String value) {
        IInterfaceElement el = fb.getInterfaceList().getInterfaceElement(name);
        if (el instanceof VarDeclaration) {
            Value val = ((VarDeclaration)el).getValue();
            if (val == null) {
                ((VarDeclaration)el).setValue(LibraryElementFactory.eINSTANCE.createValue());
            }
        } else {
            throw new IllegalArgumentException("variable does not exist in FB");
        }
        ((VarDeclaration)el).getValue().setValue(value);
    }

    private static Collection<Transaction> createTransactions(BasicFBType fb, ServiceSequence seq, BasicFBTypeRuntime runtime) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        for (ServiceTransaction st : seq.getServiceTransaction()) {
            String inputEvent = st.getInputPrimitive().getEvent();
            if (inputEvent == null) continue;
            EventOccurrence eventOccurrence = OperationalSemanticsFactory.eINSTANCE.createEventOccurrence();
            Event eventPin = (Event)fb.getInterfaceList().getInterfaceElement(inputEvent);
            if (eventPin == null) {
                throw new IllegalArgumentException("input primitive: event " + inputEvent + " does not exist");
            }
            eventOccurrence.setEvent(eventPin);
            Transaction transaction = OperationalSemanticsFactory.eINSTANCE.createTransaction();
            transaction.setInputEventOccurrence(eventOccurrence);
            String inputParameters = st.getInputPrimitive().getParameters();
            List<List<String>> paramList = AbstractInterpreterTest.getParametersFromString(inputParameters);
            for (List<String> parameter : paramList) {
                AbstractInterpreterTest.setVariable((FBType)fb, parameter.get(0), parameter.get(1));
            }
            transactions.add(transaction);
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        BasicFBTypeRuntime copyBasicFBTypeRuntime = (BasicFBTypeRuntime)copier.copy((EObject)runtime);
        copier.copyReferences();
        ((Transaction)transactions.get(0)).getInputEventOccurrence().setFbRuntime((FBRuntimeAbstract)copyBasicFBTypeRuntime);
        return transactions;
    }

    public static BasicFBType runTest(BasicFBType fb, ServiceSequence seq) throws Exception {
        return AbstractInterpreterTest.runTest(fb, seq, START_STATE);
    }

    public static BasicFBType runTest(BasicFBType fb, ServiceSequence seq, String startStateName) throws Exception {
        ResourceSetImpl reset = new ResourceSetImpl();
        Resource resource = reset.createResource(URI.createURI((String)("platform:/resource/" + fb.getName() + ".xmi")));
        EventManager eventManager = OperationalSemanticsFactory.eINSTANCE.createEventManager();
        resource.getContents().add((Object)eventManager);
        BasicFBTypeRuntime basicFBTypeRT = OperationalSemanticsFactory.eINSTANCE.createBasicFBTypeRuntime();
        basicFBTypeRT.setBasicfbtype(fb);
        EList stateList = basicFBTypeRT.getBasicfbtype().getECC().getECState();
        ECState startState = (ECState)stateList.stream().filter(s -> s.getName().equals(startStateName)).collect(Collectors.toList()).get(0);
        basicFBTypeRT.setActiveState(startState);
        eventManager.getTransactions().addAll(AbstractInterpreterTest.createTransactions(fb, seq, basicFBTypeRT));
        EventManagerUtils.process((EventManager)eventManager);
        AbstractInterpreterTest.checkResults(seq, eventManager);
        int nT = eventManager.getTransactions().size();
        Transaction t = (Transaction)eventManager.getTransactions().get(nT - 1);
        BasicFBType next = null;
        if (!t.getOutputEventOccurences().isEmpty()) {
            int nEv = t.getOutputEventOccurences().size();
            BasicFBTypeRuntime last = (BasicFBTypeRuntime)((EventOccurrence)t.getOutputEventOccurences().get(nEv - 1)).getFbRuntime();
            next = last.getBasicfbtype();
        } else {
            next = fb;
        }
        eventManager.getTransactions().clear();
        return next;
    }

    private static void checkResults(ServiceSequence seq, EventManager eventManager) throws Exception {
        EList expectedResults = seq.getServiceTransaction();
        EList results = eventManager.getTransactions();
        if (expectedResults.size() != results.size()) {
            throw new IllegalArgumentException("test data is incorrect");
        }
        int i = 0;
        while (i < expectedResults.size()) {
            Transaction result = (Transaction)results.get(i);
            ServiceTransaction expectedResult = (ServiceTransaction)expectedResults.get(i);
            AbstractInterpreterTest.checkTransaction(result, expectedResult);
            ++i;
        }
    }

    private static void checkTransaction(Transaction result, ServiceTransaction expectedResult) {
        if (!result.getInputEventOccurrence().getEvent().getName().equals(expectedResult.getInputPrimitive().getEvent())) {
            throw new IllegalArgumentException("Input event was not generated correctly");
        }
        long outputEvents = expectedResult.getOutputPrimitive().stream().filter(p -> !p.getInterface().getName().toLowerCase().contains(INTERNAL_INTERFACE)).count();
        if (outputEvents != (long)result.getOutputEventOccurences().size()) {
            throw new IllegalArgumentException("Unwanted output event occurrence");
        }
        int j = 0;
        while ((long)j < outputEvents) {
            OutputPrimitive p2 = (OutputPrimitive)expectedResult.getOutputPrimitive().get(j);
            AbstractInterpreterTest.checkOutputPrimitive(result, j, p2);
            ++j;
        }
    }

    private static void checkOutputPrimitive(Transaction result, int j, OutputPrimitive p) {
        if (!p.getInterface().getName().toLowerCase().contains(INTERNAL_INTERFACE)) {
            if (!p.getEvent().equals(((EventOccurrence)result.getOutputEventOccurences().get(j)).getEvent().getName())) {
                throw new IllegalArgumentException("Generated output event is incorrect");
            }
            if (!AbstractInterpreterTest.processParameters(p.getParameters(), result)) {
                throw new IllegalArgumentException("Parameter values do not match the data");
            }
        }
    }

    private static boolean processParameters(String parameters, Transaction result) {
        if (parameters == null || parameters.isBlank()) {
            return true;
        }
        int length = result.getOutputEventOccurences().size();
        BasicFBTypeRuntime captured = (BasicFBTypeRuntime)((EventOccurrence)result.getOutputEventOccurences().get(length - 1)).getFbRuntime();
        List<List<String>> parameterList = AbstractInterpreterTest.getParametersFromString(parameters);
        for (List<String> assumption : parameterList) {
            if (AbstractInterpreterTest.processParameter(assumption.get(0), assumption.get(1), captured.getBasicfbtype())) continue;
            return false;
        }
        return true;
    }

    private static List<String> splitParameterList(String parameters) {
        if (parameters == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(parameters.split(";"));
    }

    private static List<List<String>> getParametersFromString(String parameters) {
        List<String> statementList = AbstractInterpreterTest.splitParameterList(parameters);
        ArrayList<List<String>> parameterList = new ArrayList<List<String>>();
        for (String element : statementList) {
            List<String> statement = Arrays.asList(element.split(":="));
            parameterList.add(statement);
        }
        return parameterList;
    }

    private static boolean processParameter(String varName, String expectedValue, BasicFBType basicfbtype) {
        if (expectedValue == null || expectedValue.isBlank()) {
            return true;
        }
        IInterfaceElement el = basicfbtype.getInterfaceList().getInterfaceElement(varName);
        if (el instanceof VarDeclaration) {
            Value val = ((VarDeclaration)el).getValue();
            if ("BOOL".equalsIgnoreCase(((VarDeclaration)el).getTypeName())) {
                if ("1".equals(val.getValue())) {
                    val.setValue("TRUE");
                } else if ("0".equals(val.getValue())) {
                    val.setValue("FALSE");
                } else if ("1".equals(expectedValue)) {
                    expectedValue = "TRUE";
                } else if ("0".equals(expectedValue)) {
                    expectedValue = "FALSE";
                }
            }
            return val != null && expectedValue.equalsIgnoreCase(val.getValue());
        }
        return false;
    }
}

