/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.validation.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.validation.Activator;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.osgi.framework.Bundle;

public class OCLParser {
    private static final String CONSTRAINT_DIRECTORY = "constraints";
    private static final String CONSTRAINT_FILE_FBTYPE = "ECC.ocl";
    private static final String CONSTRAINT_FILE_APP = "FB.ocl";

    private OCLParser() {
    }

    public static List<Constraint> loadOCLConstraints(INamedElement element) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        Bundle bundle = Activator.getDefault().getBundle();
        String constraintFile = OCLParser.getOCLFile(element);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("constraints/" + constraintFile));
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream in = FileLocator.toFileURL((URL)url).openStream();){
                OCLInput document = new OCLInput(in);
                constraints.addAll(Activator.getDefault().getOclInstance().parse(document));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)e);
        }
        return constraints;
    }

    private static String getOCLFile(INamedElement element) {
        if (element instanceof FBType) {
            return CONSTRAINT_FILE_FBTYPE;
        }
        if (element instanceof Application || element instanceof SubApp) {
            return CONSTRAINT_FILE_APP;
        }
        return null;
    }
}

