/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.stack;

import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.eclipse.collections.api.partition.stack.PartitionImmutableStack;
import org.eclipse.collections.api.stack.StackIterable;
import org.eclipse.collections.api.stack.primitive.ImmutableBooleanStack;
import org.eclipse.collections.api.stack.primitive.ImmutableByteStack;
import org.eclipse.collections.api.stack.primitive.ImmutableCharStack;
import org.eclipse.collections.api.stack.primitive.ImmutableDoubleStack;
import org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.ImmutableShortStack;
import org.eclipse.collections.api.tuple.Pair;

public interface ImmutableStack<T>
extends StackIterable<T> {
    public ImmutableStack<T> push(T var1);

    public ImmutableStack<T> pop();

    public ImmutableStack<T> pop(int var1);

    default public Pair<T, ImmutableStack<T>> peekAndPop() {
        throw new UnsupportedOperationException("Default method to ensure backwards compatibility");
    }

    default public Pair<ListIterable<T>, ImmutableStack<T>> peekAndPop(int count) {
        throw new UnsupportedOperationException("Default method to ensure backwards compatibility");
    }

    @Override
    public ImmutableStack<T> takeWhile(Predicate<? super T> var1);

    @Override
    public ImmutableStack<T> dropWhile(Predicate<? super T> var1);

    @Override
    public PartitionImmutableStack<T> partitionWhile(Predicate<? super T> var1);

    @Override
    public ImmutableStack<T> distinct();

    @Override
    public ImmutableStack<T> tap(Procedure<? super T> var1);

    @Override
    public ImmutableStack<T> select(Predicate<? super T> var1);

    @Override
    public <P> ImmutableStack<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public ImmutableStack<T> reject(Predicate<? super T> var1);

    @Override
    public <P> ImmutableStack<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> ImmutableStack<S> selectInstancesOf(Class<S> var1);

    @Override
    public PartitionImmutableStack<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionImmutableStack<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <V> ImmutableStack<V> collect(Function<? super T, ? extends V> var1);

    @Override
    public ImmutableBooleanStack collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public ImmutableByteStack collectByte(ByteFunction<? super T> var1);

    @Override
    public ImmutableCharStack collectChar(CharFunction<? super T> var1);

    @Override
    public ImmutableDoubleStack collectDouble(DoubleFunction<? super T> var1);

    @Override
    public ImmutableFloatStack collectFloat(FloatFunction<? super T> var1);

    @Override
    public ImmutableIntStack collectInt(IntFunction<? super T> var1);

    @Override
    public ImmutableLongStack collectLong(LongFunction<? super T> var1);

    @Override
    public ImmutableShortStack collectShort(ShortFunction<? super T> var1);

    @Override
    public <P, V> ImmutableStack<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> ImmutableStack<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    default public <V> ImmutableStack<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf(each, n);
        });
    }

    @Override
    public <V> ImmutableStack<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> ImmutableStack<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public <V> ImmutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    default public <V> ImmutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.asLazy().collect((Function)function).toBag().toImmutable();
    }

    @Override
    default public <V, P> ImmutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.asLazy().collectWith((Function2)function, (Object)parameter).toBag().toImmutable();
    }

    @Override
    default public <V> ImmutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.asLazy().flatCollect((Function)function).toBag().toImmutable();
    }

    @Override
    public <V> ImmutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        MutableMap target = Maps.mutable.withInitialCapacity(this.size());
        return this.groupByUniqueKey(function, target).toImmutable();
    }

    @Override
    public <S> ImmutableStack<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public ImmutableStack<Pair<T, Integer>> zipWithIndex();

    @Override
    default public <K, V> ImmutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEach((? super T each) -> {
            Object key = groupBy.valueOf(each);
            Function0 value = map.getIfAbsentPut(key, zeroValueFactory);
            mutatingAggregator.value((Object)value, (Object)each);
        });
        return map.toImmutable();
    }

    @Override
    default public <K, V> ImmutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        MutableMap map = this.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator, Maps.mutable.empty());
        return map.toImmutable();
    }

    @Override
    default public <K> ImmutableMap<K, T> reduceBy(Function<? super T, ? extends K> groupBy, Function2<? super T, ? super T, ? extends T> reduceFunction) {
        MutableMap map = this.reduceBy(groupBy, reduceFunction, Maps.mutable.empty());
        return map.toImmutable();
    }

    @Override
    public <V> ImmutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> var1, IntFunction<? super T> var2);

    @Override
    public <V> ImmutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> var1, FloatFunction<? super T> var2);

    @Override
    public <V> ImmutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> var1, LongFunction<? super T> var2);

    @Override
    public <V> ImmutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> var1, DoubleFunction<? super T> var2);

    @Override
    public int size();
}

