/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.lookup.basic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.lookup.basic.BasicLookupEngine;
import org.eclipse.acceleo.query.validation.type.IType;

public class CacheLookupEngine
extends BasicLookupEngine {
    private static final IService<?> NO_SERVICE = new JavaMethodService(null, null, false);
    private final Map<String, Node> cache = new HashMap<String, Node>();

    public CacheLookupEngine(IReadOnlyQueryEnvironment queryEnvironment) {
        super(queryEnvironment);
    }

    @Override
    public ServiceRegistrationResult registerService(IService<?> service) {
        this.cache.clear();
        return super.registerService(service);
    }

    @Override
    public IService<?> lookup(String name, IType[] argumentTypes) {
        IService<?> result;
        Node cachedNode = this.getNodeFromCache(name, argumentTypes);
        if (cachedNode != null) {
            if (cachedNode.service == NO_SERVICE) {
                result = null;
            } else if (cachedNode.service == null) {
                result = super.lookup(name, argumentTypes);
                cachedNode.service = result;
            } else {
                result = cachedNode.service;
            }
        } else {
            result = super.lookup(name, argumentTypes);
            this.cacheService(name, argumentTypes, result);
        }
        return result;
    }

    private void cacheService(String name, IType[] argumentTypes, IService<?> service) {
        Node currentNode = this.cache.get(name);
        if (currentNode == null) {
            currentNode = new Node();
            this.cache.put(name, currentNode);
        }
        IType[] iTypeArray = argumentTypes;
        int n = argumentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            Node nextNode = currentNode.children.get(type);
            if (nextNode == null) {
                nextNode = new Node();
                currentNode.children.put(type, nextNode);
            }
            currentNode = nextNode;
            ++n2;
        }
        currentNode.service = service == null ? NO_SERVICE : service;
    }

    private Node getNodeFromCache(String name, IType[] argumentTypes) {
        Node result;
        Node currentNode = this.cache.get(name);
        if (currentNode != null) {
            IType[] iTypeArray = argumentTypes;
            int n = argumentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                currentNode = currentNode.children.get(type);
                if (currentNode == null) break;
                ++n2;
            }
            result = currentNode;
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public IService<?> removeService(IService<?> service) {
        this.cache.clear();
        return super.removeService(service);
    }

    private static final class Node {
        private final Map<IType, Node> children = new HashMap<IType, Node>();
        private IService<?> service;

        private Node() {
        }
    }
}

