/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.acore.edit.commands.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTest;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTransformer;
import org.eclipse.amp.amf.acore.edit.commands.test.ModelConstructionCommandTest;
import org.eclipse.amp.amf.acore.edit.commands.test.SetLabel;
import org.eclipse.amp.amf.acore.edit.commands.test.SetTransformer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.IID;
import org.metaabm.IValue;
import org.metaabm.MetaABMFactory;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.act.AAct;
import org.metaabm.act.AAll;
import org.metaabm.act.AAny;
import org.metaabm.act.AEvaluate;
import org.metaabm.act.AInput;
import org.metaabm.act.ALiteral;
import org.metaabm.act.AMove;
import org.metaabm.act.ANone;
import org.metaabm.act.AQuery;
import org.metaabm.act.ASchedule;
import org.metaabm.act.ASelect;
import org.metaabm.act.ASet;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.act.MetaABMActPackage;
import org.metaabm.function.FFunction;
import org.metaabm.function.FLibrary;
import org.metaabm.function.FOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelActsCommandTest
extends CommandTest {
    public ModelActsCommandTest(String name) {
        super(name);
    }

    public void testAddActs() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        ModelActsCommandTest.buildActs(cmds);
        this.executeTests(cmds);
    }

    public void testSimpleSinkInputs() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)MetaABMActFactory.eINSTANCE.createARule());
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)0);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)0);
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((String)((AAct)this.rootAct().getRoots().get(0)).getLabel(), (String)"Root Context Rule");
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()), (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)MetaABMActFactory.eINSTANCE.createAQuery());
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)1);
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("_Unspecified_"));
            }

            public void postCondition() {
                AQuery query = (AQuery)this.rootAct().findMember("_Unspecified_Query");
                ModelActsCommandTest.assertNotNull((Object)query);
                ModelActsCommandTest.assertEquals((int)query.getInputs().size(), (int)0);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct().findMember("_Unspecified_Query"), (Object)MetaABMActPackage.Literals.ASINK__FUNCTION, (Object)funcEq);
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)2);
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("_Unspecified_Query"));
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("_Unspecified_equal"));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((String)((AAct)this.rootAct().getMembers().get(1)).getID(), (String)"equalQuery");
                AQuery andQuery = (AQuery)this.rootAct().findMember("equalQuery");
                ModelActsCommandTest.assertNotNull((Object)andQuery);
                ModelActsCommandTest.assertEquals((int)andQuery.getInputs().size(), (int)2);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct().findMember("equalQuery"), (Object)MetaABMActPackage.Literals.ASINK__FUNCTION, (Object)funcNot);
            }

            public void preCondition() {
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("equalQuery"));
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("notQuery"));
            }

            public void postCondition() {
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("notQuery"));
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("equalQuery"));
                AQuery notQuery = (AQuery)this.rootAct().findMember("notQuery");
                ModelActsCommandTest.assertNotNull((Object)notQuery);
                ModelActsCommandTest.assertEquals((int)notQuery.getInputs().size(), (int)1);
            }
        });
        this.executeTests(cmds);
    }

    public void testSinkInputs() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        ModelActsCommandTest.buildActs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().getMembers().get(6));
                SAttribute attrA = MetaABMFactory.eINSTANCE.createSAttribute();
                attrA.setLabel("A");
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)attrA);
            }

            public void postCondition() {
                ModelActsCommandTest.assertNotNull((Object)this.model.findAttribute("a"));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AQuery query = (AQuery)this.rootAct().getMembers().get(6);
                SAttribute attrA = this.model.findAttribute("a");
                ModelActsCommandTest.assertNotNull((Object)attrA);
                AInput input = MetaABMActFactory.eINSTANCE.createAInput();
                input.setValue((IValue)attrA);
                Command createCMD = AddCommand.create((EditingDomain)this.getDomain(), (Object)query, (Object)MetaABMActPackage.Literals.ASINK__INPUTS, (Object)input);
                return createCMD;
            }

            public void preCondition() {
                AQuery query = (AQuery)this.rootAct().getMembers().get(6);
                ModelActsCommandTest.assertEquals((int)query.getInputs().size(), (int)0);
                ModelActsCommandTest.assertNotNull((Object)this.model.findAttribute("a"));
            }

            public void postCondition() {
                AAct sch = (AAct)this.rootAct().getMembers().get(5);
                AQuery query = (AQuery)this.rootAct().getMembers().get(6);
                SAttribute attrA = this.model.findAttribute("a");
                ModelActsCommandTest.assertEquals((Object)query.getSelected(), (Object)sch);
                ModelActsCommandTest.assertNotNull((Object)attrA);
                ModelActsCommandTest.assertEquals((int)query.getInputs().size(), (int)1);
                AInput input = (AInput)query.getInputs().get(0);
                ModelActsCommandTest.assertTrue((input.getSelected() == sch ? 1 : 0) != 0);
                ModelActsCommandTest.assertTrue((input.getSink() == query ? 1 : 0) != 0);
                ModelActsCommandTest.assertTrue((input.getValue() == attrA ? 1 : 0) != 0);
                ModelActsCommandTest.assertTrue((input.getValue() == attrA ? 1 : 0) != 0);
            }
        });
        this.executeTests(cmds);
    }

    public void testAgentSinkInputsRemoveAgentAttr() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelActsCommandTest.addInputs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.memAgent(), (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)this.agAttr(0));
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.memAgent().getAttributes().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)((SAttribute)this.memAgent().getAttributes().get(0)).getAccessors().size(), (int)1);
                ModelActsCommandTest.assertEquals((Object)this.memAgent().getAttributes().get(0), (Object)((AInput)this.agQuery().getInputs().get(0)).getValue());
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(0)).getValue(), (Object)this.agAttr(0));
                ModelActsCommandTest.assertEquals((Object)((SAttribute)((AInput)this.agQuery().getInputs().get(0)).getValue()).getOwner(), (Object)this.memAgent());
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.memAgent().getAttributes().size(), (int)0);
                ModelActsCommandTest.assertNull((Object)((AInput)this.agQuery().getInputs().get(0)).getValue());
            }
        });
        this.executeTests(cmds);
    }

    public void testAgentSinkInputsRemoveContextAttr() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelActsCommandTest.addInputs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                SAttribute findAttribute = this.model.findAttribute("rootC");
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)findAttribute);
            }

            public void preCondition() {
                SAttribute findAttribute = this.model.findAttribute("rootC");
                ModelActsCommandTest.assertEquals((String)this.agQuery().getID(), (String)"agentAEqualRootCQuery");
                AQuery query = (AQuery)this.agentRootAct().findMember("agentAEqualRootCQuery");
                ModelActsCommandTest.assertNotNull((Object)query);
                ModelActsCommandTest.assertEquals((int)this.model.getAttributes().size(), (int)3);
                ModelActsCommandTest.assertEquals((int)findAttribute.getAccessors().size(), (int)1);
                ModelActsCommandTest.assertEquals((String)findAttribute.getID(), (String)"rootC");
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(0)).getValue(), (Object)this.agAttr(0));
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(1)).getValue(), (Object)this.attr(2));
                ModelActsCommandTest.assertEquals((Object)((SAttribute)((AInput)this.agQuery().getInputs().get(1)).getValue()).getOwner(), (Object)this.model);
            }

            public void postCondition() {
                ModelActsCommandTest.assertNull((Object)this.model.findAttribute("rootC"));
                ModelActsCommandTest.assertEquals((String)this.agQuery().getID(), (String)"agentAEqualQuery");
                AQuery query = (AQuery)this.agentRootAct().findMember("agentAEqualQuery");
                ModelActsCommandTest.assertNotNull((Object)query);
                AInput delInput = (AInput)query.getInputs().get(1);
                ModelActsCommandTest.assertNull((Object)delInput.getValue());
                ModelActsCommandTest.assertEquals((Object)((AInput)query.getInputs().get(0)).getValue(), (Object)this.memAgent().getAttributes().get(0));
                ModelActsCommandTest.assertEquals((Object)delInput.getValue(), null);
            }
        });
        this.executeTests(cmds);
    }

    public void testAgentSinkInputsRemoveAgentTargetRule() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelActsCommandTest.addInputs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.agentRootAct().getMembers().get(0), (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)this.agentRootAct().getMembers().get(1));
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.memAgent().getAttributes().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)((SAttribute)this.memAgent().getAttributes().get(0)).getAccessors().size(), (int)1);
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(0)).getValue(), (Object)this.agAttr(0));
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(1)).getValue(), (Object)this.attr(2));
                ModelActsCommandTest.assertEquals((Object)((SAttribute)((AInput)this.agQuery().getInputs().get(0)).getValue()).getOwner(), (Object)this.memAgent());
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.memAgent().getAttributes().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)((SAttribute)this.memAgent().getAttributes().get(0)).getAccessors().size(), (int)0);
            }
        });
        this.executeTests(cmds);
    }

    public void testAgentSinkDeleteAgentTargetRule() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelActsCommandTest.addInputs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                Command delCMD = DeleteCommand.create((EditingDomain)this.getDomain(), (Object)this.agentRootAct().getMembers().get(1));
                ModelActsCommandTest.assertTrue((boolean)delCMD.canExecute());
                return delCMD;
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.memAgent().getAttributes().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)((SAttribute)this.memAgent().getAttributes().get(0)).getAccessors().size(), (int)1);
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(0)).getValue(), (Object)this.agAttr(0));
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(1)).getValue(), (Object)this.attr(2));
                ModelActsCommandTest.assertEquals((Object)((SAttribute)((AInput)this.agQuery().getInputs().get(0)).getValue()).getOwner(), (Object)this.memAgent());
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)2);
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.memAgent().getAttributes().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)((SAttribute)this.memAgent().getAttributes().get(0)).getAccessors().size(), (int)0);
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)1);
            }
        });
        this.executeTests(cmds);
    }

    public void testAgentSinkInputsRemoveAgentMemberRule() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelActsCommandTest.addInputs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.agentRootAct(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)this.agentRootAct().getMembers().get(1));
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.memAgent().getAttributes().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)((SAttribute)this.memAgent().getAttributes().get(0)).getAccessors().size(), (int)1);
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(0)).getValue(), (Object)this.agAttr(0));
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(1)).getValue(), (Object)this.attr(2));
                ModelActsCommandTest.assertEquals((Object)((SAttribute)((AInput)this.agQuery().getInputs().get(0)).getValue()).getOwner(), (Object)this.memAgent());
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.memAgent().getAttributes().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)((SAttribute)this.memAgent().getAttributes().get(0)).getAccessors().size(), (int)0);
            }
        });
        this.executeTests(cmds);
    }

    public void testAgentSinkInputsRemoveAgent() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelActsCommandTest.addInputs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SCONTEXT__AGENTS, (Object)this.memAgent());
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.model.getAgents().size(), (int)2);
                ModelActsCommandTest.assertEquals((int)this.model.getAttributes().size(), (int)3);
                ModelActsCommandTest.assertEquals((int)((SAttribute)this.model.getAttributes().get(2)).getAccessors().size(), (int)1);
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(0)).getValue(), (Object)this.agAttr(0));
                ModelActsCommandTest.assertEquals((Object)((AInput)this.agQuery().getInputs().get(1)).getValue(), (Object)this.attr(2));
                ModelActsCommandTest.assertEquals((Object)((SAttribute)((AInput)this.agQuery().getInputs().get(0)).getValue()).getOwner(), (Object)this.memAgent());
                ModelActsCommandTest.assertEquals((Object)this.attr(2), (Object)this.model.findAttribute("rootC"));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.model.getAgents().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)this.model.getAttributes().size(), (int)2);
                ModelActsCommandTest.assertEquals((Object)this.model.getAttributes().get(1), (Object)this.model.findAttribute("rootC"));
                ModelActsCommandTest.assertEquals((int)((SAttribute)this.model.getAttributes().get(1)).getAccessors().size(), (int)0);
            }
        });
        this.executeTests(cmds);
    }

    public static void addInputs(List<CommandTransformer> cmds) {
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        FLibrary library = (FLibrary)lib.getLibrary().get(0);
        FLibrary funcNum = library.findSub("operators").findSub("logicalOperators");
        final FFunction funcEq = funcNum.findFunction("equal");
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.agentRootAct(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)MetaABMActFactory.eINSTANCE.createARule());
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)0);
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getRoots().size(), (int)0);
                ModelActsCommandTest.assertNull((Object)this.agentRootAct().findMember(ModelActsCommandTest.getAgentRuleID()));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getRoots().size(), (int)1);
                ModelActsCommandTest.assertNotNull((Object)this.agentRootAct().findMember(ModelActsCommandTest.getAgentRuleID()));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.agentRootAct().findMember(ModelActsCommandTest.getAgentRuleID()), (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)MetaABMActFactory.eINSTANCE.createAQuery());
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getRoots().size(), (int)1);
                ModelActsCommandTest.assertNull((Object)this.agentRootAct().findMember("_Unspecified_"));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)2);
                ModelActsCommandTest.assertEquals((int)this.agentRootAct().getRoots().size(), (int)1);
                ModelActsCommandTest.assertNotNull((Object)this.agentRootAct().findMember("_Unspecified_Query"));
                AAct rootContextRule = this.agentRootAct().findMember(ModelActsCommandTest.getAgentRuleID());
                ModelActsCommandTest.assertEquals((int)rootContextRule.getTargets().size(), (int)1);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                SAttribute attrA = MetaABMFactory.eINSTANCE.createSAttribute();
                attrA.setLabel("Agent A");
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.memAgent(), (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)attrA);
            }

            public void postCondition() {
                ModelActsCommandTest.assertNotNull((Object)this.memAgent().findAttribute("agentA"));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                SAttribute rootC = MetaABMFactory.eINSTANCE.createSAttribute();
                rootC.setLabel("Root C");
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)rootC);
            }

            public void postCondition() {
                ModelActsCommandTest.assertNotNull((Object)this.model.findAttribute("rootC"));
                ModelActsCommandTest.assertEquals((Object)this.attr(2), (Object)this.model.findAttribute("rootC"));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.agQuery(), (Object)MetaABMActPackage.Literals.ASINK__FUNCTION, (Object)funcEq);
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.agQuery().getInputs().size(), (int)0);
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.agQuery().getInputs().size(), (int)2);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.agInput(0), (Object)MetaABMActPackage.Literals.AINPUT__VALUE, (Object)this.agAttr(0));
            }

            public void preCondition() {
                ModelActsCommandTest.assertNull((Object)this.agInput(0).getValue());
                ModelActsCommandTest.assertEquals((int)this.agAttr(0).getAccessors().size(), (int)0);
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((Object)this.agInput(0).getValue(), (Object)this.agAttr(0));
                ModelActsCommandTest.assertEquals((int)this.agAttr(0).getAccessors().size(), (int)1);
                SAttribute attrA = this.memAgent().findAttribute("agentA");
                ModelActsCommandTest.assertNotNull((Object)attrA);
                ModelActsCommandTest.assertTrue((this.agInput(0).getValue() == attrA ? 1 : 0) != 0);
                ModelActsCommandTest.assertEquals((Object)this.agAttr(0).getAccessors().get(0), (Object)this.agInput(0));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.agInput(1), (Object)MetaABMActPackage.Literals.AINPUT__VALUE, (Object)this.model.findAttribute("rootC"));
            }

            public void preCondition() {
                ModelActsCommandTest.assertNull((Object)this.agInput(1).getValue());
                ModelActsCommandTest.assertEquals((int)this.attr(0).getAccessors().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)this.attr(2).getAccessors().size(), (int)0);
            }

            public void postCondition() {
                ModelActsCommandTest.assertNotNull((Object)this.agInput(1).getValue());
                ModelActsCommandTest.assertEquals((Object)this.attr(2), (Object)this.model.findAttribute("rootC"));
                ModelActsCommandTest.assertEquals((int)this.attr(2).getAccessors().size(), (int)1);
                ModelActsCommandTest.assertEquals((Object)this.agInput(1).getValue(), (Object)this.attr(2));
                ModelActsCommandTest.assertEquals((Object)this.agInput(0), (Object)this.agAttr(0).getAccessors().get(0));
                ModelActsCommandTest.assertEquals((String)this.agQuery().getID(), (String)"agentAEqualRootCQuery");
            }
        });
    }

    public void testSinkLabels() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        ModelActsCommandTest.buildActs(cmds);
        ModelActsCommandTest.buildAttrQueries(cmds);
        ModelActsCommandTest.buildLogicAct(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AAct allSource = this.rootAct().findMember("_NotAQueryAndAAddB_");
                ModelActsCommandTest.assertNotNull((Object)allSource);
                AAll allFinal = MetaABMActFactory.eINSTANCE.createAAll();
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)allSource, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)allFinal);
            }

            public void postCondition() {
                super.postCondition();
                AAll allFinal = (AAll)this.rootAct().getMembers().get(11);
                ModelActsCommandTest.assertEquals((String)allFinal.getID(), (String)"_And__NotAQueryAndAAddB_");
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AAct allSource = this.rootAct().findMember("_NotAQueryOrAAddB_");
                ModelActsCommandTest.assertNotNull((Object)allSource);
                AAct allFinal = this.rootAct().findMember("_And__NotAQueryAndAAddB_");
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)allSource, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)allFinal);
            }

            public void postCondition() {
                super.postCondition();
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)12);
                AAll allFinal = (AAll)this.rootAct().getMembers().get(11);
                ModelActsCommandTest.assertEquals((String)allFinal.getID(), (String)"__NotAQueryAndAAddB_And_NotAQueryOrAAddB__");
            }
        });
        cmds.add(new SetLabel("A", "C"){

            public IID getIID() {
                return (IID)this.model.getAttributes().get(2);
            }

            public void postCondition() {
                super.postCondition();
                AAll allFinal = (AAll)this.rootAct().getMembers().get(11);
                ModelActsCommandTest.assertEquals((String)allFinal.getID(), (String)"__NotCQueryAndCAddB_And_NotCQueryOrCAddB__");
            }
        });
        this.executeTests(cmds);
    }

    private static void buildAttrQueries(List<CommandTransformer> cmds) {
        cmds.add(new SetTransformer((EStructuralFeature)MetaABMActPackage.Literals.ASINK__FUNCTION, funcNot){

            public IID getIID() {
                return (IID)this.rootAct().getMembers().get(6);
            }

            public void preCondition() {
                ModelActsCommandTest.assertTrue((boolean)(this.rootAct().getMembers().get(6) instanceof AQuery));
                AQuery filter = (AQuery)this.rootAct().getMembers().get(6);
                ModelActsCommandTest.assertTrue((boolean)(funcNot instanceof FOperator));
                ModelActsCommandTest.assertEquals((int)((FOperator)funcNot).getArity(), (int)1);
                ModelActsCommandTest.assertNull((Object)filter.getFunction());
                ModelActsCommandTest.assertEquals((String)filter.getLabel(), (String)"[Unspecified]() Query");
                ModelActsCommandTest.assertEquals((String)filter.getID(), (String)"_Unspecified_Query");
            }

            public void postCondition() {
                AQuery filter = (AQuery)this.rootAct().getMembers().get(6);
                ModelActsCommandTest.assertNotNull((Object)filter.getFunction());
                ModelActsCommandTest.assertSame((Object)filter.getFunction(), (Object)funcNot);
                ModelActsCommandTest.assertEquals((String)filter.getID(), (String)"notQuery");
                ModelActsCommandTest.assertEquals((int)filter.getInputs().size(), (int)1);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                SAttribute attrA = MetaABMFactory.eINSTANCE.createSAttribute();
                attrA.setLabel("A");
                CompoundCommand cmd = new CompoundCommand();
                cmd.append(AddCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)attrA));
                SAttribute attrB = MetaABMFactory.eINSTANCE.createSAttribute();
                attrB.setLabel("B");
                cmd.append(AddCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)attrB));
                return cmd;
            }

            public void postCondition() {
                ModelActsCommandTest.assertNotNull((Object)this.model.findAttribute("a"));
                ModelActsCommandTest.assertNotNull((Object)this.model.findAttribute("b"));
                ModelActsCommandTest.assertSame((Object)this.model.getAttributes().get(2), (Object)this.model.findAttribute("a"));
                ModelActsCommandTest.assertSame((Object)this.model.getAttributes().get(3), (Object)this.model.findAttribute("b"));
                AQuery query = (AQuery)this.rootAct().getMembers().get(6);
                ModelActsCommandTest.assertEquals((String)query.getID(), (String)"notQuery");
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AQuery query = (AQuery)this.rootAct().getMembers().get(6);
                AInput input = (AInput)query.getInputs().get(0);
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)input, (Object)MetaABMActPackage.Literals.AINPUT__VALUE, (Object)this.model.findAttribute("a"));
            }

            public IID getIID() {
                return (IID)this.rootAct().getMembers().get(6);
            }

            public void preCondition() {
                ModelActsCommandTest.assertTrue((boolean)(this.getIID() instanceof AQuery));
                AQuery query = (AQuery)this.rootAct().getMembers().get(6);
                AInput input0 = (AInput)query.getInputs().get(0);
                ModelActsCommandTest.assertNull((Object)input0.getValue());
                ModelActsCommandTest.assertNull((Object)input0.getLiteral());
                ModelActsCommandTest.assertEquals((Object)input0.getValue(), null);
                ModelActsCommandTest.assertEquals((Object)input0.getLiteral(), null);
                ModelActsCommandTest.assertEquals((String)query.getID(), (String)"notQuery");
            }

            public void postCondition() {
                AQuery query = (AQuery)this.getIID();
                ModelActsCommandTest.assertNotNull((Object)query.getFunction());
                ModelActsCommandTest.assertSame((Object)query.getFunction(), (Object)funcNot);
                ModelActsCommandTest.assertEquals((String)query.getID(), (String)"notAQuery");
                AInput input0 = (AInput)query.getInputs().get(0);
                SAttribute findAttribute = this.model.findAttribute("a");
                ModelActsCommandTest.assertNotNull((Object)findAttribute);
                ModelActsCommandTest.assertSame((Object)input0.getValue(), (Object)findAttribute);
                ModelActsCommandTest.assertSame((Object)input0.getLiteral(), null);
                ModelActsCommandTest.assertTrue((boolean)findAttribute.getAccessors().contains((Object)input0));
                ModelActsCommandTest.assertSame((Object)input0.getValue().getLabel(), (Object)"A");
            }
        });
        cmds.add(new SetTransformer((EStructuralFeature)MetaABMActPackage.Literals.ASINK__FUNCTION, funcAdd){

            public IID getIID() {
                return (IID)this.rootAct().getMembers().get(7);
            }

            public void preCondition() {
                AEvaluate eval = (AEvaluate)this.rootAct().getMembers().get(7);
                ModelActsCommandTest.assertNull((Object)eval.getFunction());
                ModelActsCommandTest.assertEquals((String)eval.getID(), (String)"_Unspecified_");
            }

            public void postCondition() {
                AEvaluate eval = (AEvaluate)this.rootAct().getMembers().get(7);
                ModelActsCommandTest.assertNotNull((Object)eval.getFunction());
                ModelActsCommandTest.assertSame((Object)eval.getFunction(), (Object)funcAdd);
                ModelActsCommandTest.assertEquals((int)eval.getInputs().size(), (int)2);
                ModelActsCommandTest.assertEquals((String)eval.getID(), (String)"add");
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                CompoundCommand cmd = new CompoundCommand();
                ArrayList<SAttribute> attrs = new ArrayList<SAttribute>();
                attrs.add(this.model.findAttribute("a"));
                attrs.add(this.model.findAttribute("b"));
                EList inputs = ((AEvaluate)this.getIID()).getInputs();
                int i = 0;
                for (SAttribute attribute : attrs) {
                    cmd.append(SetCommand.create((EditingDomain)this.getDomain(), inputs.get(i++), (Object)MetaABMActPackage.Literals.AINPUT__VALUE, (Object)attribute));
                }
                return cmd;
            }

            public IID getIID() {
                return (IID)this.rootAct().getMembers().get(7);
            }

            public void preCondition() {
                ModelActsCommandTest.assertTrue((boolean)(this.getIID() instanceof AEvaluate));
                AEvaluate eval = (AEvaluate)this.rootAct().getMembers().get(7);
                ModelActsCommandTest.assertEquals((String)eval.getID(), (String)"add");
            }

            public void postCondition() {
                AEvaluate eval = (AEvaluate)this.rootAct().getMembers().get(7);
                ModelActsCommandTest.assertEquals((int)eval.getInputs().size(), (int)2);
                ModelActsCommandTest.assertNotNull((Object)eval.getFunction());
                ModelActsCommandTest.assertSame((Object)eval.getFunction(), (Object)funcAdd);
                ModelActsCommandTest.assertEquals((String)eval.getLabel(), (String)"A Add B");
                ModelActsCommandTest.assertEquals((String)eval.getID(), (String)"aAddB");
                ModelActsCommandTest.assertSame((Object)((AInput)eval.getInputs().get(1)).getValue(), (Object)this.model.findAttribute("b"));
            }
        });
    }

    public void testSchedule() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        ModelActsCommandTest.buildActs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.getIID(), (Object)MetaABMActPackage.Literals.ASCHEDULE__INTERVAL, (Object)2);
            }

            public ASchedule getIID() {
                return (ASchedule)this.rootAct().getMembers().get(5);
            }

            public void preCondition() {
                ModelActsCommandTest.assertTrue((boolean)(this.getIID() instanceof ASchedule));
                ModelActsCommandTest.assertEquals((int)this.getIID().getInterval(), (int)0);
                ModelActsCommandTest.assertEquals((String)this.getIID().getLabel(), (String)"At 0 Every 0");
                ModelActsCommandTest.assertEquals((String)this.getIID().getID(), (String)ModelActsCommandTest.getScheduleID());
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.getIID().getInterval(), (int)2);
                ModelActsCommandTest.assertEquals((String)this.getIID().getLabel(), (String)"At 0 Every 2");
                ModelActsCommandTest.assertEquals((String)this.getIID().getID(), (String)"at0Every2");
            }
        });
        this.executeTests(cmds);
    }

    public void testAllAnyNone() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        ModelActsCommandTest.buildActs(cmds);
        ModelActsCommandTest.buildAttrQueries(cmds);
        ModelActsCommandTest.buildLogicAct(cmds);
        this.executeTests(cmds);
    }

    private static void buildLogicAct(List<CommandTransformer> cmds) {
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AAct noneAct = this.rootAct().findMember("notAQuery");
                ModelActsCommandTest.assertNotNull((Object)noneAct);
                AAll all = MetaABMActFactory.eINSTANCE.createAAll();
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)noneAct, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)all);
            }

            public void postCondition() {
                super.postCondition();
                AAll all = (AAll)this.rootAct().getMembers().get(8);
                AAct noneAct = this.rootAct().findMember("notAQuery");
                ModelActsCommandTest.assertEquals((Object)all.getSources().get(0), (Object)noneAct);
                ModelActsCommandTest.assertNotNull((Object)all.getSelected());
                ModelActsCommandTest.assertEquals((Object)((AAct)all.getSources().get(0)).getSelected(), (Object)all.getSelected());
                ModelActsCommandTest.assertEquals((String)all.getSelected().getLabel(), (String)"At 0 Every 0");
                ModelActsCommandTest.assertEquals((String)all.getLabel(), (String)"(&) Not A Query");
                ModelActsCommandTest.assertEquals((String)all.getID(), (String)"_And_NotAQuery");
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AAll allAct = (AAll)this.rootAct().getMembers().get(8);
                AAct addAct = this.rootAct().findMember("aAddB");
                ModelActsCommandTest.assertNotNull((Object)addAct);
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)addAct, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)allAct);
            }

            public void postCondition() {
                super.postCondition();
                AAll all = (AAll)this.rootAct().getMembers().get(8);
                ModelActsCommandTest.assertEquals((String)all.getID(), (String)"_NotAQueryAndAAddB_");
                ModelActsCommandTest.assertEquals((String)all.getLabel(), (String)"(Not A Query & A Add B)");
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AAct noneAct = this.rootAct().findMember("notAQuery");
                ModelActsCommandTest.assertNotNull((Object)noneAct);
                AAny any = MetaABMActFactory.eINSTANCE.createAAny();
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)noneAct, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)any);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AAny anyAct = (AAny)this.rootAct().getMembers().get(9);
                AAct addAct = this.rootAct().findMember("aAddB");
                ModelActsCommandTest.assertNotNull((Object)addAct);
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)addAct, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)anyAct);
            }

            public void postCondition() {
                super.postCondition();
                AAny anyAct = (AAny)this.rootAct().getMembers().get(9);
                ModelActsCommandTest.assertEquals((String)anyAct.getID(), (String)"_NotAQueryOrAAddB_");
                ModelActsCommandTest.assertEquals((String)anyAct.getLabel(), (String)"(Not A Query | A Add B)");
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AAct notAct = this.rootAct().findMember("notAQuery");
                ModelActsCommandTest.assertNotNull((Object)notAct);
                ANone noneAct = MetaABMActFactory.eINSTANCE.createANone();
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)notAct, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)noneAct);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                ANone noneAct = (ANone)this.rootAct().getMembers().get(10);
                AAct addAct = this.rootAct().findMember("aAddB");
                ModelActsCommandTest.assertNotNull((Object)addAct);
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)addAct, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)noneAct);
            }

            public void postCondition() {
                super.postCondition();
                ANone noneAct = (ANone)this.rootAct().getMembers().get(10);
                ModelActsCommandTest.assertEquals((String)noneAct.getID(), (String)"not__NotAQueryOrAAddB__");
                ModelActsCommandTest.assertEquals((String)noneAct.getLabel(), (String)"!((Not A Query | A Add B))");
            }
        });
    }

    public void testRenameSetAttributes() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildBasic(cmds);
        ModelActsCommandTest.buildActs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)MetaABMFactory.eINSTANCE.createSAttribute());
            }
        });
        cmds.add(new SetLabel("Attribute", "Test Attribute"){

            public IID getIID() {
                return (IID)this.model.getAttributes().get(2);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)this.getIID(), (Object)MetaABMActPackage.Literals.AACCESSOR__ATTRIBUTE, (Object)this.model.getAttributes().get(2));
            }

            public IID getIID() {
                return (IID)this.rootAct().getMembers().get(4);
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((String)this.getIID().getLabel(), (String)"Set [?] To [?]");
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((String)this.getIID().getLabel(), (String)"Set Test Attribute To [?]");
            }
        });
        cmds.add(new SetLabel("Test Attribute", "Another Attribute"){

            public IID getIID() {
                return (IID)this.model.getAttributes().get(2);
            }

            public AAct getAct() {
                return (AAct)this.rootAct().getMembers().get(4);
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((String)this.getAct().getLabel(), (String)"Set Test Attribute To [?]");
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((String)this.getAct().getLabel(), (String)"Set Another Attribute To [?]");
            }
        });
        this.executeTests(cmds);
    }

    public void testSimpleActs() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)MetaABMActFactory.eINSTANCE.createARule());
            }

            public void preCondition() {
                CommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)3);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)1);
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("buildRootContext"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("createRootContextAgents"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("createRootContextContexts"));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)4);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)2);
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("buildRootContext"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("createRootContextAgents"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("createRootContextContexts"));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)4);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)2);
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("buildRootContext"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("createRootContextAgents"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("createRootContextContexts"));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)3);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)1);
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("buildRootContext"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("createRootContextAgents"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("createRootContextContexts"));
            }
        });
        this.executeTests(cmds);
    }

    public void testRemoveActs() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        ModelActsCommandTest.buildActs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)this.rootAct().findMember("_Unspecified_"));
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)8);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)3);
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getScheduleID()));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("_Unspecified_Query"));
                AAct setTo = this.rootAct().findMember("setTo");
                AAct schedule = this.rootAct().findMember(ModelActsCommandTest.getScheduleID());
                AAct rule = this.rootAct().findMember(ModelActsCommandTest.getRuleID());
                ModelActsCommandTest.assertEquals((int)rule.getTargets().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)schedule.getTargets().size(), (int)2);
                ModelActsCommandTest.assertEquals((int)setTo.getSources().size(), (int)2);
                ModelActsCommandTest.assertEquals((int)setTo.getTargets().size(), (int)1);
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)7);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)3);
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getScheduleID()));
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("_Unspecified_"));
                AAct setTo = this.rootAct().findMember("setTo");
                AAct schedule = this.rootAct().findMember(ModelActsCommandTest.getScheduleID());
                AAct rule = this.rootAct().findMember(ModelActsCommandTest.getRuleID());
                ModelActsCommandTest.assertEquals((int)rule.getTargets().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)schedule.getTargets().size(), (int)2);
                ModelActsCommandTest.assertEquals((int)setTo.getSources().size(), (int)2);
                ModelActsCommandTest.assertEquals((int)setTo.getTargets().size(), (int)0);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)7);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)3);
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("setTo"));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)6);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)2);
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("setTo"));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)this.rootAct().findMember(ModelActsCommandTest.getScheduleID()));
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)6);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)2);
                AAct set = this.rootAct().findMember("setTo");
                ModelActsCommandTest.assertNotNull((Object)set);
                AAct schedule = this.rootAct().findMember(ModelActsCommandTest.getScheduleID());
                ModelActsCommandTest.assertNotNull((Object)schedule);
                ModelActsCommandTest.assertEquals((int)set.getSources().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)schedule.getTargets().size(), (int)2);
            }

            public void postCondition() {
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("setTo"));
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember(ModelActsCommandTest.getScheduleID()));
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("_Unspecified_()"));
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)3);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)1);
            }
        });
        this.executeTests(cmds);
    }

    public void testLiterals() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        FLibrary library = (FLibrary)lib.getLibrary().get(0);
        FLibrary funcNum = library.findSub("operators").findSub("numericOperators");
        final FFunction funcAdd = funcNum.findFunction("add");
        ModelActsCommandTest.buildActs(cmds);
        cmds.add(new SetTransformer((EStructuralFeature)MetaABMActPackage.Literals.ASINK__FUNCTION, funcAdd){

            public IID getIID() {
                return (IID)this.rootAct().getMembers().get(7);
            }

            public void preCondition() {
                AEvaluate eval = (AEvaluate)this.getIID();
                ModelActsCommandTest.assertNull((Object)eval.getFunction());
                ModelActsCommandTest.assertEquals((String)eval.getLabel(), (String)"[Unspecified]()");
                ModelActsCommandTest.assertEquals((String)eval.getID(), (String)"_Unspecified_");
            }

            public void postCondition() {
                AEvaluate eval = (AEvaluate)this.getIID();
                ModelActsCommandTest.assertNotNull((Object)eval);
                ModelActsCommandTest.assertNotNull((Object)eval.getFunction());
                ModelActsCommandTest.assertSame((Object)eval.getFunction(), (Object)funcAdd);
                ModelActsCommandTest.assertEquals((int)eval.getInputs().size(), (int)2);
                ModelActsCommandTest.assertEquals((String)eval.getLabel(), (String)"[?] Add [?]");
                ModelActsCommandTest.assertEquals((String)eval.getID(), (String)"add");
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AEvaluate eval = (AEvaluate)this.rootAct().getMembers().get(7);
                ModelActsCommandTest.assertNotNull((Object)eval);
                ALiteral literal = MetaABMActFactory.eINSTANCE.createALiteral();
                ModelActsCommandTest.assertNotNull((Object)literal);
                AInput input1 = (AInput)eval.getInputs().get(0);
                ModelActsCommandTest.assertNotNull((Object)input1);
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)input1, (Object)MetaABMActPackage.Literals.AINPUT__LITERAL, (Object)literal);
            }

            public void postCondition() {
                AEvaluate eval = (AEvaluate)this.rootAct().getMembers().get(7);
                ModelActsCommandTest.assertNotNull((Object)eval.getFunction());
                AInput input1 = (AInput)eval.getInputs().get(0);
                ModelActsCommandTest.assertNotNull((Object)input1);
                ModelActsCommandTest.assertSame((Object)eval.getFunction(), (Object)funcAdd);
                ModelActsCommandTest.assertEquals((String)eval.getID(), (String)"nullAdd");
                ModelActsCommandTest.assertSame((Object)input1.getValue(), (Object)input1.getLiteral());
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AEvaluate eval = (AEvaluate)this.rootAct().getMembers().get(7);
                ModelActsCommandTest.assertNotNull((Object)eval);
                ALiteral literal = ((AInput)eval.getInputs().get(0)).getLiteral();
                ModelActsCommandTest.assertNotNull((Object)literal);
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)literal, (Object)MetaABMActPackage.Literals.ALITERAL__VALUE_LITERAL, (Object)"13");
            }

            public void postCondition() {
                AEvaluate eval = (AEvaluate)this.rootAct().getMembers().get(7);
                AInput input1 = (AInput)eval.getInputs().get(0);
                ModelActsCommandTest.assertSame((Object)input1.getLiteral().getValueLiteral(), (Object)"13");
                ModelActsCommandTest.assertEquals((String)input1.getLiteral().getLabel(), (String)"Literal 13");
                ModelActsCommandTest.assertEquals((String)eval.getLabel(), (String)"Literal 13 Add [?]");
                ModelActsCommandTest.assertEquals((String)eval.getID(), (String)"literal13Add");
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                AEvaluate eval = (AEvaluate)this.rootAct().getMembers().get(7);
                ModelActsCommandTest.assertNotNull((Object)eval);
                AInput input1 = (AInput)eval.getInputs().get(0);
                ALiteral literal = input1.getLiteral();
                ModelActsCommandTest.assertNotNull((Object)literal);
                return SetCommand.create((EditingDomain)this.getDomain(), (Object)input1, (Object)MetaABMActPackage.Literals.AINPUT__VALUE, null);
            }

            public void postCondition() {
                AEvaluate eval = (AEvaluate)this.rootAct().getMembers().get(7);
                AInput input1 = (AInput)eval.getInputs().get(0);
                ModelActsCommandTest.assertNull((Object)input1.getLiteral());
                ModelActsCommandTest.assertNull((Object)input1.getValue());
            }
        });
        this.executeTests(cmds);
    }

    public static void buildActs(List<CommandTransformer> cmds) {
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)MetaABMActFactory.eINSTANCE.createARule());
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)3);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)1);
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)2);
                ModelActsCommandTest.assertEquals((String)((AAct)this.rootAct().getRoots().get(1)).getLabel(), (String)"Root Context Rule");
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct().getMembers().get(3), (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)MetaABMActFactory.eINSTANCE.createASet());
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)4);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)2);
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("setTo"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)5);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)2);
                AAct setTo = this.rootAct().findMember("setTo");
                AAct rootContextRule = this.rootAct().findMember(ModelActsCommandTest.getRuleID());
                ModelActsCommandTest.assertNotNull((Object)rootContextRule);
                ModelActsCommandTest.assertNotNull((Object)setTo);
                ModelActsCommandTest.assertTrue((boolean)rootContextRule.getTargets().contains((Object)setTo));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                ModelActsCommandTest.assertTrue((this.rootAct() != null ? 1 : 0) != 0);
                ASchedule createASchedule = MetaABMActFactory.eINSTANCE.createASchedule();
                ModelActsCommandTest.assertEquals((String)createASchedule.getLabel(), null);
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)createASchedule);
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)5);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)2);
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("in"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("setTo"));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getRuleID()));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)6);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)3);
                ASchedule schedule = (ASchedule)this.rootAct().getRoots().get(2);
                ModelActsCommandTest.assertNotNull((Object)schedule.getSelected());
                ModelActsCommandTest.assertNotNull((Object)schedule.getSelected().getAgent());
                ModelActsCommandTest.assertEquals((String)schedule.getSelected().getAgent().getLabel(), (String)"Root Context");
                ModelActsCommandTest.assertEquals((String)schedule.getLabel(), (String)"At 0 Every 0");
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getScheduleID()));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("setTo"));
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct().findMember(ModelActsCommandTest.getScheduleID()), (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)this.rootAct().findMember("setTo"));
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)6);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)3);
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember(ModelActsCommandTest.getScheduleID()));
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("setTo"));
            }

            public void postCondition() {
                this.preCondition();
                AAct setTo = this.rootAct().findMember("setTo");
                AAct schedule = this.rootAct().findMember(ModelActsCommandTest.getScheduleID());
                AAct rootContextRule = this.rootAct().findMember(ModelActsCommandTest.getRuleID());
                ModelActsCommandTest.assertEquals((int)rootContextRule.getTargets().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)schedule.getTargets().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)setTo.getSources().size(), (int)2);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct().findMember(ModelActsCommandTest.getScheduleID()), (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)MetaABMActFactory.eINSTANCE.createAQuery());
            }

            public void preCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)6);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)3);
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("is"));
                AAct schedule = this.rootAct().findMember(ModelActsCommandTest.getScheduleID());
                ModelActsCommandTest.assertEquals((int)schedule.getTargets().size(), (int)1);
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)7);
                ModelActsCommandTest.assertEquals((String)((AAct)this.rootAct().getMembers().get(6)).getID(), (String)"_Unspecified_Query");
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)3);
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("_Unspecified_Query"));
                AAct setTo = this.rootAct().findMember("setTo");
                AAct schedule = this.rootAct().findMember(ModelActsCommandTest.getScheduleID());
                AAct rootContextRule = this.rootAct().findMember(ModelActsCommandTest.getRuleID());
                ModelActsCommandTest.assertEquals((int)rootContextRule.getTargets().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)schedule.getTargets().size(), (int)2);
                ModelActsCommandTest.assertEquals((int)setTo.getSources().size(), (int)2);
            }
        });
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                Command create = AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct().findMember("setTo"), (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)MetaABMActFactory.eINSTANCE.createAEvaluate());
                ModelActsCommandTest.assertTrue((boolean)create.canExecute());
                return create;
            }

            public void preCondition() {
                AAct set = this.rootAct().findMember("setTo");
                ModelActsCommandTest.assertEquals((int)set.getTargets().size(), (int)0);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)7);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)3);
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("_Unspecified_Query"));
            }

            public void postCondition() {
                ModelActsCommandTest.assertEquals((int)this.rootAct().getMembers().size(), (int)8);
                ModelActsCommandTest.assertEquals((int)this.rootAct().getRoots().size(), (int)3);
                AAct set = this.rootAct().findMember("setTo");
                ModelActsCommandTest.assertEquals((int)set.getTargets().size(), (int)1);
                ModelActsCommandTest.assertNotNull((Object)this.rootAct().findMember("_Unspecified_Query"));
            }
        });
    }

    public void testRemoveSetAttribute() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        ModelActsCommandTest.buildActs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                SAttribute attr = (SAttribute)((SAgent)this.model.getAgents().get(0)).getAttributes().get(0);
                ModelActsCommandTest.assertNotNull((Object)attr);
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct().findMember("setTo"), (Object)MetaABMActPackage.Literals.AACCESSOR__ATTRIBUTE, (Object)attr);
            }

            public void preCondition() {
                ASet set = (ASet)this.rootAct().findMember("setTo");
                SAttribute attr = (SAttribute)((SAgent)this.model.getAgents().get(0)).getAttributes().get(0);
                ModelActsCommandTest.assertNull((Object)set.getAttribute());
                ModelActsCommandTest.assertEquals((int)((SAttribute)((SAgent)this.model.getAgents().get(0)).getAttributes().get(0)).getAccessors().size(), (int)0);
                ModelActsCommandTest.assertEquals((int)attr.getAccessors().size(), (int)0);
            }

            public void postCondition() {
                ASet set = (ASet)this.rootAct().findMember("setTo");
                SAttribute attr = (SAttribute)((SAgent)this.model.getAgents().get(0)).getAttributes().get(0);
                ModelActsCommandTest.assertEquals((Object)set.getAttribute(), (Object)attr);
                ModelActsCommandTest.assertTrue((boolean)attr.getAccessors().contains((Object)set));
                ModelActsCommandTest.assertEquals((int)attr.getAccessors().size(), (int)1);
            }
        });
        cmds.add(new CommandTransformer(){
            SAttribute attr;

            public Command getCommand() {
                this.attr = (SAttribute)((SAgent)this.model.getAgents().get(0)).getAttributes().get(0);
                ModelActsCommandTest.assertNotNull((Object)this.attr);
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.model.getAgents().get(0), (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)this.attr);
            }

            public void preCondition() {
                ASet set = (ASet)this.rootAct().findMember("setTo");
                ModelActsCommandTest.assertEquals((Object)set.getAttribute(), (Object)this.attr);
                ModelActsCommandTest.assertEquals((int)((SAgent)this.model.getAgents().get(0)).getAttributes().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)this.attr.getAccessors().size(), (int)1);
            }

            public void postCondition() {
                ASet set = (ASet)this.rootAct().findMember("setTo");
                ModelActsCommandTest.assertEquals((Object)set.getAttribute(), null);
                ModelActsCommandTest.assertEquals((int)((SAgent)this.model.getAgents().get(0)).getAttributes().size(), (int)0);
                ModelActsCommandTest.assertEquals((int)this.attr.getAccessors().size(), (int)0);
            }
        });
    }

    public void testRemoveSetAct() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        ModelActsCommandTest.buildActs(cmds);
        ModelActsCommandTest.addInputs(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                SAttribute attr = (SAttribute)((SAgent)this.model.getAgents().get(0)).getAttributes().get(0);
                ModelActsCommandTest.assertNotNull((Object)attr);
                return AddCommand.create((EditingDomain)this.getDomain(), (Object)this.rootAct().findMember("setTo"), (Object)MetaABMActPackage.Literals.AACCESSOR__ATTRIBUTE, (Object)attr);
            }

            public void preCondition() {
                ASet set = (ASet)this.rootAct().findMember("setTo");
                SAttribute attr = (SAttribute)((SAgent)this.model.getAgents().get(0)).getAttributes().get(0);
                ModelActsCommandTest.assertNull((Object)set.getAttribute());
                ModelActsCommandTest.assertEquals((int)((SAttribute)((SAgent)this.model.getAgents().get(0)).getAttributes().get(0)).getAccessors().size(), (int)0);
                ModelActsCommandTest.assertEquals((int)attr.getAccessors().size(), (int)1);
            }

            public void postCondition() {
                ASet set = (ASet)this.rootAct().findMember("setTo");
                SAttribute attr = (SAttribute)((SAgent)this.model.getAgents().get(0)).getAttributes().get(0);
                ModelActsCommandTest.assertEquals((Object)set.getAttribute(), (Object)attr);
                ModelActsCommandTest.assertTrue((boolean)attr.getAccessors().contains((Object)set));
                ModelActsCommandTest.assertEquals((int)attr.getAccessors().size(), (int)2);
            }
        });
        cmds.add(new CommandTransformer(){
            SAttribute attr;

            public Command getCommand() {
                ASet set = (ASet)this.rootAct().findMember("setTo");
                this.attr = (SAttribute)((SAgent)this.model.getAgents().get(0)).getAttributes().get(0);
                ModelActsCommandTest.assertNotNull((Object)this.attr);
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)set.getSources().get(0), (Object)MetaABMActPackage.Literals.AACT__TARGETS, Collections.singleton(set));
            }

            public void preCondition() {
                ASet set = (ASet)this.rootAct().findMember("setTo");
                ModelActsCommandTest.assertEquals((int)set.getSources().size(), (int)1);
                ModelActsCommandTest.assertEquals((int)this.attr.getAccessors().size(), (int)2);
            }

            public void postCondition() {
                ModelActsCommandTest.assertNull((Object)this.rootAct().findMember("setTo"));
                ModelActsCommandTest.assertEquals((int)this.attr.getAccessors().size(), (int)0);
            }
        });
    }

    public void testSelectChain() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        cmds.add(this.createSelectChain());
        this.executeTests(cmds);
    }

    public void testSelectMove() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        cmds.add(this.createSelectChain());
        cmds.add(this.createSelectTarget());
        cmds.add(this.createSimpleMove());
        this.executeTests(cmds);
    }

    private CommandTransformer createSelectChain() {
        return new CommandTransformer(){

            public Command getCommand() {
                CompoundCommand cmd = new CompoundCommand();
                AAct rule = ModelActsCommandTest.this.createMember(cmd, (AAct)this.rootAct(), (AAct)MetaABMActFactory.eINSTANCE.createARule(), "Rule");
                AAct eval1 = ModelActsCommandTest.this.createTarget(cmd, rule, (AAct)MetaABMActFactory.eINSTANCE.createAEvaluate(), "Eval1");
                AAct select1 = ModelActsCommandTest.this.createTarget(cmd, eval1, (AAct)MetaABMActFactory.eINSTANCE.createASelect(), "Select1");
                ModelActsCommandTest.this.createTarget(cmd, select1, (AAct)MetaABMActFactory.eINSTANCE.createAMove(), "Move");
                ModelActsCommandTest.this.createTarget(cmd, select1, (AAct)MetaABMActFactory.eINSTANCE.createAEvaluate(), "Eval2");
                return cmd;
            }

            public void preCondition() {
            }

            public void postCondition() {
                ASelect rootSelected = (ASelect)this.rootAct().getMembers().get(0);
                ModelActsCommandTest.assertEquals((String)rootSelected.getLabel(), (String)"Rule");
                ModelActsCommandTest.assertEquals((Object)rootSelected.getSelected(), (Object)rootSelected);
                AAct eval1 = (AAct)rootSelected.getTargets().get(0);
                ModelActsCommandTest.assertTrue((boolean)(eval1 instanceof AEvaluate));
                ModelActsCommandTest.assertEquals((Object)eval1.getSelected(), (Object)rootSelected);
                AAct select1 = (AAct)eval1.getTargets().get(0);
                ModelActsCommandTest.assertEquals((String)select1.getID(), (String)"select1");
                ModelActsCommandTest.assertTrue((boolean)(select1 instanceof ASelect));
                ModelActsCommandTest.assertEquals((Object)select1.getSelected(), (Object)rootSelected);
                ModelActsCommandTest.assertNotNull((Object)select1);
                AMove move = (AMove)select1.getTargets().get(0);
                ModelActsCommandTest.assertEquals((Object)move.getSelected(), (Object)rootSelected);
                ModelActsCommandTest.assertEquals((Object)move.getDestination(), (Object)select1);
            }
        };
    }

    private CommandTransformer createSelectTarget() {
        return new CommandTransformer(){

            public Command getCommand() {
                CompoundCommand cmd = new CompoundCommand();
                AAct rule = ModelActsCommandTest.this.createMember(cmd, (AAct)this.rootAct(), (AAct)MetaABMActFactory.eINSTANCE.createARule(), "TargetRule");
                ModelActsCommandTest.this.createTarget(cmd, rule, (AAct)MetaABMActFactory.eINSTANCE.createAEvaluate(), "TargetEval1");
                return cmd;
            }

            public void preCondition() {
            }

            public void postCondition() {
                ASelect rootSelected = (ASelect)this.rootAct().getRoots().get(1);
                ModelActsCommandTest.assertEquals((String)rootSelected.getLabel(), (String)"TargetRule");
                ModelActsCommandTest.assertEquals((Object)rootSelected.getSelected(), (Object)rootSelected);
                AAct eval1 = (AAct)rootSelected.getTargets().get(0);
                ModelActsCommandTest.assertTrue((boolean)(eval1 instanceof AEvaluate));
                ModelActsCommandTest.assertEquals((Object)eval1.getSelected(), (Object)rootSelected);
            }
        };
    }

    private CommandTransformer createSimpleMove() {
        return new CommandTransformer(){

            public Command getCommand() {
                CompoundCommand cmd = new CompoundCommand();
                ASelect rootSelected = (ASelect)this.rootAct().getRoots().get(0);
                AAct eval1 = (AAct)rootSelected.getTargets().get(0);
                AAct selected1 = (AAct)eval1.getTargets().get(0);
                ASelect targetSelected = (ASelect)this.rootAct().getRoots().get(1);
                ModelActsCommandTest.assertNotSame((Object)rootSelected, (Object)targetSelected);
                AAct eval2 = (AAct)selected1.getTargets().get(1);
                ModelActsCommandTest.assertEquals((String)eval2.getLabel(), (String)"Eval2");
                AAct targetEval = (AAct)targetSelected.getTargets().get(0);
                ModelActsCommandTest.assertEquals((String)targetEval.getLabel(), (String)"TargetEval1");
                ModelActsCommandTest.assertEquals((int)targetEval.getTargets().size(), (int)0);
                ModelActsCommandTest.assertTrue((boolean)selected1.getTargets().contains((Object)eval2));
                cmd.append(AddCommand.create((EditingDomain)this.getDomain(), (Object)targetEval, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)eval2));
                cmd.append(RemoveCommand.create((EditingDomain)this.getDomain(), (Object)selected1, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)eval2));
                return cmd;
            }

            public void preCondition() {
                ASelect rootSelected = (ASelect)this.rootAct().getRoots().get(0);
                ASelect targetSelected = (ASelect)this.rootAct().getRoots().get(1);
                AAct eval1 = (AAct)rootSelected.getTargets().get(0);
                AAct selected1 = (AAct)eval1.getTargets().get(0);
                ModelActsCommandTest.assertNotSame((Object)rootSelected, (Object)targetSelected);
                ModelActsCommandTest.assertEquals((int)selected1.getTargets().size(), (int)2);
                AAct eval2 = this.rootAct().findMember("eval2");
                ModelActsCommandTest.assertNotNull((Object)"eval2");
                AAct targetEval = this.rootAct().findMember("targetEval1");
                ModelActsCommandTest.assertFalse((boolean)targetEval.getTargets().contains((Object)eval2));
                AAct orginalSel = this.rootAct().findMember("select1");
                ModelActsCommandTest.assertTrue((boolean)orginalSel.getTargets().contains((Object)eval2));
            }

            public boolean modifies() {
                return true;
            }

            public void postCondition() {
                ASelect rootSelected = (ASelect)this.rootAct().getRoots().get(0);
                ModelActsCommandTest.assertEquals((String)rootSelected.getLabel(), (String)"Rule");
                ModelActsCommandTest.assertEquals((Object)rootSelected.getSelected(), (Object)rootSelected);
                AAct eval1 = (AAct)rootSelected.getTargets().get(0);
                eval1.getTargets().get(0);
                ModelActsCommandTest.assertTrue((boolean)(eval1 instanceof AEvaluate));
                AAct eval2 = this.rootAct().findMember("eval2");
                ModelActsCommandTest.assertNotNull((Object)eval2);
                AAct targetEval = this.rootAct().findMember("targetEval1");
                ModelActsCommandTest.assertTrue((boolean)targetEval.getTargets().contains((Object)eval2));
                AAct orginalSel = this.rootAct().findMember("select1");
                ModelActsCommandTest.assertFalse((boolean)orginalSel.getTargets().contains((Object)eval2));
            }
        };
    }

    private AAct createMember(CompoundCommand cmd, AAct target, AAct created, String label) {
        cmd.appendAndExecute(AddCommand.create((EditingDomain)this.getDomain(), (Object)target, (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)created));
        cmd.appendAndExecute(SetCommand.create((EditingDomain)this.getDomain(), (Object)created, (Object)MetaABMPackage.Literals.IID__LABEL, (Object)label));
        return created;
    }

    private AAct createTarget(CompoundCommand cmd, AAct target, AAct created, String label) {
        cmd.appendAndExecute(AddCommand.create((EditingDomain)this.getDomain(), (Object)target, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)created));
        cmd.appendAndExecute(SetCommand.create((EditingDomain)this.getDomain(), (Object)created, (Object)MetaABMPackage.Literals.IID__LABEL, (Object)label));
        return created;
    }

    protected static String getRuleID() {
        return "rootContextRule";
    }

    protected static String getScheduleID() {
        return "at0Every0";
    }

    protected static String getAgentRuleID() {
        return "rootContextAgentRule";
    }
}

