/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.IVector4f;
import org.eclipse.draw3d.geometry.Math3DVector3f;
import org.eclipse.draw3d.geometry.Vector4f;
import org.eclipse.draw3d.geometry.Vector4fImpl;

public class Math3DVector4f
extends Math3DVector3f {
    public static Vector4f add(IVector4f i_left, IVector4f i_right, Vector4f o_result) {
        if (o_result == null) {
            return new Vector4fImpl(i_left.getX() + i_right.getX(), i_left.getY() + i_right.getY(), i_left.getZ() + i_right.getZ(), i_left.getW() + i_right.getW());
        }
        o_result.set(i_left.getX() + i_right.getX(), i_left.getY() + i_right.getY(), i_left.getZ() + i_right.getZ(), i_left.getW() + i_right.getW());
        return o_result;
    }

    public static Vector4f sub(IVector4f i_left, IVector4f i_right, Vector4f o_result) {
        if (o_result == null) {
            return new Vector4fImpl(i_left.getX() - i_right.getX(), i_left.getY() - i_right.getY(), i_left.getZ() - i_right.getZ(), i_left.getW() - i_right.getW());
        }
        o_result.set(i_left.getX() - i_right.getX(), i_left.getY() - i_right.getY(), i_left.getZ() - i_right.getZ(), i_left.getW() - i_right.getW());
        return o_result;
    }

    public static Vector4f negate(IVector4f i_source, Vector4f o_result) {
        if (o_result == null) {
            return new Vector4fImpl(-i_source.getX(), -i_source.getY(), -i_source.getZ(), -i_source.getW());
        }
        o_result.set(-i_source.getX(), -i_source.getY(), -i_source.getZ(), -i_source.getW());
        return o_result;
    }

    public static Vector4f normalise(IVector4f i_source, Vector4f o_result) {
        float lengthInv = 1.0f / i_source.length();
        return Math3DVector4f.scale(lengthInv, i_source, o_result);
    }

    public static float dot(IVector4f i_left, IVector4f i_right) {
        return i_left.getX() * i_right.getX() + i_left.getY() * i_right.getY() + i_left.getZ() * i_right.getZ() + i_left.getW() * i_right.getW();
    }

    public static float angle(IVector4f i_left, IVector4f i_right) {
        float cosAlpha = Math3DVector4f.dot(i_left, i_right) / (i_left.length() * i_right.length());
        if (cosAlpha <= -1.0f) {
            return (float)Math.PI;
        }
        if (cosAlpha >= 1.0f) {
            return 0.0f;
        }
        return (float)Math.acos(cosAlpha);
    }

    public static Vector4f scale(float scale, IVector4f i_source, Vector4f o_result) {
        if (o_result == null) {
            return new Vector4fImpl(scale * i_source.getX(), scale * i_source.getY(), scale * i_source.getZ(), scale * i_source.getW());
        }
        o_result.set(scale * i_source.getX(), scale * i_source.getY(), scale * i_source.getZ(), scale * i_source.getW());
        return o_result;
    }

    public static Vector4f translate(IVector4f i_source, float x, float y, float z, float w, Vector4f o_result) {
        if (o_result == null) {
            return new Vector4fImpl(x + i_source.getX(), y + i_source.getY(), z + i_source.getZ(), w + i_source.getW());
        }
        o_result.set(x + i_source.getX(), y + i_source.getY(), z + i_source.getZ(), w + i_source.getW());
        return o_result;
    }

    public static Vector4f abs(IVector4f i_source, Vector4f io_result) {
        if (io_result == null) {
            io_result = new Vector4fImpl(Math.abs(i_source.getX()), Math.abs(i_source.getY()), Math.abs(i_source.getZ()), Math.abs(i_source.getW()));
        } else {
            io_result.set(Math.abs(i_source.getX()), Math.abs(i_source.getY()), Math.abs(i_source.getZ()), Math.abs(i_source.getW()));
        }
        return io_result;
    }
}

