/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometryext;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.geometry.BoundingBoxImpl;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector2f;
import org.eclipse.draw3d.geometry.Vector2fImpl;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class SyncedBounds3D {
    public Vector3f m_location3D;
    public Vector2f m_locationDelta = new Vector2fImpl();
    public Vector3f m_size3D;
    public Vector2f m_sizeDelta = new Vector2fImpl();

    public SyncedBounds3D() {
        this.m_location3D = new Vector3fImpl();
        this.m_size3D = new Vector3fImpl();
    }

    public IBoundingBox getBoundingBox(Rectangle i_sourceBounds2D) {
        return new BoundingBoxImpl(this.getLocation3D(i_sourceBounds2D), this.getSize3D(i_sourceBounds2D));
    }

    public IVector3f getLocation3D(Rectangle i_sourceBounds2D) {
        this.m_location3D.setX((float)i_sourceBounds2D.x + this.m_locationDelta.getX());
        this.m_location3D.setY((float)i_sourceBounds2D.y + this.m_locationDelta.getY());
        return this.m_location3D;
    }

    public IVector3f getSize3D(Rectangle i_sourceBounds2D) {
        this.m_size3D.setX((float)i_sourceBounds2D.width + this.m_sizeDelta.getX());
        this.m_size3D.setY((float)i_sourceBounds2D.height + this.m_sizeDelta.getY());
        return this.m_size3D;
    }

    public Rectangle setBounds3D(IVector3f i_position, IVector3f i_size) {
        int x = (int)i_position.getX();
        int y = (int)i_position.getY();
        int width = (int)i_size.getX();
        int height = (int)i_size.getY();
        float xDelta = i_position.getX() - (float)x;
        float yDelta = i_position.getY() - (float)y;
        float z = i_position.getZ();
        this.m_locationDelta.setX(xDelta);
        this.m_locationDelta.setY(yDelta);
        this.m_location3D.setZ(z);
        float widthDelta = i_size.getX() - (float)width;
        float heightDelta = i_size.getY() - (float)height;
        float depth = i_size.getZ();
        this.m_sizeDelta.setX(widthDelta);
        this.m_sizeDelta.setY(heightDelta);
        this.m_size3D.setZ(depth);
        return new Rectangle(x, y, width, height);
    }

    public void setDepth(float i_depth) {
        this.m_size3D.setZ(i_depth);
    }

    public void setZ(float i_z) {
        this.m_location3D.setZ(i_z);
    }

    public String toString() {
        return "SyncedBounds3D [3D location:" + this.m_location3D + ", 3D size:" + this.m_size3D + ", 2D location delta:" + this.m_locationDelta + ", 2D size delta:" + this.m_sizeDelta + "]";
    }
}

