/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.editpolicies;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.LocatorHelper;
import org.eclipse.draw3d.PickingUpdateManager3D;
import org.eclipse.draw3d.XYZAnchor;
import org.eclipse.draw3d.geometry.IHost3D;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Position3DUtil;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.picking.Picker;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.gef.editpolicies.FeedbackHelper;

public class FeedbackHelper3D
extends FeedbackHelper {
    private static final Logger log = Logger.getLogger(FeedbackHelper3D.class.getName());
    protected XYZAnchor m_dummyAnchor = this.createDummyAnchor();
    protected LocatorHelper m_helper;
    protected Picker m_picker;

    protected XYZAnchor createDummyAnchor() {
        return new XYZAnchor(new Vector3fImpl(10.0f, 10.0f, 10.0f));
    }

    public void setAbsoluteFeedbackBounds(IFigure3D i_feedback, Point i_sLocation, Dimension i_sSize) {
        if (i_feedback == null) {
            throw new NullPointerException("i_feedback must not be null");
        }
        Vector3f surfaceRelativeLocation = Draw3DCache.getVector3f();
        Vector3f wSize = Draw3DCache.getVector3f();
        Vector3f rotation = Draw3DCache.getVector3f();
        try {
            Position3D feedbackPosition = i_feedback.getPosition3D();
            ISurface surface = this.m_picker.getCurrentSurface();
            surface.getSurfaceRotation(rotation);
            feedbackPosition.setRotation3D((IVector3f)rotation);
            if (i_sSize != null) {
                wSize.set((float)i_sSize.width, (float)i_sSize.height, 1.0f);
            } else {
                wSize.set(0.0f, 0.0f, 1.0f);
            }
            feedbackPosition.setSize3D((IVector3f)wSize);
            if (i_sLocation != null) {
                surface.getWorldLocation(i_sLocation, surfaceRelativeLocation);
                feedbackPosition.setLocation3D((IVector3f)surfaceRelativeLocation);
            }
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{surfaceRelativeLocation, wSize, rotation});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{surfaceRelativeLocation, wSize, rotation});
    }

    public void updateFeedbackPosition(IFigure3D i_feedback, Point i_surfaceMoveDelta, Dimension i_surfaceSizeDelta) {
        if (i_feedback == null) {
            throw new NullPointerException("i_feedback must not be null");
        }
        Vector3f surfaceRelativeLocation = Draw3DCache.getVector3f();
        Vector3f size = Draw3DCache.getVector3f();
        try {
            ISurface surface = this.m_picker.getCurrentSurface();
            ISurface initialSurface = Figure3DHelper.getAncestor3D((IFigure)this.m_helper.getReference()).getSurface();
            Position3D newPos = this.m_helper.getReferencePosition3D((IFigure)surface.getHost());
            if (i_surfaceMoveDelta != null) {
                surfaceRelativeLocation.set(newPos.getLocation3D());
                surfaceRelativeLocation.translate((float)i_surfaceMoveDelta.x, (float)i_surfaceMoveDelta.y, 0.0f);
                newPos.setLocation3D((IVector3f)surfaceRelativeLocation);
            }
            if (i_surfaceSizeDelta != null) {
                size.set(newPos.getSize3D());
                size.translate((float)i_surfaceSizeDelta.width, (float)i_surfaceSizeDelta.height, 0.0f);
                newPos.setSize3D((IVector3f)size);
            }
            i_feedback.getPosition3D().setPosition((IPosition3D)newPos);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{surfaceRelativeLocation, size});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{surfaceRelativeLocation, size});
    }

    public void updateFeedbackPosition(IFigure3D i_feedback, IVector3f i_newPosition, IVector3f i_rotationDelta3D) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Move to " + i_newPosition + ", Rot " + i_rotationDelta3D);
        }
        if (i_feedback == null) {
            throw new NullPointerException("i_feedback must not be null");
        }
        Position3D rotatedNewPosition = i_feedback.getPosition3D();
        if (i_newPosition != null) {
            rotatedNewPosition.setLocation3D(i_newPosition);
        }
        if (i_rotationDelta3D != null && i_rotationDelta3D != IVector3f.NULLVEC3f) {
            Matrix4f deltaMatrix = Math3D.rotate((IVector3f)i_rotationDelta3D, (IMatrix4f)IMatrix4f.IDENTITY, null);
            Math3D.mul((IMatrix4f)i_feedback.getPosition3D().getAbsoluteRotationMatrix(), (IMatrix4f)deltaMatrix, (Matrix4f)deltaMatrix);
            Vector3f relV = Math3D.rotationMatrixToEulerAngles((IMatrix4f)deltaMatrix, null);
            rotatedNewPosition.setRotation3D((IVector3f)relV);
        }
        i_feedback.getPosition3D().setPosition((IPosition3D)rotatedNewPosition);
    }

    public void setHostFigure(IFigure i_hostFigure) {
        if (i_hostFigure == null) {
            throw new NullPointerException("i_hostFigure must not be null");
        }
        this.m_helper = new LocatorHelper(i_hostFigure);
        UpdateManager updateManager = i_hostFigure.getUpdateManager();
        if (!(updateManager instanceof PickingUpdateManager3D)) {
            throw new IllegalArgumentException("figure's update manager must be instanceof PickingUpdateManager3D, was " + updateManager);
        }
        this.m_picker = ((PickingUpdateManager3D)updateManager).getPicker();
    }

    public void setInitialFeedbackPosition(IFigure3D i_feedback) {
        this.setInitialFeedbackPosition(i_feedback, this.m_picker.getCurrentSurface());
    }

    public void setInitialFeedbackPosition(IFigure3D i_feedback, ISurface surface) {
        ISurface initialSurface = Figure3DHelper.getAncestor3D((IFigure)this.m_helper.getReference()).getSurface();
        Position3D refPosition = this.m_helper.getReferencePosition3D();
        if (surface != initialSurface) {
            Position3D result = Position3DUtil.createRelativePosition((IHost3D)surface.getHost());
            result.setSize3D(refPosition.getSize3D());
            refPosition = result;
        }
        i_feedback.getPosition3D().setPosition((IPosition3D)refPosition);
    }

    public void update(ConnectionAnchor anchor, Point p) {
        if (anchor != null) {
            this.setAnchor(anchor);
        } else {
            ISurface surface = this.m_picker.getCurrentSurface();
            Vector3f w = Draw3DCache.getVector3f();
            try {
                surface.getWorldLocation(p, w);
                this.m_dummyAnchor.setLocation3D((IVector3f)w);
                this.setAnchor((ConnectionAnchor)this.m_dummyAnchor);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{w});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{w});
        }
    }
}

