/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MQTTClientState implements Enumerator
{
    NOT_CONNECTED(0, "NOT_CONNECTED", "Not Connected"),
    CONNECTING(1, "CONNECTING", "Connecting"),
    CONNECTED(2, "CONNECTED", "Connected"),
    FAILED(3, "FAILED", "Failed");

    public static final int NOT_CONNECTED_VALUE = 0;
    public static final int CONNECTING_VALUE = 1;
    public static final int CONNECTED_VALUE = 2;
    public static final int FAILED_VALUE = 3;
    private static final MQTTClientState[] VALUES_ARRAY;
    public static final List<MQTTClientState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MQTTClientState[]{NOT_CONNECTED, CONNECTING, CONNECTED, FAILED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MQTTClientState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MQTTClientState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MQTTClientState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MQTTClientState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MQTTClientState get(int value) {
        switch (value) {
            case 0: {
                return NOT_CONNECTED;
            }
            case 1: {
                return CONNECTING;
            }
            case 2: {
                return CONNECTED;
            }
            case 3: {
                return FAILED;
            }
        }
        return null;
    }

    private MQTTClientState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

