/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MQTTTopicState implements Enumerator
{
    NOT_INITIALIZED(0, "NOT_INITIALIZED", "Not Initialized"),
    INITIALIZING(1, "INITIALIZING", "Initializing"),
    READY(2, "READY", "Ready"),
    STOPPED(3, "STOPPED", "Stopped"),
    FAILED(4, "FAILED", "Failed"),
    STALLED(5, "STALLED", "Stalled");

    public static final int NOT_INITIALIZED_VALUE = 0;
    public static final int INITIALIZING_VALUE = 1;
    public static final int READY_VALUE = 2;
    public static final int STOPPED_VALUE = 3;
    public static final int FAILED_VALUE = 4;
    public static final int STALLED_VALUE = 5;
    private static final MQTTTopicState[] VALUES_ARRAY;
    public static final List<MQTTTopicState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MQTTTopicState[]{NOT_INITIALIZED, INITIALIZING, READY, STOPPED, FAILED, STALLED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MQTTTopicState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MQTTTopicState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MQTTTopicState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MQTTTopicState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MQTTTopicState get(int value) {
        switch (value) {
            case 0: {
                return NOT_INITIALIZED;
            }
            case 1: {
                return INITIALIZING;
            }
            case 2: {
                return READY;
            }
            case 3: {
                return STOPPED;
            }
            case 4: {
                return FAILED;
            }
            case 5: {
                return STALLED;
            }
        }
        return null;
    }

    private MQTTTopicState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

