/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.callbacks;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class CompositeMqttCallback
implements MqttCallback {
    private List<MqttCallback> callbacks = new CopyOnWriteArrayList<MqttCallback>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectionLost(Throwable arg0) {
        List<MqttCallback> list = this.callbacks;
        synchronized (list) {
            for (MqttCallback callback : this.callbacks) {
                try {
                    callback.connectionLost(arg0);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deliveryComplete(IMqttDeliveryToken token) {
        List<MqttCallback> list = this.callbacks;
        synchronized (list) {
            for (MqttCallback callback : this.callbacks) {
                try {
                    callback.deliveryComplete(token);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void messageArrived(String topicName, MqttMessage message) throws Exception {
        List<MqttCallback> list = this.callbacks;
        synchronized (list) {
            for (MqttCallback callback : this.callbacks) {
                try {
                    callback.messageArrived(topicName, message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addCallback(MqttCallback callback) {
        List<MqttCallback> list = this.callbacks;
        synchronized (list) {
            if (!this.callbacks.contains(callback)) {
                this.callbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeCallback(MqttCallback callback) {
        List<MqttCallback> list = this.callbacks;
        synchronized (list) {
            if (this.callbacks.contains(callback)) {
                this.callbacks.remove(callback);
            }
        }
    }
}

