/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.sensors.fov.impl.RectangularFrustrumFieldOfViewSamplingShapeImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class RectangularFrustrumFieldOfViewSamplingShapeCustomImpl<PolygonType extends CartesianPolygon>
extends RectangularFrustrumFieldOfViewSamplingShapeImpl<PolygonType> {
    private static Point3d origin = new Point3d();

    @Override
    public boolean isPolygonInside(PolygonType polygon) {
        if (this.isInside(polygon.getCentroid())) {
            return true;
        }
        for (CartesianPositionCoordinates point : polygon.getVertices()) {
            if (!this.isInside(point)) continue;
            return true;
        }
        Matrix4d matrix = new Matrix4d(this.getTransform().asMatrix4d());
        matrix.invert();
        PolygonType transformedPolygon = this.createPolygonInFOVFrame(polygon);
        Vector3d[][] edges = this.getFOVEdges();
        int i = 0;
        while (i < edges.length) {
            Vector3d u = edges[i][0];
            Vector3d v = edges[i][1];
            if (Geometry3DUtilities.getLineAndPolygonIntersectionPoint((Vector3d)u, (Vector3d)v, transformedPolygon) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private PolygonType createPolygonInFOVFrame(PolygonType polygon) {
        CartesianPolygon newPolygon = (CartesianPolygon)EcoreUtil.copy(polygon);
        newPolygon.getVertices().clear();
        Matrix4d matrix = new Matrix4d(this.getTransform().asMatrix4d());
        matrix.invert();
        for (CartesianPositionCoordinates p : polygon.getVertices()) {
            Point3d point3d = new Point3d();
            matrix.transform(p.asPoint3d(), point3d);
            CartesianPositionCoordinates transformedP = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point3d.x, point3d.y, point3d.z);
            newPolygon.getVertices().add((Object)transformedP);
        }
        return (PolygonType)newPolygon;
    }

    private Vector3d[][] getFOVEdges() {
        Vector3d[][] edges = new Vector3d[4][2];
        double azimuth = this.getRectangularFrustrumFieldOfView().getHorizontalFieldOfViewAngle() / 2.0;
        double elevation = this.getRectangularFrustrumFieldOfView().getVerticalFieldOfViewAngle() / 2.0;
        double x = Math.sin(elevation);
        double y = Math.cos(elevation) * Math.sin(azimuth);
        double z = Math.cos(elevation) * Math.cos(azimuth);
        double xShort = x * this.getRectangularFrustrumFieldOfView().getRange().getMinimumDistance();
        double yShort = y * this.getRectangularFrustrumFieldOfView().getRange().getMinimumDistance();
        double zShort = z * this.getRectangularFrustrumFieldOfView().getRange().getMinimumDistance();
        double xLong = x * this.getRectangularFrustrumFieldOfView().getRange().getMaximumDistance();
        double yLong = y * this.getRectangularFrustrumFieldOfView().getRange().getMaximumDistance();
        double zLong = z * this.getRectangularFrustrumFieldOfView().getRange().getMaximumDistance();
        edges[0][0] = new Vector3d(xShort, yShort, zShort);
        edges[0][1] = new Vector3d(xLong, yLong, zLong);
        edges[1][0] = new Vector3d(-xShort, yShort, zShort);
        edges[1][1] = new Vector3d(-xLong, yLong, zLong);
        edges[2][0] = new Vector3d(-xShort, -yShort, zShort);
        edges[2][1] = new Vector3d(-xLong, -yLong, zLong);
        edges[3][0] = new Vector3d(xShort, -yShort, zShort);
        edges[3][1] = new Vector3d(xLong, -yLong, zLong);
        return edges;
    }

    @Override
    public boolean isInside(CartesianPositionCoordinates point) {
        double elevation;
        double azimuth;
        boolean isInside = false;
        Matrix4d matrix = new Matrix4d(this.getTransform().asMatrix4d());
        matrix.invert();
        Point3d p = new Point3d();
        matrix.transform(point.asPoint3d(), p);
        double distance = p.distance(origin);
        if (this.getRectangularFrustrumFieldOfView().getRange().isWithinRange(distance) && (azimuth = Math.abs(Math.atan2(p.y, p.z))) <= this.getRectangularFrustrumFieldOfView().getHorizontalFieldOfViewAngle() / 2.0 && (elevation = Math.abs(Math.atan2(p.x, p.z))) <= this.getRectangularFrustrumFieldOfView().getVerticalFieldOfViewAngle() / 2.0) {
            isInside = true;
        }
        return isInside;
    }
}

