/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.wizards;

import org.eclipse.apogy.addons.sensors.imaging.camera.GainFilter;
import org.eclipse.apogy.addons.sensors.imaging.camera.composites.GainFilterComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GainFilterWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.sensors.imaging.camera.wizards.GainFilterWizardPage";
    private final GainFilter gainFilter;
    private GainFilterComposite gainFilterComposite;
    private DataBindingContext m_bindingContext;

    public GainFilterWizardPage(GainFilter gainFilter) {
        super(WIZARD_PAGE_ID);
        this.gainFilter = gainFilter;
        this.setTitle("Gain Filter.");
        this.setDescription("Select filter settings.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.gainFilterComposite = new GainFilterComposite(top, 0){

            @Override
            protected void newGainSelected(double contrast) {
                GainFilterWizardPage.this.validate();
            }

            @Override
            protected void newBiasSelected(double brightness) {
                GainFilterWizardPage.this.validate();
            }
        };
        this.gainFilterComposite.setLayoutData(new GridData(4, 4, true, true));
        this.gainFilterComposite.setGainFilter(this.gainFilter);
        this.setControl((Control)top);
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (GainFilterWizardPage.this.m_bindingContext != null) {
                    GainFilterWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.gainFilter.getGain() < 0.0) {
            this.setErrorMessage("Invalid gain specified ! Must be equal or greater than zero.");
        }
        if (this.gainFilter.getBias() < 0.0) {
            this.setErrorMessage("Invalid bias specified ! Must be equal or greater than zero.");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

