/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose.impl;

import java.io.IOException;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.sensors.pose.impl.PoseSensorImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianOrientationCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Pose;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoseSensorCustomImpl
extends PoseSensorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(PoseSensorImpl.class);
    private Adapter positionAdapter = null;
    private Adapter orientationAdapter = null;
    private Pose pose;

    protected PoseSensorCustomImpl() {
        this.eAdapters().add((Object)this.getPositionAdapter());
        this.eAdapters().add((Object)this.getOrientationAdapter());
    }

    @Override
    public CartesianPositionCoordinates getPositionCoordinates() {
        if (this.positionCoordinates == null) {
            this.positionCoordinates = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates();
        }
        return this.positionCoordinates;
    }

    @Override
    public CartesianOrientationCoordinates getOrientationCoordinates() {
        if (this.orientationCoordinates == null) {
            this.orientationCoordinates = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianOrientationCoordinates();
        }
        return this.orientationCoordinates;
    }

    @Override
    public Pose getPose() {
        if (this.pose == null) {
            this.pose = ApogyCommonGeometryData3DFactory.eINSTANCE.createPose();
            if (!this.eAdapters().contains((Object)this.getPositionAdapter())) {
                this.eAdapters().add((Object)this.getPositionAdapter());
            }
            if (!this.eAdapters().contains((Object)this.getOrientationAdapter())) {
                this.eAdapters().add((Object)this.getOrientationAdapter());
            }
        }
        this.logPose();
        return this.pose;
    }

    private void logPose() {
        if (this.getDataLogger() != null && this.pose != null) {
            try {
                this.getDataLogger().logPose(this.pose);
            }
            catch (IOException e) {
                Logger.error("Error while logging the data: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public CartesianOrientationCoordinates extractOrientationFromMatrix(Matrix3x3 matrix) {
        Vector3d rotation = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)matrix.asMatrix3d());
        CartesianOrientationCoordinates orientation = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianOrientationCoordinates(rotation.x, rotation.y, rotation.z);
        return orientation;
    }

    private Adapter getPositionAdapter() {
        if (this.positionAdapter == null) {
            this.positionAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(TransformNode.class) == 5) {
                        Tuple3d newPose = (Tuple3d)msg.getNewValue();
                        PoseSensorCustomImpl.this.getPositionCoordinates().setX(newPose.getX());
                        PoseSensorCustomImpl.this.getPositionCoordinates().setY(newPose.getY());
                        PoseSensorCustomImpl.this.getPositionCoordinates().setZ(newPose.getZ());
                        PoseSensorCustomImpl.this.getPose().setX(newPose.getX());
                        PoseSensorCustomImpl.this.getPose().setY(newPose.getY());
                        PoseSensorCustomImpl.this.getPose().setZ(newPose.getZ());
                    }
                }
            };
        }
        return this.positionAdapter;
    }

    private Adapter getOrientationAdapter() {
        if (this.orientationAdapter == null) {
            this.orientationAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(TransformNode.class) == 6) {
                        CartesianOrientationCoordinates newOrientation = PoseSensorCustomImpl.this.extractOrientationFromMatrix((Matrix3x3)msg.getNewValue());
                        PoseSensorCustomImpl.this.getOrientationCoordinates().setXRotation(newOrientation.getXRotation());
                        PoseSensorCustomImpl.this.getOrientationCoordinates().setYRotation(newOrientation.getYRotation());
                        PoseSensorCustomImpl.this.getOrientationCoordinates().setZRotation(newOrientation.getZRotation());
                        PoseSensorCustomImpl.this.getPose().setXRotation(newOrientation.getXRotation());
                        PoseSensorCustomImpl.this.getPose().setYRotation(newOrientation.getYRotation());
                        PoseSensorCustomImpl.this.getPose().setZRotation(newOrientation.getZRotation());
                    }
                }
            };
        }
        return this.orientationAdapter;
    }
}

