/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose.impl;

import org.eclipse.apogy.addons.sensors.pose.impl.SimulatedPositionSensorImpl;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatedPositionSensorCustomImpl
extends SimulatedPositionSensorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SimulatedPositionSensorImpl.class);
    private final UIJob updatePositionJob = null;

    protected SimulatedPositionSensorCustomImpl() {
        this.initialize();
    }

    private void initialize() {
        if (this.getPosition() == null) {
            this.setPosition(ApogyCommonMathFactory.eINSTANCE.createTuple3d());
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Tuple3d oldPosition = SimulatedPositionSensorCustomImpl.this.getPosition();
                            Tuple3d newPosition = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
                            newPosition.setX(oldPosition.getX() + SimulatedPositionSensorCustomImpl.this.getXVelocity() * SimulatedPositionSensorCustomImpl.this.getUpdatePeriod());
                            newPosition.setY(oldPosition.getY() + SimulatedPositionSensorCustomImpl.this.getYVelocity() * SimulatedPositionSensorCustomImpl.this.getUpdatePeriod());
                            newPosition.setZ(oldPosition.getZ() + SimulatedPositionSensorCustomImpl.this.getZVelocity() * SimulatedPositionSensorCustomImpl.this.getUpdatePeriod());
                            SimulatedPositionSensorCustomImpl.this.setPosition(newPosition);
                            long delay = Math.round(SimulatedPositionSensorCustomImpl.this.getUpdatePeriod() * 1000.0);
                            Thread.sleep(delay);
                        }
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
    }

    protected void finalize() throws Throwable {
        if (this.updatePositionJob != null) {
            this.updatePositionJob.cancel();
        }
        super.finalize();
    }
}

