/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.range.impl;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.PickRay;
import javax.media.j3d.PointArray;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.sensors.SensorStatus;
import org.eclipse.apogy.addons.sensors.range.RayData;
import org.eclipse.apogy.addons.sensors.range.impl.RangeScannerSimulatorImpl;
import org.eclipse.apogy.common.geometry.data25d.ApogyCommonGeometryData25DFactory;
import org.eclipse.apogy.common.geometry.data25d.Coordinates25D;
import org.eclipse.apogy.common.geometry.data25d.VolumetricCoordinatesSet25D;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangeScannerSimulatorCustomImpl<InputType>
extends RangeScannerSimulatorImpl<InputType> {
    private static final Logger Logger = LoggerFactory.getLogger(RangeScannerSimulatorImpl.class);

    @Override
    public abstract CartesianTriangularMesh getCroppedMesh();

    @Override
    public abstract List<RayData> getSimulatedRays();

    @Override
    public VolumetricCoordinatesSet25D process(InputType input) throws Exception {
        if (this.getOutput() == null) {
            this.setOutput(ApogyCommonGeometryData25DFactory.eINSTANCE.createVolumetricCoordinatesSet25D());
        }
        if (this.getStatus() == SensorStatus.READY) {
            this.setInput(input);
            this.getOutput().getPoints().clear();
            try {
                this.acquireData();
                return this.getOutput();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void acquireData() throws Exception {
        if (this.getMeshNode() == null) {
            throw new Exception("The mesh node is not set !");
        }
        Matrix4d scannerToMeshTransform = ApogyCommonTopologyFacade.INSTANCE.expressInFrame((Node)this, this.getMeshNode());
        Date start = new Date();
        CartesianTriangularMesh croppedMesh = this.getCroppedMesh();
        Date end = new Date();
        this.setTimeCroppingMesh(end.getTime() - start.getTime());
        Logger.info("Cropped mesh contains " + croppedMesh.getPolygons().size() + " polygons and was created in " + (double)this.getTimeCroppingMesh() / 1000.0 + " seconds.");
        Shape3D meshShape3D = this.getShape3D(croppedMesh);
        if (meshShape3D != null) {
            start = new Date();
            List<RayData> rays = this.getSimulatedRays();
            end = new Date();
            this.setTimeGettingSimulatedRays(end.getTime() - start.getTime());
            Logger.info("Simulated rays contain " + rays.size() + " entries and were generated in " + (double)this.getTimeGettingSimulatedRays() / 1000.0 + " seconds.");
            start = new Date();
            List<Coordinates25D> returns = this.getSimulatedReturns(meshShape3D, scannerToMeshTransform, rays);
            end = new Date();
            this.setTimeFindingIntersections(end.getTime() - start.getTime());
            this.getOutput().getPoints().addAll(returns);
        } else {
            this.getOutput().getPoints().clear();
        }
    }

    @Override
    public abstract RayData applyOrientationNoise(RayData var1);

    @Override
    public abstract double applyRangeNoise(double var1, RayData var3, RayData var4);

    @Override
    public abstract Coordinates25D createCoordinates25D(RayData var1, double var2);

    protected Shape3D getShape3D(CartesianTriangularMesh mesh) {
        if (mesh.getPoints().size() > 0) {
            PointArray meshData = null;
            if (mesh.getPolygons().size() == 0) {
                meshData = new PointArray(mesh.getPoints().size(), 1);
                int pointId = 0;
                for (CartesianPositionCoordinates point : mesh.getPoints()) {
                    Point3d coordinates = point.asPoint3d();
                    meshData.setCoordinate(pointId, coordinates);
                    ++pointId;
                }
            } else {
                meshData = new TriangleArray(mesh.getPolygons().size() * 3, 3);
                int triangleId = 0;
                for (CartesianTriangle triangle : mesh.getPolygons()) {
                    int i = 0;
                    while (i < 3) {
                        Point3d point = ((CartesianPositionCoordinates)triangle.getVertices().get(i)).asPoint3d();
                        meshData.setCoordinate(triangleId, point);
                        ++triangleId;
                        ++i;
                    }
                }
                NormalGenerator normalGenerator = new NormalGenerator();
                GeometryInfo geometryInfo = new GeometryInfo((GeometryArray)meshData);
                normalGenerator.generateNormals(geometryInfo);
                meshData = geometryInfo.getGeometryArray();
            }
            return new Shape3D((Geometry)meshData);
        }
        return null;
    }

    protected List<Coordinates25D> getSimulatedReturns(Shape3D meshShape3D, Matrix4d scannerToMeshTransform, List<RayData> rays) {
        ArrayList<Coordinates25D> returns = new ArrayList<Coordinates25D>();
        PickRay pickRay = new PickRay();
        SceneGraphPath sceneGraphPath = new SceneGraphPath();
        double[] distance = new double[1];
        for (RayData rayData : rays) {
            Vector3d direction;
            Point3d origin;
            RayData noisyRayData = null;
            if (this.isNoiseEnabled()) {
                noisyRayData = this.applyOrientationNoise(rayData);
                pickRay.set(noisyRayData.getOrigin(), noisyRayData.getDirection());
                origin = new Point3d(noisyRayData.getOrigin());
                scannerToMeshTransform.transform(origin);
                direction = new Vector3d(noisyRayData.getDirection());
                scannerToMeshTransform.transform(direction);
                pickRay.set(origin, direction);
            } else {
                origin = new Point3d(rayData.getOrigin());
                scannerToMeshTransform.transform(origin);
                direction = new Vector3d(rayData.getDirection());
                scannerToMeshTransform.transform(direction);
                pickRay.set(origin, direction);
            }
            boolean intersects = meshShape3D.intersect(sceneGraphPath, pickRay, distance);
            if (!intersects) {
                distance[0] = Double.NaN;
            } else if (this.isNoiseEnabled()) {
                distance[0] = this.applyRangeNoise(distance[0], rayData, noisyRayData);
            }
            Coordinates25D coords = this.createCoordinates25D(rayData, distance[0]);
            if (coords == null) continue;
            returns.add(this.createCoordinates25D(rayData, distance[0]));
        }
        return returns;
    }
}

