/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.composites;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.vehicle.ui.composites.AttitudeIndicatorSettingComposite;
import org.eclipse.apogy.addons.vehicle.ui.utils.ImageUtils;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.PoseProvider;
import org.eclipse.apogy.core.ui.composites.ApogySystemApiAdapterBasedComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttitudeIndicatorComposite
extends ApogySystemApiAdapterBasedComposite {
    public static final String DEGREE_STRING = "\u00b0";
    public static final int MAX_ROLL = 60;
    public static final int ROLL_INCREMENT = 10;
    private ApogySystemApiAdapter apogySystemApiAdapter;
    private Adapter poseAdapter;
    private boolean busy = false;
    private Label label;
    private Image currentImage = null;
    private int width = 300;
    private int height = 300;
    private final Color sky = new Color(0, 0, 255);
    private final Color ground = new Color(150, 75, 0);
    private final double pitchAngleIncrement = 10.0;
    private double alarmMinPitch = Math.toRadians(-20.0);
    private double alarmMaxPitch = Math.toRadians(20.0);
    private double warningMinPitch = Math.toRadians(-10.0);
    private double warningMaxPitch = Math.toRadians(10.0);
    private double alarmMinRoll = Math.toRadians(-20.0);
    private double alarmMaxRoll = Math.toRadians(20.0);
    private double warningMinRoll = Math.toRadians(-10.0);
    private double warningMaxRoll = Math.toRadians(10.0);
    public static int PITCH_UP_POSITIVE = 0;
    public static int PITCH_UP_NEGATIVE = 1;
    private int pitchOrientation = PITCH_UP_NEGATIVE;
    public static int ROLL_CW_POSITIVE = 0;
    public static int ROLL_CW_NEGATIVE = 1;
    private int rollOrientation = ROLL_CW_POSITIVE;
    private double pitch = Math.toRadians(0.0);
    private double roll = Math.toRadians(0.0);
    private Text txtPitch;
    private Text txtRoll;
    private Button btnSettings;

    public AttitudeIndicatorComposite(Composite parent, int style) {
        this(parent, style, PITCH_UP_NEGATIVE, ROLL_CW_POSITIVE, 300, 300);
    }

    public AttitudeIndicatorComposite(Composite parent, int style, int indicatorWidth, int indicatorHeight) {
        this(parent, style, PITCH_UP_NEGATIVE, ROLL_CW_POSITIVE, indicatorWidth, indicatorHeight);
    }

    public AttitudeIndicatorComposite(Composite parent, int style, int pitchOrientation, int rollOrientation, int indicatorWidth, int indicatorHeight) {
        super(parent, style);
        this.pitchOrientation = pitchOrientation;
        this.rollOrientation = rollOrientation;
        this.width = indicatorWidth;
        this.height = indicatorHeight;
        this.setLayout((Layout)new GridLayout(2, true));
        Composite top = new Composite((Composite)this, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        top.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.label = new Label(top, 0);
        GridData gd_label = new GridData(0x1000000, 128, true, true, 1, 1);
        gd_label.minimumHeight = indicatorHeight;
        gd_label.heightHint = indicatorHeight;
        gd_label.widthHint = indicatorWidth;
        gd_label.minimumWidth = indicatorWidth;
        this.label.setLayoutData((Object)gd_label);
        new Label((Composite)this, 0);
        Composite bottom = new Composite((Composite)this, 0);
        bottom.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        bottom.setLayout((Layout)new GridLayout(5, false));
        Label lblPitchdeg = new Label(bottom, 0);
        lblPitchdeg.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPitchdeg.setText("Pitch (\u00b0):");
        this.txtPitch = new Text(bottom, 2048);
        this.txtPitch.setEditable(false);
        GridData gd_txtPitch = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtPitch.widthHint = 70;
        gd_txtPitch.minimumWidth = 70;
        this.txtPitch.setLayoutData((Object)gd_txtPitch);
        Label lblRolldeg = new Label(bottom, 0);
        lblRolldeg.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblRolldeg.setText("Roll (\u00b0):");
        this.txtRoll = new Text(bottom, 2048);
        this.txtRoll.setEditable(false);
        GridData gd_txtRoll = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtRoll.widthHint = 70;
        gd_txtRoll.minimumWidth = 70;
        this.txtRoll.setLayoutData((Object)gd_txtRoll);
        this.btnSettings = new Button(bottom, 0);
        this.btnSettings.setText("Settings...");
        this.btnSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                Dialog dialog = new Dialog(shell){
                    AttitudeIndicatorSettingComposite settings;
                    {
                        this.settings = null;
                    }

                    protected Control createDialogArea(Composite parent) {
                        Composite area = (Composite)super.createDialogArea(parent);
                        this.settings = new AttitudeIndicatorSettingComposite(area, 0, AttitudeIndicatorComposite.this);
                        return area;
                    }

                    protected void configureShell(Shell newShell) {
                        super.configureShell(newShell);
                        newShell.setText("Attitude Indicator Settings.");
                    }

                    protected void buttonPressed(int buttonId) {
                        if (buttonId == 0) {
                            this.settings.applySettings();
                        }
                        super.buttonPressed(buttonId);
                    }
                };
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AttitudeIndicatorComposite.this.apogySystemApiAdapter != null) {
                    AttitudeIndicatorComposite.this.apogySystemApiAdapter.eAdapters().remove((Object)AttitudeIndicatorComposite.this.getPoseAdapter());
                }
            }
        });
    }

    protected void apogySystemApiAdapterChanged(ApogySystemApiAdapter oldApogySystemApiAdapter, ApogySystemApiAdapter newApogySystemApiAdapter) {
        if (oldApogySystemApiAdapter != null) {
            oldApogySystemApiAdapter.eAdapters().remove((Object)this.getPoseAdapter());
        }
        if (newApogySystemApiAdapter != null) {
            newApogySystemApiAdapter.eAdapters().add((Object)this.getPoseAdapter());
        }
        this.apogySystemApiAdapter = newApogySystemApiAdapter;
        this.forceUpdate();
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public void setRoll(double roll) {
        this.roll = roll;
    }

    public void setAttitude(double pitch, double roll) {
        this.pitch = pitch;
        this.roll = roll;
        this.forceUpdate();
    }

    public void setPitchAlarmValues(double alarmMinPitch, double alarmMaxPitch) {
        this.alarmMinPitch = alarmMinPitch;
        this.alarmMaxPitch = alarmMaxPitch;
        this.forceUpdate();
    }

    public double getPitchAlarmMinLimit() {
        return this.alarmMinPitch;
    }

    public double getPitchAlarmMaxLimit() {
        return this.alarmMaxPitch;
    }

    public void setPitchWarningValues(double warningMinPitch, double warningMaxPitch) {
        this.warningMinPitch = warningMinPitch;
        this.warningMaxPitch = warningMaxPitch;
        this.forceUpdate();
    }

    public double getPitchWarningMinLimit() {
        return this.warningMinPitch;
    }

    public double getPitchWarningMaxLimit() {
        return this.warningMaxPitch;
    }

    public void setRollAlarmValues(double alarmMinRoll, double alarmMaxRoll) {
        this.alarmMinRoll = alarmMinRoll;
        this.alarmMaxRoll = alarmMaxRoll;
        this.forceUpdate();
    }

    public double getRollAlarmMinLimit() {
        return this.alarmMinRoll;
    }

    public double getRollAlarmMaxLimit() {
        return this.alarmMaxRoll;
    }

    public void setRollWarningValues(double warningMinRoll, double warningMaxRoll) {
        this.warningMinRoll = warningMinRoll;
        this.warningMaxRoll = warningMaxRoll;
        this.forceUpdate();
    }

    public double getRollWarningMinLimit() {
        return this.warningMinRoll;
    }

    public double getRollWarningMaxLimit() {
        return this.warningMaxRoll;
    }

    private void forceUpdate() {
        if (!this.busy && !this.isDisposed()) {
            this.busy = true;
            Job job = new Job("Attitude Indicator Update"){

                protected IStatus run(IProgressMonitor monitor) {
                    final Image image = AttitudeIndicatorComposite.this.getImage();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!AttitudeIndicatorComposite.this.label.isDisposed()) {
                                AttitudeIndicatorComposite.this.label.setImage(image);
                                AttitudeIndicatorComposite.this.txtRoll.setText(AttitudeIndicatorComposite.this.formatAngle(Math.toDegrees(AttitudeIndicatorComposite.this.roll), 4));
                                AttitudeIndicatorComposite.this.txtRoll.setBackground(AttitudeIndicatorComposite.this.getRollColor(AttitudeIndicatorComposite.this.roll));
                                AttitudeIndicatorComposite.this.txtPitch.setText(AttitudeIndicatorComposite.this.formatAngle(Math.toDegrees(AttitudeIndicatorComposite.this.pitch), 4));
                                AttitudeIndicatorComposite.this.txtPitch.setBackground(AttitudeIndicatorComposite.this.getPitchColor(AttitudeIndicatorComposite.this.pitch));
                            }
                            AttitudeIndicatorComposite.this.busy = false;
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    protected void updatePose() {
        Matrix4x4 pose = ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4();
        if (this.getApogySystemApiAdapter() != null && (pose = this.getApogySystemApiAdapter().getPoseTransform()) == null) {
            pose = ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4();
        }
        Vector3d xAxis = new Vector3d(1.0, 0.0, 0.0);
        Vector3d yAxis = new Vector3d(0.0, 1.0, 0.0);
        Vector3d zAxis = new Vector3d(0.0, 0.0, 1.0);
        Matrix4d poseMatrix = pose.asMatrix4d();
        Matrix3d rotationMatrix = new Matrix3d();
        poseMatrix.get(rotationMatrix);
        rotationMatrix.transform((Tuple3d)xAxis);
        rotationMatrix.transform((Tuple3d)yAxis);
        double pitch = -(1.5707963267948966 - zAxis.angle(xAxis));
        double roll = 1.5707963267948966 - zAxis.angle(yAxis);
        this.setAttitude(pitch, roll);
    }

    protected Adapter getPoseAdapter() {
        if (this.poseAdapter == null) {
            this.poseAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof PoseProvider) {
                        int featureID = msg.getFeatureID(PoseProvider.class);
                        switch (featureID) {
                            case 0: {
                                if (!(msg.getNewValue() instanceof Matrix4x4)) break;
                                AttitudeIndicatorComposite.this.updatePose();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.poseAdapter;
    }

    private int getHorizontalCenter() {
        return Math.round((float)this.width / 2.0f);
    }

    private int getVerticalCenter() {
        return Math.round((float)this.height / 2.0f);
    }

    private int getPitchLineIntervalPixel() {
        return Math.round((float)this.getRadius() / 3.7f);
    }

    private int getRadius() {
        return Math.round((float)this.width / 2.0f * 0.6f);
    }

    private Image getImage() {
        int radius;
        int vehiculeWidth = radius = this.getRadius();
        Image horizonImg = new Image((Device)this.getDisplay(), ImageUtils.convertToSWT(this.drawHorizon(this.width, this.height, this.pitch, this.roll)));
        Image pitchImg = new Image((Device)this.getDisplay(), ImageUtils.convertToSWT(this.drawPitchOverlay(this.width, this.height, radius, this.pitch, this.roll)));
        Image vehiculeImg = new Image((Device)this.getDisplay(), ImageUtils.convertToSWT(this.drawVehicule(this.width, this.height, vehiculeWidth, this.pitch, this.roll)));
        Image foregroundImg = new Image((Device)this.getDisplay(), ImageUtils.convertToSWT(this.drawForeground(this.width, this.height, radius, this.pitch, this.roll)));
        Image img1 = ImageUtils.applyOverlay(horizonImg, pitchImg);
        horizonImg.dispose();
        pitchImg.dispose();
        Image img2 = ImageUtils.applyOverlay(img1, vehiculeImg);
        img1.dispose();
        vehiculeImg.dispose();
        Image img3 = ImageUtils.applyOverlay(img2, foregroundImg);
        img2.dispose();
        foregroundImg.dispose();
        if (this.currentImage != null && !this.currentImage.isDisposed()) {
            this.currentImage.dispose();
        }
        this.currentImage = img3;
        return this.currentImage;
    }

    private BufferedImage drawVehicule(int width, int height, int vehiculeWidth, double pitch, double roll) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D graphics = img.createGraphics();
        graphics.setTransform(new AffineTransform());
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x1 = this.getHorizontalCenter() - Math.round((float)vehiculeWidth / 2.0f);
        int x2 = this.getHorizontalCenter() + Math.round((float)vehiculeWidth / 2.0f);
        graphics.setTransform(new AffineTransform());
        graphics.setColor(Color.BLACK);
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.drawLine(x1, this.getVerticalCenter() + 1, x2, this.getVerticalCenter() + 1);
        graphics.drawLine(this.getHorizontalCenter(), this.getVerticalCenter() - 10, this.getHorizontalCenter(), this.getVerticalCenter() + 10);
        graphics.dispose();
        return img;
    }

    private BufferedImage drawHorizon(int width, int height, double pitch, double roll) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D graphics = img.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setTransform(new AffineTransform());
        graphics.setColor(this.sky);
        graphics.fillRect(0, 0, width, height);
        AffineTransform r = new AffineTransform();
        r.translate(this.getHorizontalCenter(), this.getVerticalCenter());
        if (this.rollOrientation == ROLL_CW_POSITIVE) {
            r.rotate(-roll);
        } else {
            r.rotate(roll);
        }
        AffineTransform t = new AffineTransform();
        t.translate(-width, 0.0);
        r.concatenate(t);
        graphics.setTransform(r);
        graphics.setColor(this.getHorizonColor(pitch, roll));
        int pitchInducedDelta = (int)Math.round(pitch / Math.toRadians(10.0) * (double)this.getPitchLineIntervalPixel());
        if (this.pitchOrientation == PITCH_UP_POSITIVE) {
            graphics.fillRect(0, pitchInducedDelta, 4 * width, 2 * height);
        } else {
            graphics.fillRect(0, -pitchInducedDelta, 4 * width, 2 * height);
        }
        graphics.dispose();
        return img;
    }

    private BufferedImage drawPitchOverlay(int width, int height, int radius, double pitch, double roll) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D graphics = img.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DecimalFormat decimalFormat = new DecimalFormat("###0");
        int textWidth = graphics.getFontMetrics().stringWidth("-10");
        int textHeight = graphics.getFontMetrics().getHeight();
        int lineWidth = Math.round((float)radius / 2.0f);
        int textLineHorizontalSpacing = 10;
        int numberOfPitchLines = 13;
        int overlayWidth = textWidth + textLineHorizontalSpacing + lineWidth + textLineHorizontalSpacing + textWidth;
        int overlayHeight = (numberOfPitchLines - 1) * this.getPitchLineIntervalPixel() + textHeight + 1;
        AffineTransform r = new AffineTransform();
        r.translate(this.getHorizontalCenter() - Math.round((float)overlayWidth / 2.0f), this.getVerticalCenter() - Math.round((float)overlayHeight / 2.0f));
        if (this.rollOrientation == ROLL_CW_POSITIVE) {
            r.rotate(-roll, Math.round((float)overlayWidth / 2.0f), Math.round((float)overlayHeight / 2.0f));
        } else {
            r.rotate(roll, Math.round((float)overlayWidth / 2.0f), Math.round((float)overlayHeight / 2.0f));
        }
        graphics.setTransform(r);
        graphics.setColor(Color.GREEN);
        double pitchAngle = 0.0;
        pitchAngle = this.pitchOrientation == PITCH_UP_POSITIVE ? -60.0 : 60.0;
        int vPosition = textHeight;
        int zeroPitchPosition = 0;
        int pitchLine = 0;
        while (pitchLine < numberOfPitchLines) {
            String pitchAngleString = decimalFormat.format(pitchAngle);
            if (pitchAngle >= 0.0) {
                pitchAngleString = "+" + pitchAngleString;
            }
            graphics.drawString(pitchAngleString, 0, vPosition);
            graphics.setStroke(new BasicStroke(2.0f));
            int lineY = vPosition - (int)Math.floor((double)textHeight / 2.0) + 2;
            graphics.drawLine(textWidth + textLineHorizontalSpacing, lineY, textWidth + textLineHorizontalSpacing + lineWidth, lineY);
            graphics.drawString(pitchAngleString, textWidth + textLineHorizontalSpacing + lineWidth + textLineHorizontalSpacing, vPosition);
            if (pitchAngle == 0.0) {
                zeroPitchPosition = lineY;
            }
            pitchAngle = this.pitchOrientation == PITCH_UP_POSITIVE ? (pitchAngle += 10.0) : (pitchAngle -= 10.0);
            vPosition += this.getPitchLineIntervalPixel();
            ++pitchLine;
        }
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(Color.WHITE);
        int xRightArrow = (int)Math.round((double)overlayWidth / 2.0) + radius;
        int xLeftArrow = (int)Math.round((double)overlayWidth / 2.0) - radius;
        graphics.drawLine(xRightArrow, zeroPitchPosition, xRightArrow - 5, zeroPitchPosition - 5);
        graphics.drawLine(xRightArrow, zeroPitchPosition, xRightArrow - 5, zeroPitchPosition + 5);
        graphics.drawLine(xLeftArrow, zeroPitchPosition, xLeftArrow + 5, zeroPitchPosition - 5);
        graphics.drawLine(xLeftArrow, zeroPitchPosition, xLeftArrow + 5, zeroPitchPosition + 5);
        return img;
    }

    private BufferedImage drawForeground(int width, int height, int radius, double pitch, double roll) {
        String rollString;
        AffineTransform t;
        int y2;
        int x2;
        int y1;
        int x1;
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D graphics = img.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int textHeight = graphics.getFontMetrics().getHeight();
        DecimalFormat decimalFormat = new DecimalFormat("###0");
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, width, height);
        graphics.setComposite(AlphaComposite.getInstance(8, 1.0f));
        graphics.setColor(Color.blue);
        int x = (int)Math.round((double)width / 2.0 - (double)radius);
        int y = (int)Math.round((double)height / 2.0 - (double)radius);
        graphics.fillOval(x, y, radius * 2, radius * 2);
        graphics.setColor(Color.WHITE);
        graphics.setComposite(AlphaComposite.getInstance(2, 1.0f));
        double rollAngleIncrement = 10.0;
        double rollAngle = 0.0;
        rollAngle = this.rollOrientation == ROLL_CW_POSITIVE ? 60.0 : -60.0;
        int markLenght = 10;
        int iterations = (int)Math.round(120.0 / rollAngleIncrement) + 1;
        int i = 0;
        while (i < iterations) {
            x1 = (int)Math.round((double)radius * Math.cos(Math.toRadians(rollAngle)));
            y1 = (int)Math.round((double)radius * Math.sin(Math.toRadians(rollAngle)));
            x2 = (int)Math.round((double)(radius + markLenght) * Math.cos(Math.toRadians(rollAngle)));
            y2 = (int)Math.round((double)(radius + markLenght) * Math.sin(Math.toRadians(rollAngle)));
            t = new AffineTransform();
            t.translate(Math.round((float)width / 2.0f), Math.round((float)height / 2.0f));
            graphics.setTransform(t);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.drawLine(x1, y1, x2, y2);
            if (this.rollOrientation == ROLL_CW_POSITIVE) {
                rollString = decimalFormat.format(-rollAngle);
                graphics.drawString(rollString, x2 + 2, y2 + Math.round((float)textHeight / 2.0f) - 2);
                rollAngle -= rollAngleIncrement;
            } else {
                rollString = decimalFormat.format(rollAngle);
                graphics.drawString(rollString, x2 + 2, y2 + Math.round((float)textHeight / 2.0f) - 2);
                rollAngle += rollAngleIncrement;
            }
            ++i;
        }
        rollAngle = this.rollOrientation == ROLL_CW_POSITIVE ? -120.0 : 120.0;
        i = 0;
        while (i < iterations) {
            int textWidth;
            x1 = (int)Math.round((double)radius * Math.cos(Math.toRadians(rollAngle)));
            y1 = (int)Math.round((double)radius * Math.sin(Math.toRadians(rollAngle)));
            x2 = (int)Math.round((double)(radius + markLenght) * Math.cos(Math.toRadians(rollAngle)));
            y2 = (int)Math.round((double)(radius + markLenght) * Math.sin(Math.toRadians(rollAngle)));
            t = new AffineTransform();
            t.translate(Math.round((float)width / 2.0f), Math.round((float)height / 2.0f));
            graphics.setTransform(t);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.drawLine(x1, y1, x2, y2);
            if (this.rollOrientation == ROLL_CW_POSITIVE) {
                rollString = decimalFormat.format(-(rollAngle + 180.0));
                textWidth = graphics.getFontMetrics().stringWidth(rollString);
                graphics.drawString(rollString, x2 - (textWidth + 2), y2 + Math.round((float)textHeight / 2.0f) - 2);
                rollAngle -= rollAngleIncrement;
            } else {
                rollString = decimalFormat.format(rollAngle - 180.0);
                textWidth = graphics.getFontMetrics().stringWidth(rollString);
                graphics.drawString(rollString, x2 - (textWidth + 2), y2 + Math.round((float)textHeight / 2.0f) - 2);
                rollAngle += rollAngleIncrement;
            }
            ++i;
        }
        graphics.dispose();
        return img;
    }

    private Color getHorizonColor(double pitch, double roll) {
        Ranges range = Ranges.NOMINAL;
        if (pitch <= this.alarmMinPitch || pitch >= this.alarmMaxPitch) {
            range = Ranges.ALARM;
        } else if (roll <= this.alarmMinRoll || roll >= this.alarmMaxRoll) {
            range = Ranges.ALARM;
        } else if (pitch <= this.warningMinPitch || pitch >= this.warningMaxPitch) {
            range = Ranges.WARNING;
        } else if (roll <= this.warningMinRoll || roll >= this.warningMaxRoll) {
            range = Ranges.WARNING;
        }
        if (range.getValue() == 3 || range.getValue() == 2) {
            org.eclipse.swt.graphics.Color rangeColor = ApogyCommonEMFUIFacade.INSTANCE.getColorForRange(range);
            return new Color(rangeColor.getRed(), rangeColor.getGreen(), rangeColor.getBlue());
        }
        return this.ground;
    }

    private org.eclipse.swt.graphics.Color getPitchColor(double pitch) {
        Ranges range = Ranges.NOMINAL;
        if (pitch <= this.alarmMinPitch || pitch >= this.alarmMaxPitch) {
            range = Ranges.ALARM;
        } else if (pitch <= this.warningMinPitch || pitch >= this.warningMaxPitch) {
            range = Ranges.WARNING;
        }
        org.eclipse.swt.graphics.Color rangeColor = ApogyCommonEMFUIFacade.INSTANCE.getColorForRange(range);
        if (rangeColor != null) {
            return new org.eclipse.swt.graphics.Color((Device)this.getDisplay(), rangeColor.getRed(), rangeColor.getGreen(), rangeColor.getBlue());
        }
        return new org.eclipse.swt.graphics.Color((Device)this.getDisplay(), 255, 255, 255);
    }

    private org.eclipse.swt.graphics.Color getRollColor(double roll) {
        Ranges range = Ranges.NOMINAL;
        if (roll <= this.alarmMinRoll || roll >= this.alarmMaxRoll) {
            range = Ranges.ALARM;
        } else if (roll <= this.warningMinRoll || roll >= this.warningMaxRoll) {
            range = Ranges.WARNING;
        }
        org.eclipse.swt.graphics.Color rangeColor = ApogyCommonEMFUIFacade.INSTANCE.getColorForRange(range);
        if (rangeColor != null) {
            return new org.eclipse.swt.graphics.Color((Device)this.getDisplay(), rangeColor.getRed(), rangeColor.getGreen(), rangeColor.getBlue());
        }
        return new org.eclipse.swt.graphics.Color((Device)this.getDisplay(), 255, 255, 255);
    }

    private String formatAngle(double value, int lenght) {
        DecimalFormat angleValueFormat = new DecimalFormat("0.0");
        String s = angleValueFormat.format(value);
        if (value >= 0.0) {
            s = "+" + s;
        }
        while (s.length() < lenght) {
            s = " " + s;
        }
        return s;
    }
}

