/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.wizards;

import java.text.DecimalFormat;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehiclePackage;
import org.eclipse.apogy.addons.vehicle.Thruster;
import org.eclipse.apogy.common.emf.ui.composites.TypedElementSimpleUnitsComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ThrusterWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.vehicle.ui.wizards.ThrusterWizardPage";
    public static String NO_VALUE_AVAILABLE_STRING = "N/A";
    private final int LABEL_WIDTH = 200;
    private final int VALUE_WIDTH = 100;
    private final int BUTTON_WIDTH = 50;
    private Thruster thruster;
    private Adapter adapter;
    private TypedElementSimpleUnitsComposite minimumThrustComposite;
    private TypedElementSimpleUnitsComposite maximumThrustComposite;
    private TypedElementSimpleUnitsComposite plumeAngleComposite;

    public ThrusterWizardPage(Thruster thruster) {
        super(WIZARD_PAGE_ID);
        this.thruster = thruster;
        this.setTitle("Thruster");
        this.setDescription("Sets the thuster parameters.");
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)top);
        this.minimumThrustComposite = new TypedElementSimpleUnitsComposite(top, 0, true, true, true, NO_VALUE_AVAILABLE_STRING, 200, 100, 50){
            DecimalFormat format;
            {
                this.format = new DecimalFormat("0.000");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected String getLabelText() {
                return "Minimum Thrust :";
            }
        };
        this.minimumThrustComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.minimumThrustComposite.setTypedElement(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsVehiclePackage.Literals.THRUSTER__MINIMUM_THRUST}), (EObject)this.getThruster());
        this.maximumThrustComposite = new TypedElementSimpleUnitsComposite(top, 0, true, true, true, NO_VALUE_AVAILABLE_STRING, 200, 100, 50){
            DecimalFormat format;
            {
                this.format = new DecimalFormat("0.000");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected String getLabelText() {
                return "Maximum Thrust :";
            }
        };
        this.maximumThrustComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.maximumThrustComposite.setTypedElement(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsVehiclePackage.Literals.THRUSTER__MAXIMUM_THRUST}), (EObject)this.getThruster());
        this.plumeAngleComposite = new TypedElementSimpleUnitsComposite(top, 0, true, true, true, NO_VALUE_AVAILABLE_STRING, 200, 100, 50){
            DecimalFormat format;
            {
                this.format = new DecimalFormat("0.0");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected String getLabelText() {
                return "Plume Angle :";
            }
        };
        this.plumeAngleComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.plumeAngleComposite.setTypedElement(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsVehiclePackage.Literals.THRUSTER__PLUME_ANGLE}), (EObject)this.getThruster());
        if (this.thruster != null) {
            this.thruster.eAdapters().add((Object)this.getAdapter());
        }
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (ThrusterWizardPage.this.thruster != null) {
                    ThrusterWizardPage.this.thruster.eAdapters().remove((Object)ThrusterWizardPage.this.getAdapter());
                }
            }
        });
        this.validate();
    }

    public Thruster getThruster() {
        return this.thruster;
    }

    public void setThruster(Thruster thruster) {
        this.thruster = thruster;
        if (this.minimumThrustComposite != null && !this.minimumThrustComposite.isDisposed()) {
            this.minimumThrustComposite.setInstance((EObject)thruster);
        }
        if (this.maximumThrustComposite != null && !this.maximumThrustComposite.isDisposed()) {
            this.maximumThrustComposite.setInstance((EObject)thruster);
        }
        if (this.plumeAngleComposite != null && !this.plumeAngleComposite.isDisposed()) {
            this.plumeAngleComposite.setInstance((EObject)thruster);
        }
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.thruster.getMinimumThrust() < 0.0) {
            this.setErrorMessage("The specified minimum thrust must be greater or equal to zero !");
        }
        if (this.thruster.getMaximumThrust() < 0.0) {
            this.setErrorMessage("The specified maximum thrust must be greater or equal to zero !");
        }
        if (this.thruster.getMaximumThrust() < this.thruster.getMinimumThrust()) {
            this.setErrorMessage("The specified maximum thrust must be greater or equal than the minimum thrust !");
        }
        if (this.thruster.getPlumeAngle() <= 0.0) {
            this.setErrorMessage("The specified plume angle must be greater or equal than zero !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Thruster) {
                        ThrusterWizardPage.this.validate();
                    }
                }
            };
        }
        return this.adapter;
    }
}

