/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehiclePackage;
import org.eclipse.apogy.addons.vehicle.LanderSphericalFoot;
import org.eclipse.apogy.addons.vehicle.MeshNodeEntry;
import org.eclipse.apogy.addons.vehicle.impl.LanderSphericalFootContactProviderImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.dynamics.PhysicalBody;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanderSphericalFootContactProviderCustomImpl
extends LanderSphericalFootContactProviderImpl {
    private static final Logger Logger = LoggerFactory.getLogger(LanderSphericalFootContactProviderImpl.class);

    @Override
    public List<PhysicalBody> extractContactBodies() {
        ArrayList<PhysicalBody> extractedFeet = new ArrayList<PhysicalBody>();
        try {
            Node root = this.getVehiclePoseCorrector().getSystemRootNode();
            EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyAddonsVehiclePackage.Literals.LANDER_SPHERICAL_FOOT, root);
            for (Node node : nodes) {
                if (!(node instanceof LanderSphericalFoot)) continue;
                extractedFeet.add((LanderSphericalFoot)node);
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return extractedFeet;
    }

    @Override
    public void updateContactPoints(Matrix4x4 originalPose, Map<PhysicalBody, Point3d> bodyToContactsMap) {
        bodyToContactsMap.clear();
        EList<MeshNodeEntry> meshes = this.getVehiclePoseCorrector().getMeshes();
        for (MeshNodeEntry meshNodeEntry : meshes) {
            ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
            for (PhysicalBody foot : this.getVehiclePoseCorrector().getContactBodies()) {
                Matrix4d footTransform = this.getBodyToMeshTransform(originalPose, foot, meshNodeEntry.getNode());
                Vector3d footPosition = new Vector3d();
                footTransform.get(footPosition);
                points.add(ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(footPosition.x, footPosition.y, footPosition.z));
            }
            CartesianPositionCoordinates[] intersections = this.getProjectionAlongAxisOnToPolygon(CartesianAxis.Z, points, meshNodeEntry.getMesh());
            int i = 0;
            while (i < intersections.length) {
                PhysicalBody body;
                if (intersections[i] != null && (body = (PhysicalBody)this.getVehiclePoseCorrector().getContactBodies().get(i)) instanceof LanderSphericalFoot) {
                    LanderSphericalFoot foot = (LanderSphericalFoot)body;
                    Point3d footPosition = new Point3d(intersections[i].asPoint3d());
                    footPosition.z += foot.getRadius();
                    if (bodyToContactsMap.get(foot) != null) {
                        double previousZ = bodyToContactsMap.get((Object)foot).z;
                        if (footPosition.getZ() > previousZ) {
                            bodyToContactsMap.put(foot, footPosition);
                        }
                    } else {
                        bodyToContactsMap.put(foot, footPosition);
                    }
                }
                ++i;
            }
        }
    }
}

