/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.vehicle.impl.VehiclePathPlannerToolImpl;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.invocator.VariableImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehiclePathPlannerToolCustomImpl
extends VehiclePathPlannerToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(VehiclePathPlannerToolImpl.class);

    public boolean isFromNodeLock() {
        return true;
    }

    @Override
    public void selectionChanged(NodeSelection nodeSelection) {
        if (!this.isDisposed()) {
            Node node = nodeSelection.getSelectedNode();
            Tuple3d relativePosition = null;
            if (nodeSelection.getRelativeIntersectionPoint() != null) {
                relativePosition = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)nodeSelection.getRelativeIntersectionPoint());
            }
            Tuple3d normal = null;
            if (nodeSelection.getAbsoluteIntersectionNormal() != null) {
                normal = ApogyCommonMathFacade.INSTANCE.createTuple3d((double)nodeSelection.getAbsoluteIntersectionNormal().x, (double)nodeSelection.getAbsoluteIntersectionNormal().y, (double)nodeSelection.getAbsoluteIntersectionNormal().z);
            }
            this.updateToNode(node, relativePosition, normal);
        }
    }

    public Tuple3d getFromAbsolutePosition() {
        if (this.getVariable() != null) {
            try {
                VariableImplementation variableImplementation = this.getVariable().getEnvironment().getActiveContext().getVariableImplementationsList().getVariableImplementation(this.getVariable());
                if (variableImplementation.getAdapterInstance() instanceof ApogySystemApiAdapter) {
                    ApogySystemApiAdapter apogySystemApiAdapter = (ApogySystemApiAdapter)variableImplementation.getAdapterInstance();
                    Matrix4d m = null;
                    if (apogySystemApiAdapter.getPoseTransform() != null) {
                        m = apogySystemApiAdapter.getPoseTransform().asMatrix4d();
                    } else {
                        m = new Matrix4d();
                        m.setIdentity();
                    }
                    Vector3d v = new Vector3d();
                    m.get(v);
                    return ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)v);
                }
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
        return super.getFromAbsolutePosition();
    }
}

