/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.databinding.converters;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.apogy.common.databinding.converters.AbstractNumberConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToShortConverter
extends AbstractNumberConverter {
    private static final Logger Logger = LoggerFactory.getLogger(StringToShortConverter.class);

    public StringToShortConverter() {
        super(String.class, Short.class);
    }

    public StringToShortConverter(NumberFormat numberFormat) {
        super(String.class, Short.class);
        this.setNumberFormat(numberFormat);
    }

    public Object convert(Object fromObject) {
        if (this.getNumberFormat() != null) {
            try {
                return new Short(this.getNumberFormat().parse((String)fromObject).shortValue());
            }
            catch (ParseException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new Short((String)fromObject);
    }
}

