/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.renderers;

import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.dialogs.SelectUnitDialog;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.PropertyType;
import org.eclipse.apogy.common.emf.ui.preferences.PreferencesConstants;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUnitControlCompositeRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractUnitControlCompositeRenderer.class);
    protected Text textValue;
    private Button buttonUnits;
    private Binding colorBinding;
    private Binding valueBinding;
    private IPropertyChangeListener propertyChangeListener;

    @Inject
    public AbstractUnitControlCompositeRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPropertyChangeListener());
    }

    protected Control createSWTControl(Composite parent) {
        PropertyType propertyType = this.getPropertyType(this.getVElement());
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).create());
        main.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        main.setBackground(parent.getBackground());
        main.setBackgroundMode(2);
        this.textValue = new Text(main, 133120);
        this.textValue.setEditable(propertyType == PropertyType.EDITABLE);
        this.textValue.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.buttonUnits = new Button(main, 8);
        GridData gd_buttonUnits = new GridData(4, 4, false, true, 1, 1);
        gd_buttonUnits.widthHint = 100;
        this.buttonUnits.setLayoutData((Object)gd_buttonUnits);
        this.updateButton();
        this.buttonUnits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectUnitDialog dialog = new SelectUnitDialog(AbstractUnitControlCompositeRenderer.this.buttonUnits.getShell(), AbstractUnitControlCompositeRenderer.this.getValue(), AbstractUnitControlCompositeRenderer.this.getDecimalFormat(), AbstractUnitControlCompositeRenderer.this.getNativeUnits(), AbstractUnitControlCompositeRenderer.this.getDisplayUnits()){

                    protected void buttonPressed(int buttonId) {
                        if (buttonId == 0) {
                            try {
                                if (AbstractUnitControlCompositeRenderer.this.getDecimalFormat() != this.getResultFormat()) {
                                    AbstractUnitControlCompositeRenderer.this.addToDecimalFormatRegistry(this.getResultFormat());
                                }
                                if (AbstractUnitControlCompositeRenderer.this.getDisplayUnits() != this.getResultUnit()) {
                                    AbstractUnitControlCompositeRenderer.this.addToDisplayUnitsRegistry(this.getResultUnit());
                                }
                            }
                            catch (ConversionException e) {
                                Logger.error("The value can not be converted ");
                            }
                        }
                        super.buttonPressed(buttonId);
                    }
                };
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    AbstractUnitControlCompositeRenderer.this.updateButton();
                    AbstractUnitControlCompositeRenderer.this.textValue.setText(AbstractUnitControlCompositeRenderer.this.getFormatedValue());
                }
            }
        });
        return main;
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        Binding[] bindings = new Binding[3];
        ISWTObservableValue textValueText = WidgetProperties.text((int)16).observe((Widget)this.textValue);
        bindings[0] = this.valueBinding = this.getDataBindingContext().bindValue((IObservableValue)textValueText, this.getModelValue(), this.getUpdateModelValueStrategy(), this.getUpdateTextValueStrategy());
        ISWTObservableValue textValueBackground = WidgetProperties.background().observe((Widget)this.textValue);
        bindings[1] = this.colorBinding = this.getDataBindingContext().bindValue((IObservableValue)textValueBackground, this.getModelValue(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, Color.class){

            public Object convert(Object fromObject) {
                Color color = Display.getCurrent().getSystemColor(37);
                color = ApogyCommonEMFUIFacade.INSTANCE.getColorForRange(AbstractUnitControlCompositeRenderer.this.getRange());
                return color;
            }
        }));
        ISWTObservableValue buttonText = WidgetProperties.text().observe((Widget)this.buttonUnits);
        bindings[2] = this.getDataBindingContext().bindValue((IObservableValue)buttonText, this.getModelValue(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(EObject.class, String.class){

            public Object convert(Object fromObject) {
                Unit<?> units = AbstractUnitControlCompositeRenderer.this.getDisplayUnits();
                return units == null ? "Select units" : units.toString();
            }
        }));
        return bindings;
    }

    protected abstract UpdateValueStrategy getUpdateModelValueStrategy();

    protected abstract UpdateValueStrategy getUpdateTextValueStrategy();

    protected abstract void addToDisplayUnitsRegistry(Unit<?> var1);

    protected abstract void addToDecimalFormatRegistry(DecimalFormat var1);

    protected abstract Unit<?> getNativeUnits();

    protected abstract Unit<?> getDisplayUnits();

    protected abstract DecimalFormat getDecimalFormat();

    protected abstract String getFormatedValue();

    protected abstract Ranges getRange();

    protected ETypedElement getTypedElement() {
        try {
            return (ETypedElement)this.getModelValue().getValueType();
        }
        catch (DatabindingFailedException e) {
            Logger.error("Error getting the typedElement");
            return null;
        }
    }

    protected Number getValue() {
        try {
            return (Number)this.getModelValue().getValue();
        }
        catch (DatabindingFailedException e) {
            Logger.error("Error getting the value.");
            return null;
        }
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("TYPED_ELEMENTS_UNITS_ID") || PreferencesConstants.isFormatPreference((String)event.getProperty())) {
                        AbstractUnitControlCompositeRenderer.this.textValue.setText(AbstractUnitControlCompositeRenderer.this.getFormatedValue());
                        AbstractUnitControlCompositeRenderer.this.updateButton();
                    } else if (event.getProperty().equals(Ranges.UNKNOWN.getName()) || event.getProperty().equals(Ranges.NOMINAL.getName()) || event.getProperty().equals(Ranges.WARNING.getName()) || event.getProperty().equals(Ranges.ALARM.getName()) || event.getProperty().equals(Ranges.OUT_OF_RANGE.getName())) {
                        AbstractUnitControlCompositeRenderer.this.colorBinding.updateModelToTarget();
                    }
                }
            };
        }
        return this.propertyChangeListener;
    }

    private void updateButton() {
        Unit<?> units = this.getDisplayUnits();
        if (units != null) {
            this.buttonUnits.setText(units.toString());
        } else {
            this.buttonUnits.setText("Select units");
        }
        this.buttonUnits.requestLayout();
    }

    protected String getUnsetText() {
        return "unset";
    }

    protected PropertyType getPropertyType(VElement vElement) {
        VControl vControl;
        PropertyType propertyType = PropertyType.EDITABLE;
        if (vElement instanceof VControl && (vControl = (VControl)vElement).getDomainModelReference() instanceof VFeaturePathDomainModelReference) {
            VFeaturePathDomainModelReference vFeaturePathDomainModelReference = (VFeaturePathDomainModelReference)vControl.getDomainModelReference();
            EStructuralFeature feature = vFeaturePathDomainModelReference.getDomainModelEFeature();
            if (feature.isDerived() || !feature.isChangeable()) {
                propertyType = PropertyType.READONLY;
            } else if (feature instanceof EAttribute) {
                propertyType = ApogyCommonEMFUiEMFFormsFacade.INSTANCE.getPropertyType((EAttribute)feature);
            } else if (feature instanceof EReference) {
                propertyType = ApogyCommonEMFUiEMFFormsFacade.INSTANCE.getPropertyType((EReference)feature);
            }
        }
        return propertyType;
    }

    protected void dispose() {
        if (this.propertyChangeListener != null) {
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.getPropertyChangeListener());
        }
        super.dispose();
    }
}

