/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.CompositeFilter;
import org.eclipse.apogy.common.emf.CompositeFilterType;
import org.eclipse.apogy.common.emf.IFilter;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.composites.CompositeFilterTypeComboComposite;
import org.eclipse.apogy.common.emf.ui.wizards.NewChildWizard;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeFilterComposite<T>
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(CompositeFilterComposite.class);
    protected CompositeFilter<T> compositeFilter;
    private CompositeFilterTypeComboComposite compositeFilterTypeComboComposite;
    private Tree tree;
    private TreeViewer treeViewer;
    private Button btnNew;
    private Button btnDelete;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;
    private Composite topComposite;

    public CompositeFilterComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public CompositeFilterComposite(Composite parent, int style, CompositeFilterComposite<T> compositeFilter) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.topComposite = new Composite((Composite)this, 0);
        this.topComposite.setLayout((Layout)new GridLayout(2, false));
        this.topComposite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Label lblFilterBehaviour = new Label(this.topComposite, 0);
        lblFilterBehaviour.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFilterBehaviour.setAlignment(131072);
        lblFilterBehaviour.setText("Filter Behaviour:");
        this.compositeFilterTypeComboComposite = new CompositeFilterTypeComboComposite(this.topComposite, 0){

            @Override
            protected void newSelection(CompositeFilterType compositeFilterType) {
                if (CompositeFilterComposite.this.getCompositeFilter() != null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet(CompositeFilterComposite.this.getCompositeFilter(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.COMPOSITE_FILTER__FILTER_CHAIN_TYPE, (Object)compositeFilterType);
                }
            }
        };
        this.compositeFilterTypeComboComposite.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.getCompositeFilter() != null) {
            this.compositeFilterTypeComboComposite.setSelectedCompositeFilterType(this.getCompositeFilter().getFilterChainType());
        }
        new Label((Composite)this, 0);
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.tree = this.treeViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new CompositeFilterContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CompositeFilterComposite.this.newSelection((IFilter)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        Composite rightComposite = new Composite((Composite)this, 0);
        rightComposite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        rightComposite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(rightComposite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    EditingDomain domain;
                    CompositeFilter parentCompositeFilter = CompositeFilterComposite.this.getCompositeFilter();
                    if (((IStructuredSelection)CompositeFilterComposite.this.treeViewer.getSelection()).getFirstElement() instanceof CompositeFilter) {
                        parentCompositeFilter = (CompositeFilter)((IStructuredSelection)CompositeFilterComposite.this.treeViewer.getSelection()).getFirstElement();
                    }
                    if ((domain = AdapterFactoryEditingDomain.getEditingDomainFor(parentCompositeFilter)) == null) {
                        ApogyCommonTransactionFacade.INSTANCE.addInTempTransactionalEditingDomain((EObject)parentCompositeFilter);
                    }
                    NewChildWizard newChildWizard = new NewChildWizard(ApogyCommonEMFPackage.Literals.COMPOSITE_FILTER__FILTERS, (EObject)parentCompositeFilter);
                    newChildWizard.getCreatedChild().addChangeListener(new IChangeListener(){

                        public void handleChange(ChangeEvent event) {
                            EObject selected = (EObject)((WritableValue)event.getObservable()).getValue();
                            if (!CompositeFilterComposite.this.treeViewer.isBusy()) {
                                CompositeFilterComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)selected));
                                CompositeFilterComposite.this.treeViewer.refresh();
                            }
                        }
                    });
                    WizardDialog dialog = new WizardDialog(CompositeFilterComposite.this.getShell(), (IWizard)newChildWizard);
                    dialog.open();
                }
            }
        });
        this.btnDelete = new Button(rightComposite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String toolsToDeleteMessage = "";
                List selectedFilters = CompositeFilterComposite.this.getSelectedFilters();
                Iterator filters = selectedFilters.iterator();
                while (filters.hasNext()) {
                    IFilter filter = filters.next();
                    toolsToDeleteMessage = String.valueOf(toolsToDeleteMessage) + filter.getName();
                    if (!filters.hasNext()) continue;
                    toolsToDeleteMessage = String.valueOf(toolsToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected filters", null, "Are you sure to delete these filters: " + toolsToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (IFilter filter : selectedFilters) {
                        try {
                            EditingDomain domain;
                            CompositeFilter parent = CompositeFilterComposite.this.compositeFilter;
                            if (filter.eContainer() instanceof CompositeFilter) {
                                parent = (CompositeFilter)filter.eContainer();
                            }
                            if ((domain = AdapterFactoryEditingDomain.getEditingDomainFor(parent)) instanceof TransactionalEditingDomain) {
                                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)parent, (EStructuralFeature)ApogyCommonEMFPackage.Literals.COMPOSITE_FILTER__FILTERS, filter);
                                continue;
                            }
                            CompositeFilterComposite.this.getCompositeFilter().getFilters().remove(filter);
                        }
                        catch (Exception ex) {
                            CompositeFilterComposite.this.getCompositeFilter().getFilters().remove(filter);
                            Logger.error("Unable to delete the tool <" + filter.getName() + ">", (Throwable)ex);
                        }
                    }
                    CompositeFilterComposite.this.treeViewer.setInput(CompositeFilterComposite.this.getCompositeFilter());
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CompositeFilterComposite.this.m_bindingContext != null) {
                    CompositeFilterComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public CompositeFilter<T> getCompositeFilter() {
        return this.compositeFilter;
    }

    public void setCompositeFilter(CompositeFilter<T> compositeFilter) {
        this.compositeFilter = compositeFilter;
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        if (compositeFilter != null) {
            this.m_bindingContext = this.customInitDataBindings();
            this.compositeFilterTypeComboComposite.setSelectedCompositeFilterType(compositeFilter.getFilterChainType());
            this.treeViewer.setInput(compositeFilter);
        }
    }

    public List<IFilter<T>> getSelectedFilters() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected void newSelection(IFilter<T> filter) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private class CompositeFilterContentProvider
    implements ITreeContentProvider {
        private CompositeFilterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = null;
            if (inputElement instanceof CompositeFilter) {
                return ((CompositeFilter)inputElement).getFilters().toArray();
            }
            return elements;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = null;
            if (parentElement instanceof CompositeFilter) {
                CompositeFilter compositeFilter = (CompositeFilter)parentElement;
                children = compositeFilter.getFilters().toArray();
            }
            return children;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof CompositeFilter) {
                CompositeFilter compositeFilter = (CompositeFilter)element;
                return !compositeFilter.getFilters().isEmpty();
            }
            return false;
        }
    }
}

