/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class EObjectListComposite
extends Composite {
    private DataBindingContext m_currentDataBindings;
    private EList<? extends EObject> eObjectsList;
    protected TreeViewer treeViewerEObjectsList;
    private ISelectionChangedListener treeViewerSelectionChangedListener;

    public EObjectListComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.treeViewerEObjectsList = new TreeViewer((Composite)this, 2048);
        Tree treeEObjectsList = this.treeViewerEObjectsList.getTree();
        treeEObjectsList.setLinesVisible(true);
        treeEObjectsList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        treeEObjectsList.setHeaderVisible(false);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewerEObjectsList);
        this.treeViewerEObjectsList.addSelectionChangedListener(this.getTreeViewerSelectionChangedListener());
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewerEObjectsList, 0);
        TreeColumn treeColumn = treeViewerColumn.getColumn();
        treeColumn.setWidth(200);
        this.treeViewerEObjectsList.setContentProvider(this.getContentProvider());
        this.treeViewerEObjectsList.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
    }

    private ISelectionChangedListener getTreeViewerSelectionChangedListener() {
        if (this.treeViewerSelectionChangedListener == null) {
            this.treeViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EObjectListComposite.this.newSelection((TreeSelection)event.getSelection());
                }
            };
        }
        return this.treeViewerSelectionChangedListener;
    }

    protected void newSelection(TreeSelection selection) {
    }

    public EObject getSelectedEObject() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewerEObjectsList.getSelection();
        return (EObject)selection.getFirstElement();
    }

    public void setSelectedEObject(EObject eObject) {
        this.treeViewerEObjectsList.setSelection((ISelection)new StructuredSelection((Object)eObject));
    }

    protected StyledCellLabelProvider getLabelProvider() {
        return new EObjectEClassNameLabelProvider();
    }

    public void refreshTreeViewer() {
        if (!this.isDisposed() && !this.treeViewerEObjectsList.isBusy()) {
            this.treeViewerEObjectsList.refresh();
        }
    }

    protected IContentProvider getContentProvider() {
        return new ContentProvider();
    }

    public void setEObjectsList(EList<? extends EObject> eObjectsList) {
        this.eObjectsList = eObjectsList;
        if (eObjectsList != null) {
            if (this.m_currentDataBindings != null) {
                this.m_currentDataBindings.dispose();
            }
            this.m_currentDataBindings = this.initDataBindings(null);
        }
    }

    public void setEObjectsList(EList<? extends EObject> eObjectsList, Object defaultSelected) {
        this.eObjectsList = eObjectsList;
        if (eObjectsList != null) {
            if (this.m_currentDataBindings != null) {
                this.m_currentDataBindings.dispose();
            }
            this.m_currentDataBindings = this.initDataBindings(defaultSelected);
        }
    }

    public EList<? extends EObject> getEObjectsList() {
        return this.eObjectsList;
    }

    protected DataBindingContext initDataBindings(Object defaultSelected) {
        return this.initDataBindingsCustom(defaultSelected);
    }

    protected DataBindingContext initDataBindingsCustom(Object defaultSelected) {
        DataBindingContext bindingContext = new DataBindingContext();
        if (this.eObjectsList != null && !this.treeViewerEObjectsList.getTree().isDisposed()) {
            this.treeViewerEObjectsList.setInput(this.eObjectsList);
            if (!this.eObjectsList.isEmpty() && defaultSelected != null) {
                this.treeViewerEObjectsList.setSelection((ISelection)new StructuredSelection(defaultSelected));
            } else if (!this.eObjectsList.isEmpty() && defaultSelected == null) {
                this.treeViewerEObjectsList.setSelection((ISelection)new StructuredSelection(this.eObjectsList.get(0)));
            }
        }
        return bindingContext;
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        Viewer viewer = null;
        List<EObject> inputList;

        protected ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            super.inputChanged(viewer, oldInput, newInput);
            this.viewer = viewer;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class EObjectEClassNameLabelProvider
    extends StyledCellLabelProvider {
        private EObjectEClassNameLabelProvider() {
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof EObject) {
                cell.setText(((EObject)cell.getElement()).eClass().getName());
            }
        }

        public String getToolTipText(Object element) {
            if (element instanceof EObject) {
                return ((EObject)element).eClass().getName();
            }
            return super.getToolTipText(element);
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }
    }
}

