/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import org.eclipse.apogy.common.emf.IFilter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterDetailsComposite<T>
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(FilterDetailsComposite.class);
    private IFilter<T> filter;
    private final Composite compositeDetails;

    public FilterDetailsComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 768);
        scrolledComposite.setLayout((Layout)new GridLayout());
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.addListener(11, event -> {
            int width = scrolledComposite.getClientArea().width;
            scrolledComposite.setMinSize(parent.computeSize(width, -1));
        });
        this.compositeDetails = new Composite((Composite)scrolledComposite, 2048);
        this.compositeDetails.setLayout((Layout)new GridLayout());
        GridData gd_compositeDetails = new GridData(4, 4, true, true, 1, 1);
        gd_compositeDetails.minimumHeight = 100;
        gd_compositeDetails.heightHint = 100;
        gd_compositeDetails.minimumWidth = 250;
        gd_compositeDetails.widthHint = 250;
        this.compositeDetails.setLayoutData((Object)gd_compositeDetails);
        this.compositeDetails.layout();
        scrolledComposite.setContent((Control)this.compositeDetails);
    }

    public IFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(IFilter<T> filter) {
        this.filter = filter;
        if (filter != null) {
            try {
                this.createEMFForms(this.compositeDetails, (EObject)filter);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
    }

    private void createEMFForms(Composite parent, EObject eObject) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        try {
            VView viewModel = ViewProviderHelper.getView((EObject)eObject, null);
            ECPSWTViewRenderer.INSTANCE.render(parent, eObject, viewModel);
        }
        catch (Exception e) {
            Logger.error("setCompositeContents(): Error while opening EMF Forms");
        }
        parent.layout();
    }
}

