/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.FixedTimeSource;
import org.eclipse.apogy.common.emf.TimeSource;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.composites.AbstractTimeSourceComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;

public class FixedTimeSourceComposite
extends AbstractTimeSourceComposite {
    protected FixedTimeSource fixedTimeSource;
    protected DataBindingContext bindingContext;
    protected DateTime dateWidget;
    protected DateTime timeWidget;
    protected Button applyButton;

    public FixedTimeSourceComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public FixedTimeSourceComposite(Composite parent, int style, FixedTimeSource fixedTimeSource) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FixedTimeSourceComposite.this.bindingContext != null) {
                    FixedTimeSourceComposite.this.bindingContext.dispose();
                }
            }
        });
        Composite top = new Composite((Composite)this, 0);
        top.setLayoutData((Object)new GridData(4, 128, true, false));
        top.setLayout((Layout)new GridLayout(1, true));
        this.dateWidget = new DateTime(top, 1024);
        this.timeWidget = new DateTime(top, 0x10000880);
        this.applyButton = new Button(top, 8);
        this.applyButton.setText("Apply");
        GridData applyButtonGridData = new GridData(128, 128, false, false);
        applyButtonGridData.minimumWidth = 100;
        applyButtonGridData.widthHint = 100;
        this.applyButton.setLayoutData((Object)applyButtonGridData);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FixedTimeSourceComposite.this.getFixedTimeSource() != null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)FixedTimeSourceComposite.this.getFixedTimeSource(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.TIMED__TIME, (Object)FixedTimeSourceComposite.this.getSelectedDate());
                }
            }
        });
        this.setFixedTimeSource(fixedTimeSource);
    }

    @Override
    public TimeSource getTimeSource() {
        return this.getFixedTimeSource();
    }

    @Override
    public void activate(boolean active) {
        this.dateWidget.setEnabled(active);
        this.timeWidget.setEnabled(active);
        this.applyButton.setEnabled(active);
    }

    public FixedTimeSource getFixedTimeSource() {
        return this.fixedTimeSource;
    }

    public void setFixedTimeSource(FixedTimeSource fixedTimeSource) {
        this.setFixedTimeSource(fixedTimeSource, true);
    }

    public void setFixedTimeSource(FixedTimeSource fixedTimeSource, boolean update) {
        this.fixedTimeSource = fixedTimeSource;
        if (update) {
            if (this.bindingContext != null) {
                this.bindingContext.dispose();
                this.bindingContext = null;
            }
            if (fixedTimeSource != null) {
                this.setDate(fixedTimeSource.getTime());
                this.bindingContext = this.initDataBindings();
            }
        }
        super.setTimeSource((TimeSource)fixedTimeSource);
    }

    public Date getSelectedDate() {
        Date date = null;
        if (this.dateWidget != null && this.timeWidget != null) {
            int year = this.dateWidget.getYear();
            int month = this.dateWidget.getMonth();
            int day = this.dateWidget.getDay();
            int hrs = this.timeWidget.getHours();
            int min = this.timeWidget.getMinutes();
            int sec = this.timeWidget.getSeconds();
            GregorianCalendar calendar = new GregorianCalendar(year, month, day, hrs, min, sec);
            date = calendar.getTime();
        }
        return date;
    }

    protected void setDate(Date date) {
        if (date != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            if (this.dateWidget != null) {
                this.dateWidget.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
                this.dateWidget.redraw();
            }
            if (this.timeWidget != null) {
                this.timeWidget.setHours(calendar.get(11));
                this.timeWidget.setMinutes(calendar.get(12));
                this.timeWidget.setSeconds(calendar.get(13));
            }
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

